/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.framework.model.test.data;

import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.NamespaceContext;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import javax.xml.xpath.XPathVariableResolver;
import net.bpelunit.framework.control.util.BPELUnitUtil;
import net.bpelunit.framework.exception.SpecificationException;
import net.bpelunit.framework.model.test.activity.VelocityContextProvider;
import net.bpelunit.framework.model.test.data.DataSpecification;
import net.bpelunit.framework.model.test.report.ArtefactStatus;
import net.bpelunit.framework.model.test.report.ITestArtefact;
import net.bpelunit.framework.model.test.report.StateData;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReceiveCondition
implements ITestArtefact {
    private String fExpression;
    private String fExpectedValue;
    private String fActualValue;
    private DataSpecification fParent;
    private ArtefactStatus fStatus;
    private String fTemplate;

    public ReceiveCondition(DataSpecification rSpec, String condition, String template, String value) throws SpecificationException {
        this.fExpression = condition;
        this.fTemplate = template;
        this.fExpectedValue = value;
        this.fStatus = ArtefactStatus.createInitialStatus();
        this.fParent = rSpec;
        this.fActualValue = null;
        if (this.fExpression != null && this.fTemplate != null || this.fExpression == null && this.fTemplate == null) {
            throw new SpecificationException("Exactly one of (<template>, <expression>) should be used");
        }
    }

    public void evaluate(VelocityContextProvider activityContext, Element literalData, NamespaceContext context, XPathVariableResolver variableResolver) {
        XPath xpath = XPathFactory.newInstance().newXPath();
        xpath.setNamespaceContext(context);
        if (variableResolver != null) {
            xpath.setXPathVariableResolver(variableResolver);
        }
        try {
            String completeXPath;
            if (this.fExpression == null) {
                this.fExpression = this.fParent.expandTemplateToString(activityContext, this.fTemplate).trim();
            }
            if (!((Boolean)xpath.evaluate(completeXPath = "(" + this.fExpression + ") =" + this.fExpectedValue, literalData, XPathConstants.BOOLEAN)).booleanValue()) {
                String smartGuess = xpath.evaluate(this.fExpression, literalData);
                if (smartGuess != null) {
                    this.fActualValue = smartGuess;
                    if ("".equals(this.fActualValue)) {
                        this.fActualValue = "(no data)";
                    }
                }
                String sExpectedValue = xpath.evaluate(this.fExpectedValue, literalData);
                this.fStatus = ArtefactStatus.createFailedStatus(String.format("Condition failed. Obtained value was '%s', expected '%s'", smartGuess, sExpectedValue));
            } else {
                this.fStatus = ArtefactStatus.createPassedStatus();
            }
        }
        catch (Exception e) {
            Throwable root = BPELUnitUtil.findRootThrowable(e);
            this.fStatus = ArtefactStatus.createErrorStatus(root.getMessage());
        }
    }

    public String getExpression() {
        return this.fExpression;
    }

    public String getExpectedValue() {
        return this.fExpectedValue;
    }

    public String getActualValue() {
        return this.fActualValue;
    }

    public boolean isFailure() {
        return this.fStatus.isFailure();
    }

    public boolean isError() {
        return this.fStatus.isError();
    }

    @Override
    public String getName() {
        return "Receive Condition";
    }

    @Override
    public ITestArtefact getParent() {
        return this.fParent;
    }

    @Override
    public List<ITestArtefact> getChildren() {
        return new ArrayList<ITestArtefact>();
    }

    @Override
    public ArtefactStatus getStatus() {
        return this.fStatus;
    }

    @Override
    public List<StateData> getStateData() {
        ArrayList<StateData> stateData = new ArrayList<StateData>();
        stateData.addAll(this.fStatus.getAsStateData());
        stateData.add(new StateData("Expression", this.fExpression));
        stateData.add(new StateData("Value", this.fExpectedValue));
        if (this.fActualValue != null) {
            stateData.add(new StateData("Actual Data", this.fActualValue));
        }
        return stateData;
    }

    @Override
    public void reportProgress(ITestArtefact artefact) {
        this.fParent.reportProgress(artefact);
    }

    public String toString() {
        StringBuffer r = new StringBuffer();
        r.append(this.fExpression);
        r.append(" => Evaluation: ").append(this.fStatus);
        return r.toString();
    }
}

