/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.framework.model.test.data;

import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathVariableResolver;
import net.bpelunit.framework.model.test.data.ArrayNodeList;
import org.apache.velocity.context.Context;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContextXPathVariableResolver
implements XPathVariableResolver {
    private final Context templateContext;
    private final Map<String, Object> conversionCache = new HashMap<String, Object>();

    public ContextXPathVariableResolver(Context templateContext) {
        this.templateContext = templateContext;
    }

    @Override
    public Object resolveVariable(QName arg0) {
        String varName = arg0.getLocalPart();
        Object varValue = this.templateContext.get(varName);
        if (varValue instanceof Iterable) {
            if (this.conversionCache.get(varName) != null) {
                return this.conversionCache.get(varName);
            }
            NodeList nl = this.convertIterableToTree(varValue);
            this.conversionCache.put(varName, nl);
            return nl;
        }
        return varValue;
    }

    private NodeList convertIterableToTree(Object varValue) {
        Document doc;
        try {
            doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException e) {
            return null;
        }
        Element elem = doc.createElement("elements");
        doc.appendChild(elem);
        this.addElementsAsChildren((Iterable)varValue, doc, elem);
        ArrayNodeList nl = new ArrayNodeList();
        NodeList children = elem.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            nl.add(children.item(i));
        }
        return nl;
    }

    private void addElementsAsChildren(Iterable<?> collection, Document doc, Element currentElem) {
        for (Object item : collection) {
            Element childElem = doc.createElement("element");
            currentElem.appendChild(childElem);
            if (item instanceof Iterable) {
                this.addElementsAsChildren((Iterable)item, doc, childElem);
                continue;
            }
            childElem.setTextContent(item.toString());
        }
    }
}

