/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.framework.model.test.data;

import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.NamespaceContext;
import net.bpelunit.framework.exception.SpecificationException;
import net.bpelunit.framework.model.test.PartnerTrack;
import net.bpelunit.framework.model.test.activity.Activity;
import net.bpelunit.framework.model.test.data.ContextXPathVariableResolver;
import net.bpelunit.framework.model.test.data.DataSpecification;
import net.bpelunit.framework.model.test.data.ReceiveCondition;
import net.bpelunit.framework.model.test.data.XMLData;
import net.bpelunit.framework.model.test.report.ArtefactStatus;
import net.bpelunit.framework.model.test.report.ITestArtefact;
import net.bpelunit.framework.model.test.report.StateData;
import net.bpelunit.framework.xml.suite.XMLAnyElement;
import org.apache.velocity.context.Context;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompleteHumanTaskSpecification
extends DataSpecification {
    private PartnerTrack partnerTrack;
    private List<ReceiveCondition> conditions;
    private XmlObject inputXMLData;
    private XMLAnyElement outputXMLData;

    public CompleteHumanTaskSpecification(Activity parent, NamespaceContext nsContext, Element xmlAnyElement, PartnerTrack partnerTrack) throws SpecificationException {
        super(parent, nsContext);
        try {
            this.outputXMLData = XMLAnyElement.Factory.parse(xmlAnyElement, null);
            this.partnerTrack = partnerTrack;
        }
        catch (XmlException e) {
            throw new SpecificationException("Could not save XML Element data: " + e.getMessage(), e);
        }
    }

    @Override
    public String getName() {
        return "Complete Task Specification";
    }

    @Override
    public List<ITestArtefact> getChildren() {
        ArrayList<ITestArtefact> returner = new ArrayList<ITestArtefact>();
        for (ReceiveCondition c : this.conditions) {
            returner.add(c);
        }
        if (this.inputXMLData != null) {
            returner.add(new XMLData(this, "Input XML Data", this.inputXMLData.xmlText().trim()));
        } else {
            returner.add(new XMLData(this, "Input XML Data", "(no data)"));
        }
        returner.add(new XMLData(this, "Output XML Data", this.getOutputXMLData().trim()));
        return returner;
    }

    @Override
    public List<StateData> getStateData() {
        ArrayList<StateData> stateData = new ArrayList<StateData>();
        stateData.addAll(this.getStatus().getAsStateData());
        return stateData;
    }

    public String getOutputXMLData() {
        return this.outputXMLData.xmlText();
    }

    public XMLAnyElement handle(XmlObject input) {
        this.inputXMLData = input;
        this.validateConditions();
        return this.outputXMLData;
    }

    public void setConditions(List<ReceiveCondition> conditions) {
        this.conditions = conditions;
    }

    private void validateConditions() {
        Context conditionContext;
        try {
            conditionContext = this.partnerTrack.createVelocityContext();
        }
        catch (Exception e) {
            this.setStatus(ArtefactStatus.createFailedStatus(String.format("Could not create the Velocity context for this condition: %s", e.getLocalizedMessage())));
            return;
        }
        ContextXPathVariableResolver variableResolver = new ContextXPathVariableResolver(conditionContext);
        for (ReceiveCondition c : this.conditions) {
            c.evaluate(this.partnerTrack, (Element)this.inputXMLData.getDomNode(), this.getNamespaceContext(), variableResolver);
            if (c.isFailure()) {
                this.setStatus(ArtefactStatus.createFailedStatus(String.format("Condition '%s=%s' did not hold: %s", c.getExpression(), c.getExpectedValue(), c.getStatus().getMessage())));
                break;
            }
            if (!c.isError()) continue;
            this.setStatus(ArtefactStatus.createErrorStatus(String.format("Condition '%s=%s' had an error: %s.", c.getExpression(), c.getExpectedValue(), c.getStatus().getMessage())));
            break;
        }
    }
}

