/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.framework.model.test.activity;

import java.util.ArrayList;
import java.util.List;
import net.bpelunit.framework.exception.SynchronousSendException;
import net.bpelunit.framework.model.test.PartnerTrack;
import net.bpelunit.framework.model.test.activity.Activity;
import net.bpelunit.framework.model.test.activity.ActivityContext;
import net.bpelunit.framework.model.test.activity.TwoWayAsyncActivity;
import net.bpelunit.framework.model.test.data.SendDataSpecification;
import net.bpelunit.framework.model.test.report.ArtefactStatus;
import net.bpelunit.framework.model.test.report.ITestArtefact;
import net.bpelunit.framework.model.test.report.StateData;
import net.bpelunit.framework.model.test.wire.IncomingMessage;
import net.bpelunit.framework.model.test.wire.OutgoingMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SendAsync
extends Activity {
    private TwoWayAsyncActivity fParentActivity;
    private SendDataSpecification fSendSpec;
    private String fWrongBody;

    public SendAsync(PartnerTrack partnerTrack) {
        super(partnerTrack);
        this.fParentActivity = null;
    }

    public SendAsync(TwoWayAsyncActivity activity) {
        super(activity.getPartnerTrack());
        this.fParentActivity = activity;
    }

    public void initialize(SendDataSpecification spec) {
        this.fSendSpec = spec;
        this.setStatus(ArtefactStatus.createInitialStatus());
    }

    @Override
    public void run(ActivityContext context) {
        IncomingMessage incoming;
        this.fSendSpec.handle(context);
        if (this.fSendSpec.hasProblems()) {
            this.setStatus(this.fSendSpec.getStatus());
            return;
        }
        OutgoingMessage msg = new OutgoingMessage();
        msg.setSOAPAction(this.fSendSpec.getSOAPHTTPAction());
        msg.setTargetURL(this.fSendSpec.getTargetURL());
        msg.setBody(this.fSendSpec.getInWireFormat());
        try {
            this.fSendSpec.delay(context);
            incoming = context.sendMessage(msg);
        }
        catch (SynchronousSendException e) {
            this.setStatus(ArtefactStatus.createErrorStatus("HTTP Error while sending out synchronous message!", e));
            return;
        }
        catch (InterruptedException e) {
            this.setStatus(ArtefactStatus.createAbortedStatus("Aborting due to error in another partner track.", e));
            return;
        }
        catch (Exception e) {
            this.setStatus(ArtefactStatus.createAbortedStatus("Aborted while computing the delay for the send.", e));
            return;
        }
        if (incoming.getReturnCode() > 200 && incoming.getReturnCode() < 300) {
            this.setStatus(ArtefactStatus.createPassedStatus());
        } else {
            this.setStatus(ArtefactStatus.createErrorStatus("Asynchronous send got a non-2XX error code: " + incoming.getReturnCode(), null));
            this.fWrongBody = incoming.getBody();
        }
    }

    @Override
    public String getActivityCode() {
        return "SendAsync";
    }

    @Override
    public int getActivityCount() {
        return 1;
    }

    @Override
    public String getName() {
        return "Send Asynchronous";
    }

    @Override
    public ITestArtefact getParent() {
        if (this.fParentActivity != null) {
            return this.fParentActivity;
        }
        return this.getPartnerTrack();
    }

    @Override
    public List<ITestArtefact> getChildren() {
        ArrayList<ITestArtefact> children = new ArrayList<ITestArtefact>();
        children.add(this.fSendSpec);
        return children;
    }

    @Override
    public List<StateData> getStateData() {
        ArrayList<StateData> stateData = new ArrayList<StateData>();
        stateData.addAll(this.getStatus().getAsStateData());
        if (this.fWrongBody != null) {
            stateData.add(new StateData("Return Body", this.fWrongBody));
        }
        return stateData;
    }
}

