/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.framework.model.test.activity;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeoutException;
import net.bpelunit.framework.control.util.BPELUnitUtil;
import net.bpelunit.framework.model.test.PartnerTrack;
import net.bpelunit.framework.model.test.activity.ActivityContext;
import net.bpelunit.framework.model.test.activity.TwoWaySyncActivity;
import net.bpelunit.framework.model.test.data.DataCopyOperation;
import net.bpelunit.framework.model.test.report.ArtefactStatus;
import net.bpelunit.framework.model.test.report.ITestArtefact;
import net.bpelunit.framework.model.test.wire.IncomingMessage;
import net.bpelunit.framework.model.test.wire.OutgoingMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReceiveSendSync
extends TwoWaySyncActivity {
    private static final int HTTP_OK = 200;
    private static final int HTTP_INTERNAL_ERROR = 500;

    public ReceiveSendSync(PartnerTrack partnerTrack) {
        super(partnerTrack);
        this.setStatus(ArtefactStatus.createInitialStatus());
    }

    @Override
    public void run(ActivityContext context) {
        IncomingMessage incoming;
        context.setHeaderProcessor(this.getHeaderProcessor());
        context.setMapping(this.getMapping());
        try {
            incoming = context.receiveMessage(this.getPartnerTrack());
        }
        catch (TimeoutException e) {
            this.setStatus(ArtefactStatus.createErrorStatus("Timeout while waiting for incoming synchronous message", e));
            return;
        }
        catch (InterruptedException e) {
            this.setStatus(ArtefactStatus.createAbortedStatus("Aborted while waiting for incoming synchronous message", e));
            return;
        }
        this.getReceiveSpec().handle(context, incoming.getBody());
        OutgoingMessage msg = new OutgoingMessage();
        if (!this.getReceiveSpec().hasProblems()) {
            this.getSendSpec().handle(context);
            if (!this.getSendSpec().hasProblems()) {
                if (this.getSendSpec().isFault()) {
                    msg.setCode(500);
                } else {
                    msg.setCode(200);
                }
                msg.setBody(this.getSendSpec().getInWireFormat());
            } else {
                msg.setCode(500);
                msg.setBody(BPELUnitUtil.generateGenericSOAPFault());
            }
        } else {
            msg.setCode(500);
            msg.setBody(BPELUnitUtil.generateGenericSOAPFault());
        }
        try {
            this.getSendSpec().delay(context);
            context.postAnswer(this.getPartnerTrack(), msg);
            if (this.getReceiveSpec().hasProblems()) {
                this.setStatus(this.getReceiveSpec().getStatus());
            } else if (this.getSendSpec().hasProblems()) {
                this.setStatus(this.getSendSpec().getStatus());
            } else {
                this.setStatus(ArtefactStatus.createPassedStatus());
            }
        }
        catch (TimeoutException e) {
            this.setStatus(ArtefactStatus.createErrorStatus("Timeout occurred while waiting for synchronous answer to be sent.", e));
            return;
        }
        catch (InterruptedException e) {
            this.setStatus(ArtefactStatus.createAbortedStatus("Aborted while waiting for synchronous answer to be sent.", e));
            return;
        }
        catch (Exception e) {
            this.setStatus(ArtefactStatus.createAbortedStatus("Aborted while computing the delay for the send.", e));
            return;
        }
    }

    @Override
    public String getActivityCode() {
        return "ReceiveSendSync";
    }

    @Override
    public String getName() {
        return "Receive/Send Synchronous";
    }

    @Override
    public List<ITestArtefact> getChildren() {
        ArrayList<ITestArtefact> children = new ArrayList<ITestArtefact>();
        if (this.getMapping() != null) {
            for (DataCopyOperation copy : this.getMapping()) {
                children.add(copy);
            }
        }
        children.add(this.getReceiveSpec());
        children.add(this.getSendSpec());
        return children;
    }
}

