/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.framework.model.test.activity;

import java.util.ArrayList;
import java.util.List;
import net.bpelunit.framework.model.HumanPartner;
import net.bpelunit.framework.model.test.PartnerTrack;
import net.bpelunit.framework.model.test.activity.Activity;
import net.bpelunit.framework.model.test.activity.ActivityContext;
import net.bpelunit.framework.model.test.data.CompleteHumanTaskSpecification;
import net.bpelunit.framework.model.test.report.ArtefactStatus;
import net.bpelunit.framework.model.test.report.ITestArtefact;
import net.bpelunit.framework.model.test.report.StateData;
import net.bpelunit.framework.wsht.WSHTClient;
import net.bpelunit.framework.xml.suite.XMLAnyElement;
import org.apache.xmlbeans.XmlObject;
import org.example.wsHT.api.XMLTTask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompleteHumanTask
extends Activity {
    private String taskName;
    private int waitTime = 50;
    private int maxTimeOut = 10000;
    private CompleteHumanTaskSpecification dataSpec;
    private String taskId;

    public CompleteHumanTask(PartnerTrack pTrack) {
        super(pTrack);
    }

    public void initialize(CompleteHumanTaskSpecification spec) {
        this.dataSpec = spec;
        this.setStatus(ArtefactStatus.createInitialStatus());
    }

    public void setTaskName(String taskName) {
        this.taskName = taskName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(ActivityContext context) {
        HumanPartner partner = (HumanPartner)this.getPartner();
        WSHTClient client = partner.getWSHTClient();
        boolean locked = false;
        try {
            try {
                List<XMLTTask> taskList;
                int timeout = 0;
                do {
                    HumanPartner.WSHT_LOCK.lock();
                    locked = true;
                    taskList = client.getReadyTaskList(this.taskName).getTaskAbstractList();
                    if (taskList.size() == 0) {
                        HumanPartner.WSHT_LOCK.unlock();
                        locked = false;
                        timeout += this.waitTime;
                        Thread.sleep(this.waitTime);
                    }
                    if (timeout < this.maxTimeOut) continue;
                    this.setStatus(ArtefactStatus.createErrorStatus("Timeout while waiting for task " + this.taskName));
                    return;
                } while (taskList.size() == 0);
                XMLTTask taskToFinish = taskList.get(taskList.size() - 1);
                this.taskId = taskToFinish.getId();
                XmlObject data = client.getInput(taskToFinish.getId()).getTaskData();
                XMLAnyElement output = this.dataSpec.handle(data);
                client.completeTaskWithOutput(taskToFinish.getId(), output);
            }
            finally {
                if (locked) {
                    HumanPartner.WSHT_LOCK.unlock();
                }
            }
            if (this.dataSpec.hasProblems()) {
                this.setStatus(this.dataSpec.getStatus());
            } else {
                this.setStatus(ArtefactStatus.createPassedStatus());
            }
        }
        catch (Exception e) {
            this.setStatus(ArtefactStatus.createErrorStatus("Error while completing human task: " + e.getMessage(), e));
        }
    }

    @Override
    public int getActivityCount() {
        return 1;
    }

    @Override
    public String getActivityCode() {
        return "CompleteHumanTask";
    }

    @Override
    public String getName() {
        return "Complete Human Task";
    }

    @Override
    public ITestArtefact getParent() {
        return this.getPartnerTrack();
    }

    @Override
    public List<ITestArtefact> getChildren() {
        ArrayList<ITestArtefact> children = new ArrayList<ITestArtefact>();
        children.add(this.dataSpec);
        return children;
    }

    @Override
    public List<StateData> getStateData() {
        List<StateData> stateData = super.getStateData();
        stateData.add(new StateData("Task ID", this.taskId));
        return stateData;
    }
}

