/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.framework.model.test;

import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.bpelunit.framework.BPELUnitRunner;
import net.bpelunit.framework.control.ws.LocalHTTPServer;
import net.bpelunit.framework.exception.DeploymentException;
import net.bpelunit.framework.exception.TestCaseNotFoundException;
import net.bpelunit.framework.model.ProcessUnderTest;
import net.bpelunit.framework.model.test.ITestResultListener;
import net.bpelunit.framework.model.test.TestCase;
import net.bpelunit.framework.model.test.report.ArtefactStatus;
import net.bpelunit.framework.model.test.report.ITestArtefact;
import net.bpelunit.framework.model.test.report.StateData;
import org.apache.log4j.Logger;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;
import org.apache.velocity.tools.ToolContext;
import org.apache.velocity.tools.ToolManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestSuite
implements ITestArtefact {
    private String fName;
    private ProcessUnderTest fProcessUnderTest;
    private Map<String, TestCase> fTestCaseMap;
    private LocalHTTPServer fLocalServer;
    private List<ITestResultListener> fResultListeners;
    private List<TestCase> fTestCaseFilter;
    private boolean fCurrentlyRunning;
    private boolean fAbortedByUser;
    private TestCase fCurrentTestCase;
    private ArtefactStatus fStatus;
    private URL fBaseURL;
    private Logger fLogger;
    private String fSetUpVelocityScript;
    private final ToolManager toolManager = new ToolManager();

    public TestSuite(String suiteName, URL suiteBaseURL, ProcessUnderTest suiteProcessUnderTest) {
        this.fStatus = ArtefactStatus.createInitialStatus();
        this.fResultListeners = new ArrayList<ITestResultListener>();
        this.fLogger = Logger.getLogger(this.getClass());
        this.fName = suiteName;
        this.fProcessUnderTest = suiteProcessUnderTest;
        this.fCurrentlyRunning = false;
        this.fTestCaseMap = new LinkedHashMap<String, TestCase>();
        this.setBaseURL(suiteBaseURL);
    }

    public void addTestCase(TestCase test) {
        this.fTestCaseMap.put(test.getName().toLowerCase(), test);
    }

    public void setFilter(String testCaseName) throws TestCaseNotFoundException {
        ArrayList<String> tempList = new ArrayList<String>();
        tempList.add(testCaseName);
        this.setFilter(tempList);
    }

    public void setFilter(List<String> testCaseNames) throws TestCaseNotFoundException {
        ArrayList<TestCase> filtered = new ArrayList<TestCase>();
        for (String name : testCaseNames) {
            this.addTestCaseToFilter(filtered, name);
        }
        this.fTestCaseFilter = filtered;
    }

    public void setUp() throws DeploymentException {
        this.fLogger.info((Object)"Now starting local HTTP server...");
        try {
            this.getLocalServer().startServer();
        }
        catch (Exception e) {
            this.fLogger.error((Object)("Error starting local HTTP server: " + e.getMessage()));
            throw new DeploymentException("Could not start local HTTP server - maybe the address is in use? ", e);
        }
        this.fLogger.info((Object)("Now deploying PUT: " + this.fProcessUnderTest));
        this.fProcessUnderTest.deploy();
    }

    public void shutDown() throws DeploymentException {
        this.fLogger.info((Object)"Now stopping fixture server...");
        try {
            this.getLocalServer().stopServer();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (this.fProcessUnderTest.isDeployed()) {
            this.fLogger.info((Object)("Now undeploying: " + this.fProcessUnderTest));
            this.fProcessUnderTest.undeploy();
        }
    }

    public void run() {
        this.fLogger.info((Object)("Now starting test suite: " + this));
        this.fCurrentTestCase = null;
        this.fCurrentlyRunning = true;
        boolean error = false;
        boolean failure = false;
        if (this.fTestCaseFilter == null) {
            this.fTestCaseFilter = new ArrayList<TestCase>(this.fTestCaseMap.values());
        }
        Iterator<TestCase> i$ = this.fTestCaseFilter.iterator();
        while (i$.hasNext()) {
            TestCase testCase;
            this.fCurrentTestCase = testCase = i$.next();
            testCase.run();
            try {
                this.fProcessUnderTest.cleanUpAfterTestCase();
            }
            catch (Exception ex) {
                this.fLogger.error((Object)ex.getMessage(), (Throwable)ex);
                failure = true;
            }
            if (testCase.getStatus().isError()) {
                error = true;
                if (BPELUnitRunner.isHaltOnError()) break;
            }
            if (testCase.getStatus().isFailure()) {
                failure = true;
                if (BPELUnitRunner.isHaltOnFailure()) break;
            }
            if (!this.fAbortedByUser) continue;
            break;
        }
        this.fCurrentTestCase = null;
        this.fStatus = error ? ArtefactStatus.createErrorStatus("A test case had an error") : (failure ? ArtefactStatus.createFailedStatus("A test case had a failure") : (this.fAbortedByUser ? ArtefactStatus.createAbortedStatus("Aborted by user") : ArtefactStatus.createPassedStatus()));
        this.fCurrentlyRunning = false;
        this.fLogger.info((Object)("Now stopping test suite: " + this));
    }

    public void addResultListener(ITestResultListener listener) {
        this.fResultListeners.add(listener);
    }

    public void removeResultListener(ITestResultListener listener) {
        this.fResultListeners.remove(listener);
    }

    public void startTestCase(TestCase case1) {
        for (ITestResultListener listener : this.fResultListeners) {
            listener.testCaseStarted(case1);
        }
    }

    public void endTestCase(TestCase case1) {
        for (ITestResultListener listener : this.fResultListeners) {
            listener.testCaseEnded(case1);
        }
    }

    public boolean hasTestCase(String testCaseName) {
        return this.fTestCaseMap.containsKey(testCaseName.toLowerCase());
    }

    public int getTestCaseCount() {
        return this.fTestCaseMap.size();
    }

    public ProcessUnderTest getProcessUnderTest() {
        return this.fProcessUnderTest;
    }

    public void abortTest() {
        if (this.isRunning()) {
            this.fAbortedByUser = true;
            if (this.fCurrentTestCase != null) {
                this.fCurrentTestCase.abortTest();
            }
        }
    }

    public boolean isRunning() {
        return this.fCurrentlyRunning;
    }

    public LocalHTTPServer getLocalServer() {
        if (this.fLocalServer == null) {
            this.fLocalServer = new LocalHTTPServer(this.getBaseURL().getPort(), this.getBaseURL().getPath());
        }
        return this.fLocalServer;
    }

    public URL getBaseURL() {
        return this.fBaseURL;
    }

    public final void setBaseURL(URL fBaseURL) {
        this.fBaseURL = fBaseURL;
    }

    public Context createVelocityContext() {
        try {
            Velocity.init();
        }
        catch (Exception e) {
            Velocity.init();
        }
        ToolContext ctx = this.toolManager.createContext();
        ctx.put("baseURL", (Object)this.getBaseURL().toString());
        ctx.put("collections", Collections.class);
        ctx.put("putName", (Object)this.fProcessUnderTest.getName());
        ctx.put("testSuiteName", (Object)this.getRawName());
        ctx.put("testCaseCount", (Object)this.getTestCaseCount());
        if (this.fSetUpVelocityScript != null) {
            StringWriter sW = new StringWriter();
            Velocity.evaluate((Context)ctx, (Writer)sW, (String)"setUpTestSuite", (String)this.fSetUpVelocityScript);
        }
        return ctx;
    }

    @Override
    public String getName() {
        return "Test Suite " + this.fName;
    }

    public String getRawName() {
        return this.fName;
    }

    public String getSafeName() {
        return this.fName.replaceAll("\\.|/|\\s|\\\\", "-");
    }

    @Override
    public List<ITestArtefact> getChildren() {
        ArrayList<ITestArtefact> children = new ArrayList<ITestArtefact>();
        for (TestCase testCase : this.fTestCaseMap.values()) {
            children.add(testCase);
        }
        return children;
    }

    @Override
    public ITestArtefact getParent() {
        return null;
    }

    @Override
    public ArtefactStatus getStatus() {
        return this.fStatus;
    }

    @Override
    public List<StateData> getStateData() {
        return this.fStatus.getAsStateData();
    }

    @Override
    public synchronized void reportProgress(ITestArtefact artefact) {
        for (ITestResultListener listener : this.fResultListeners) {
            listener.progress(artefact);
        }
    }

    private void addTestCaseToFilter(List<TestCase> filtered, String name) throws TestCaseNotFoundException {
        TestCase testCase = this.fTestCaseMap.get(name.toLowerCase());
        if (testCase == null) {
            throw new TestCaseNotFoundException("Test Case with name \"" + name + "\" does not exist in this suite.");
        }
        filtered.add(testCase);
    }

    public String toString() {
        return "TestSuite \"" + this.getName() + "\" (" + this.getTestCaseCount() + " test cases)";
    }

    public List<String> getTestCases() {
        ArrayList<String> testCases = new ArrayList<String>();
        Iterator<TestCase> iter = this.fTestCaseMap.values().iterator();
        while (iter.hasNext()) {
            testCases.add(iter.next().getName());
        }
        return testCases;
    }

    public String getSetUpVelocityScript() {
        return this.fSetUpVelocityScript;
    }

    public void setSetUpVelocityScript(String script) {
        this.fSetUpVelocityScript = script;
    }
}

