/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.framework.model;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.TimeZone;
import java.util.concurrent.locks.ReentrantLock;
import javax.xml.parsers.ParserConfigurationException;
import net.bpelunit.framework.exception.SpecificationException;
import net.bpelunit.framework.model.AbstractPartner;
import net.bpelunit.framework.wsht.WSHTClient;
import org.apache.xmlbeans.XmlException;
import org.example.wsHT.api.XMLTStatus;
import org.example.wsHT.api.XMLTTask;
import org.example.wsHT.api.xsd.XMLGetMyTasksResponseDocument;
import org.xml.sax.SAXException;

public class HumanPartner
extends AbstractPartner {
    public static final ReentrantLock WSHT_LOCK = new ReentrantLock();
    private URL endPoint;
    private String username;
    private String password;
    private Calendar startTime = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
    private WSHTClient wshtClient;

    public URL getEndPoint() {
        return this.endPoint;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public WSHTClient getWSHTClient() {
        return this.wshtClient;
    }

    public HumanPartner(String name, URL baseURL, String endPoint, String username, String password) throws SpecificationException {
        super(name, baseURL.toString());
        try {
            this.endPoint = new URL(endPoint);
            this.username = username;
            this.password = password;
            this.wshtClient = new WSHTClient(this.endPoint, username, password){

                public XMLGetMyTasksResponseDocument.GetMyTasksResponse getTaskList(String taskName, XMLTStatus.Enum[] state) throws IOException, XmlException, ParserConfigurationException, SAXException {
                    XMLGetMyTasksResponseDocument.GetMyTasksResponse taskList = super.getTaskList(taskName, state);
                    HumanPartner.this.filterOutPreviouslyExistingTasks(taskList);
                    return taskList;
                }
            };
        }
        catch (MalformedURLException e) {
            throw new SpecificationException("Invalid WS-HT Endpoint (URL) for human partner " + name, e);
        }
    }

    protected void filterOutPreviouslyExistingTasks(XMLGetMyTasksResponseDocument.GetMyTasksResponse taskList) {
        ArrayList<XMLTTask> tasksToBeRemoved = new ArrayList<XMLTTask>();
        for (XMLTTask t : taskList.getTaskAbstractList()) {
            if (!t.getCreatedOn().before(this.startTime)) continue;
            tasksToBeRemoved.add(t);
        }
        taskList.getTaskAbstractList().removeAll(tasksToBeRemoved);
    }
}

