/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.framework.coverage.result.statistic.impl;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.bpelunit.framework.coverage.result.statistic.IFileStatistic;
import net.bpelunit.framework.coverage.result.statistic.IStatistic;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileStatistic
implements IFileStatistic {
    private String bpelFileName;
    private Map<String, IStatistic> statistics;

    public FileStatistic(String bpelFileName) {
        this.bpelFileName = bpelFileName;
        this.statistics = new TreeMap<String, IStatistic>();
    }

    @Override
    public String getBPELFilename() {
        return this.bpelFileName;
    }

    @Override
    public Collection<IStatistic> getStatistics() {
        return this.statistics.values();
    }

    @Override
    public void setStatistics(List<IStatistic> statistics) {
        for (IStatistic statistic : statistics) {
            this.statistics.put(statistic.getName(), statistic);
            List<IStatistic> subStatistics = statistic.getSubStatistics();
            if (subStatistics == null) continue;
            for (IStatistic subStatistic : subStatistics) {
                this.statistics.put(subStatistic.getName(), subStatistic);
            }
        }
    }

    @Override
    public IStatistic getStatistic(String name) {
        return this.statistics.get(name);
    }
}

