/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.framework.coverage.receiver;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.bpelunit.framework.coverage.annotation.MetricsManager;
import net.bpelunit.framework.coverage.annotation.metrics.IMetric;
import net.bpelunit.framework.coverage.receiver.MarkerState;
import net.bpelunit.framework.coverage.result.statistic.IFileStatistic;
import net.bpelunit.framework.coverage.result.statistic.impl.FileStatistic;

public class MarkersRegistryForBPELFile {
    private String fileName;
    private Map<String, Map<String, MarkerState>> allMetricsTable;
    private MetricsManager metricManager;

    public MarkersRegistryForBPELFile(String filename, MetricsManager metricManager) {
        this.fileName = filename;
        this.metricManager = metricManager;
        this.prepareStructur(metricManager);
    }

    public String getBPELFileName() {
        return this.fileName;
    }

    public void registerMarker(String marker, MarkerState status) {
        String prefix = marker.substring(0, marker.indexOf(95));
        this.allMetricsTable.get(prefix).put(marker, status);
    }

    private void prepareStructur(MetricsManager metricsManager) {
        List<IMetric> metrics = metricsManager.getMetrics();
        this.allMetricsTable = new Hashtable<String, Map<String, MarkerState>>();
        for (IMetric metric : metrics) {
            Iterator<String> iterator = metric.getMarkersId().iterator();
            while (iterator.hasNext()) {
                this.allMetricsTable.put(iterator.next(), new Hashtable());
            }
        }
    }

    public IFileStatistic getFileStatistic() {
        FileStatistic fileStatistic = new FileStatistic(this.fileName);
        fileStatistic.setStatistics(this.metricManager.createStatistics(this.allMetricsTable));
        return fileStatistic;
    }
}

