/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.framework.coverage.annotation.metrics.branchcoverage.impl;

import net.bpelunit.framework.coverage.annotation.metrics.branchcoverage.BranchMetricHandler;
import net.bpelunit.framework.coverage.annotation.metrics.branchcoverage.IStructuredActivityHandler;
import net.bpelunit.framework.coverage.annotation.tools.bpelxmltools.BpelXMLTools;
import net.bpelunit.framework.coverage.annotation.tools.bpelxmltools.exprlang.ExpressionLanguage;
import net.bpelunit.framework.coverage.exceptions.BpelException;
import net.bpelunit.framework.coverage.receiver.MarkersRegisterForArchive;
import org.jdom.Content;
import org.jdom.Element;

public class RepeatUntilHandler
implements IStructuredActivityHandler {
    private MarkersRegisterForArchive markersRegistry;

    public RepeatUntilHandler(MarkersRegisterForArchive markersRegistry) {
        this.markersRegistry = markersRegistry;
    }

    public void insertBranchMarkers(Element structuredActivity) throws BpelException {
        this.branchFromConditionToActivity(structuredActivity);
        this.branchFromActivityToCondition(structuredActivity);
    }

    private void branchFromActivityToCondition(Element element) throws BpelException {
        Element activity = BpelXMLTools.getFirstEnclosedActivity(element);
        if (element == null) {
            throw new BpelException("Missing required activity");
        }
        this.markersRegistry.registerMarker(BranchMetricHandler.insertLabelAfterAllActivities(activity));
    }

    private void branchFromConditionToActivity(Element element) throws BpelException {
        Element countVariable = BpelXMLTools.insertNewIntVariable(null, null);
        Element initializeAssign = BpelXMLTools.createInitializeAssign(countVariable);
        this.insert(initializeAssign, element);
        Element increesAssign = BpelXMLTools.createIncreesAssign(countVariable);
        this.insertIncreesAssign(increesAssign, element);
        this.insertIfConstruct(element, countVariable);
    }

    private void insertIfConstruct(Element element, Element countVariable) throws BpelException {
        Element activity = BpelXMLTools.getFirstEnclosedActivity(element);
        if (activity == null) {
            throw new BpelException("Missing required activity");
        }
        if (!BpelXMLTools.isSequence(activity)) {
            activity = BpelXMLTools.ensureElementIsInSequence(activity);
        }
        Element ifElement = BpelXMLTools.createIfActivity(ExpressionLanguage.getInstance(0).valueOf(countVariable.getAttributeValue("name")) + "=1");
        Element sequence = BpelXMLTools.createSequence();
        ifElement.addContent((Content)sequence);
        activity.addContent(0, (Content)ifElement);
        this.markersRegistry.registerMarker(BranchMetricHandler.insertLabelBevorAllActivities(sequence));
    }

    private void insertIncreesAssign(Element increaseAssign, Element element) throws BpelException {
        Element activity = BpelXMLTools.getFirstEnclosedActivity(element);
        if (activity == null) {
            throw new BpelException("Missing required activity");
        }
        if (!BpelXMLTools.isSequence(activity)) {
            activity = BpelXMLTools.ensureElementIsInSequence(activity);
        }
        activity.addContent((Content)increaseAssign);
    }

    private void insert(Element initializeAssign, Element element) {
        Element sequence = BpelXMLTools.ensureElementIsInSequence(element);
        sequence.addContent(sequence.indexOf((Content)element), (Content)initializeAssign);
    }
}

