/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.framework.coverage.annotation.metrics.branchcoverage;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.bpelunit.framework.coverage.annotation.MetricsManager;
import net.bpelunit.framework.coverage.annotation.metrics.IMetric;
import net.bpelunit.framework.coverage.annotation.metrics.IMetricHandler;
import net.bpelunit.framework.coverage.annotation.metrics.branchcoverage.BranchMetricHandler;
import net.bpelunit.framework.coverage.annotation.tools.bpelxmltools.BpelXMLTools;
import net.bpelunit.framework.coverage.exceptions.BpelException;
import net.bpelunit.framework.coverage.receiver.MarkerState;
import net.bpelunit.framework.coverage.receiver.MarkersRegisterForArchive;
import net.bpelunit.framework.coverage.result.statistic.IStatistic;
import net.bpelunit.framework.coverage.result.statistic.impl.Statistic;
import org.jdom.Element;
import org.jdom.filter.ElementFilter;
import org.jdom.filter.Filter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BranchMetric
implements IMetric {
    public static final String METRIC_NAME = "BranchCoverage";
    private IMetricHandler metricHandler;
    private List<Element> elementsOfBPEL = null;

    public BranchMetric(MarkersRegisterForArchive markersRegistry) {
        this.metricHandler = new BranchMetricHandler(markersRegistry);
    }

    @Override
    public String getName() {
        return METRIC_NAME;
    }

    @Override
    public List<String> getMarkersId() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("branch");
        return list;
    }

    @Override
    public IStatistic createStatistic(Map<String, Map<String, MarkerState>> allMarkers) {
        Statistic statistic = new Statistic(METRIC_NAME);
        statistic.setStateList(MetricsManager.getStatus("branch", allMarkers));
        return statistic;
    }

    @Override
    public void setOriginalBPELProcess(Element process) {
        Iterator iter = process.getDescendants((Filter)new ElementFilter(process.getNamespace()));
        this.elementsOfBPEL = new ArrayList<Element>();
        while (iter.hasNext()) {
            Element nextElement = (Element)iter.next();
            if (!BpelXMLTools.isStructuredActivity(nextElement)) continue;
            this.elementsOfBPEL.add(nextElement);
        }
    }

    @Override
    public void insertMarkers() throws BpelException {
        if (this.elementsOfBPEL != null) {
            this.metricHandler.insertMarkersForMetric(this.elementsOfBPEL);
            this.elementsOfBPEL = null;
        }
    }
}

