/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.framework.coverage.annotation.metrics.activitycoverage;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.bpelunit.framework.coverage.annotation.MetricsManager;
import net.bpelunit.framework.coverage.annotation.metrics.IMetric;
import net.bpelunit.framework.coverage.annotation.metrics.IMetricHandler;
import net.bpelunit.framework.coverage.annotation.metrics.activitycoverage.ActivityMetricHandler;
import net.bpelunit.framework.coverage.exceptions.BpelException;
import net.bpelunit.framework.coverage.receiver.MarkerState;
import net.bpelunit.framework.coverage.receiver.MarkersRegisterForArchive;
import net.bpelunit.framework.coverage.result.statistic.IStatistic;
import net.bpelunit.framework.coverage.result.statistic.impl.Statistic;
import org.jdom.Element;
import org.jdom.filter.ElementFilter;
import org.jdom.filter.Filter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActivityMetric
implements IMetric {
    public static final String METRIC_NAME = "ActivityCoverage";
    private List<String> activitiesToRespect = new ArrayList<String>();
    private IMetricHandler metricHandler;
    private List<Element> elementsOfBPEL = null;

    public ActivityMetric(List<String> activitesToRespect, MarkersRegisterForArchive markersRegistry) {
        if (activitesToRespect != null) {
            for (String basicActivity : activitesToRespect) {
                this.activitiesToRespect.add(basicActivity);
            }
        }
        this.metricHandler = new ActivityMetricHandler(markersRegistry);
    }

    @Override
    public String getName() {
        return METRIC_NAME;
    }

    @Override
    public List<String> getMarkersId() {
        return this.activitiesToRespect;
    }

    @Override
    public IStatistic createStatistic(Map<String, Map<String, MarkerState>> allMarkers) {
        Statistic statistic = new Statistic(METRIC_NAME);
        for (String label : this.activitiesToRespect) {
            Statistic subStatistic = new Statistic("ActivityCoverage: " + label);
            List<MarkerState> statusListe = MetricsManager.getStatus(label, allMarkers);
            subStatistic.setStateList(statusListe);
            statistic.addSubStatistic(subStatistic);
        }
        return statistic;
    }

    @Override
    public void setOriginalBPELProcess(Element process) {
        ElementFilter filter = new ElementFilter(process.getNamespace());
        this.elementsOfBPEL = new ArrayList<Element>();
        Iterator iter = process.getDescendants((Filter)filter);
        while (iter.hasNext()) {
            Element basicActivity = (Element)iter.next();
            if (!this.activitiesToRespect.contains(basicActivity.getName())) continue;
            this.elementsOfBPEL.add(basicActivity);
        }
    }

    @Override
    public void insertMarkers() throws BpelException {
        if (this.elementsOfBPEL != null) {
            this.metricHandler.insertMarkersForMetric(this.elementsOfBPEL);
            this.elementsOfBPEL = null;
        }
    }
}

