/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.framework.coverage;

import de.schlichtherle.io.ArchiveException;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.bpelunit.framework.coverage.exceptions.ArchiveFileException;
import org.apache.commons.io.FilenameUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ArchiveUtil {
    private ArchiveUtil() {
    }

    public static String createArchivecopy(String archive) throws ArchiveFileException {
        String fileName = FilenameUtils.getName((String)archive);
        String pfad = FilenameUtils.getFullPath((String)archive);
        String nameOfCopy = '_' + fileName;
        de.schlichtherle.io.File copyFile = new de.schlichtherle.io.File(FilenameUtils.concat((String)pfad, (String)nameOfCopy));
        de.schlichtherle.io.File file = new de.schlichtherle.io.File(archive);
        copyFile.copyAllFrom((File)file);
        try {
            de.schlichtherle.io.File.umount((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        }
        catch (ArchiveException e) {
            throw new ArchiveFileException("Could not create copy of bpr-archive", e);
        }
        return copyFile.getAbsolutePath();
    }

    public static List<String> getBPELFileList(String archive) {
        ArrayList<String> bpelFiles = new ArrayList<String>();
        de.schlichtherle.io.File file = new de.schlichtherle.io.File(archive);
        ArchiveUtil.searchChildrenBPEL(file, bpelFiles);
        return bpelFiles;
    }

    private static void searchChildrenBPEL(de.schlichtherle.io.File file, List<String> bpelFiles) {
        File[] files = file.listFiles();
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                ArchiveUtil.searchChildrenBPEL((de.schlichtherle.io.File)files[i], bpelFiles);
            }
        } else if (FilenameUtils.getExtension((String)file.getName()).equals("bpel")) {
            bpelFiles.add(file.getAbsolutePath());
        }
    }

    public static void deleteArchive(String archive) {
        if (archive == null) {
            return;
        }
        if (archive.endsWith(".zip")) {
            new de.schlichtherle.io.File(archive).deleteAll();
        } else {
            ArchiveUtil.deleteDir(new de.schlichtherle.io.File(archive));
        }
    }

    public static void closeArchives() {
        try {
            de.schlichtherle.io.File.umount((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        }
        catch (ArchiveException archiveException) {
            // empty catch block
        }
    }

    private static boolean deleteDir(de.schlichtherle.io.File dir) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            for (int i = 0; i < children.length; ++i) {
                boolean success = ArchiveUtil.deleteDir(new de.schlichtherle.io.File((File)dir, children[i]));
                if (success) continue;
                return false;
            }
        }
        return dir.delete();
    }
}

