/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.framework.control.util;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.soap.Detail;
import javax.xml.soap.DetailEntry;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPMessage;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.bpelunit.framework.control.util.BPELUnitConstants;
import org.apache.commons.lang.StringUtils;
import org.apache.xmlbeans.XmlOptions;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class BPELUnitUtil {
    private static final int INDENTION_SIZE = 4;
    public static final String DUMMY_ELEMENT_NAME = "literalData";
    private static DocumentBuilder fgDocumentBuilder;

    private BPELUnitUtil() {
    }

    public static void initializeParsing() throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        fgDocumentBuilder = factory.newDocumentBuilder();
    }

    public static Element generateDummyElementNode() {
        Document document = fgDocumentBuilder.newDocument();
        Element root = document.createElement(DUMMY_ELEMENT_NAME);
        document.appendChild(root);
        return root;
    }

    public static String generateGenericSOAPFault() {
        try {
            MessageFactory mFactory = MessageFactory.newInstance();
            SOAPMessage message = mFactory.createMessage();
            SOAPBody body = message.getSOAPBody();
            SOAPFault fault = body.addFault(BPELUnitConstants.SOAP_FAULT_CODE_CLIENT, "BPELUnit Framework Generated Fault");
            Detail detail = fault.addDetail();
            DetailEntry entry = detail.addDetailEntry(new QName("http://www.bpelunit.org/framework/error", "BPELUnitFault"));
            entry.addTextNode("The BPELUnit test framework has detected a test failure or error. This test case is aborted.");
            ByteArrayOutputStream b = new ByteArrayOutputStream();
            message.writeTo((OutputStream)b);
            return b.toString();
        }
        catch (Exception e) {
            return "(internal fault)";
        }
    }

    public static String removeSpaceLineBreaks(String string) {
        if (string == null) {
            return "";
        }
        String v = string.trim();
        v = StringUtils.remove((String)v, (char)'\n');
        v = StringUtils.remove((String)v, (char)'\r');
        v = StringUtils.remove((String)v, (char)'\t');
        return v;
    }

    public static Throwable findRootThrowable(Exception e) {
        Throwable f = e;
        while (f.getMessage() == null && f.getCause() != null) {
            f = f.getCause();
        }
        return f;
    }

    public static String toFormattedString(Document element) {
        try {
            return BPELUnitUtil.serializeXML(element);
        }
        catch (TransformerException e) {
            return "(no data)";
        }
    }

    private static String serializeXML(Node node) throws TransformerException {
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer t = tf.newTransformer();
        t.setOutputProperty("indent", "yes");
        t.setOutputProperty("method", "xml");
        ByteArrayOutputStream bOS = new ByteArrayOutputStream();
        t.transform(new DOMSource(node), new StreamResult(bOS));
        return bOS.toString();
    }

    public static XmlOptions getDefaultXMLOptions() {
        XmlOptions opts = new XmlOptions();
        opts.setSavePrettyPrint();
        opts.setSavePrettyPrintIndent(4);
        return opts;
    }
}

