/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.framework.control.soap;

import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import javax.xml.soap.SOAPMessage;
import net.bpelunit.framework.control.ext.ISOAPEncoder;
import net.bpelunit.framework.control.util.BPELUnitUtil;
import net.bpelunit.framework.exception.SOAPEncodingException;
import net.bpelunit.framework.model.test.data.SOAPOperationCallIdentifier;
import net.bpelunit.framework.model.test.data.SOAPOperationDirectionIdentifier;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RPCLiteralEncoder
implements ISOAPEncoder {
    private static final String RPC_WRAPPER_NAMESPACE_PREFIX = "rpcwrappernsprefix";

    public SOAPMessage construct(SOAPOperationCallIdentifier operation, Element literalData, QName faultCode, String faultString) throws SOAPEncodingException {
        try {
            SOAPBody body;
            if (operation.isFault()) {
                throw new SOAPEncodingException("RPC style cannot be used with SOAP faults: check section 3.6 of the WSDL 1.1 standard");
            }
            MessageFactory mFactory = MessageFactory.newInstance();
            SOAPFactory sFactory = SOAPFactory.newInstance();
            SOAPMessage message = mFactory.createMessage();
            SOAPBody data = body = message.getSOAPBody();
            String bodyNamespace = operation.getBodyNamespace();
            String operationName = operation.getName();
            Element firstElement = this.getFirstElementChild(literalData);
            SOAPElement newWrapper = sFactory.createElement(operation.getDirection() == SOAPOperationDirectionIdentifier.INPUT ? operationName : operationName + "Response", RPC_WRAPPER_NAMESPACE_PREFIX, bodyNamespace);
            String firstElementName = firstElement != null ? firstElement.getLocalName() : null;
            String firstElementNS = firstElement != null ? firstElement.getNamespaceURI() : null;
            NodeList partNodes = bodyNamespace.equals(firstElementNS) && (operationName.equals(firstElementName) || (operationName + "Response").equals(firstElementName)) ? firstElement.getChildNodes() : literalData.getChildNodes();
            for (int i = 0; i < partNodes.getLength(); ++i) {
                Node part = partNodes.item(i);
                if (!(part instanceof Element)) continue;
                Element actual = (Element)partNodes.item(i);
                SOAPElement copy = sFactory.createElement(actual);
                if (copy.getNamespaceURI() != null) {
                    copy = copy.setElementQName(new QName(null, copy.getLocalName()));
                }
                newWrapper.addChildElement(copy);
            }
            data.addChildElement(newWrapper);
            return message;
        }
        catch (SOAPException e) {
            throw new SOAPEncodingException("A SOAPException occurred in the DocumentLiteralEncoder while encoding to operation " + operation, e);
        }
    }

    public Element deconstruct(SOAPOperationCallIdentifier operation, SOAPMessage message) throws SOAPEncodingException {
        try {
            SOAPBody body = message.getSOAPBody();
            if (operation.isFault()) {
                throw new SOAPEncodingException("rpc style cannot be used with SOAP faults: check section 3.6 of the WSDL 1.1 standard");
            }
            SOAPBody data = body;
            SOAPElement rpcWrapper = null;
            Iterator childElements = data.getChildElements();
            while (childElements.hasNext()) {
                Object current = childElements.next();
                if (!(current instanceof SOAPElement)) continue;
                rpcWrapper = (SOAPElement)current;
                break;
            }
            if (rpcWrapper == null) {
                throw new SOAPEncodingException("Incoming SOAP message for operation " + operation + " does not have a RPC Wrapper element.");
            }
            Element rawRoot = BPELUnitUtil.generateDummyElementNode();
            Iterator i = rpcWrapper.getChildElements();
            while (i.hasNext()) {
                Object current = i.next();
                if (!(current instanceof SOAPElement)) continue;
                SOAPElement element = (SOAPElement)current;
                rawRoot.appendChild(rawRoot.getOwnerDocument().importNode((Node)element, true));
            }
            return rawRoot;
        }
        catch (SOAPException e) {
            throw new SOAPEncodingException("A SOAPException occurred in the RPCLiteralEncoder while decoding for operation " + operation, e);
        }
    }

    private Element getFirstElementChild(Node literalData) {
        for (Node firstElement = literalData.getFirstChild(); firstElement != null; firstElement = firstElement.getNextSibling()) {
            if (!(firstElement instanceof Element)) continue;
            return (Element)firstElement;
        }
        return null;
    }
}

