/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.framework.base;

import java.io.File;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.bpelunit.framework.BPELUnitRunner;
import net.bpelunit.framework.control.ext.ExtensionRegistry;
import net.bpelunit.framework.control.ext.IBPELDeployer;
import net.bpelunit.framework.control.ext.IDataSource;
import net.bpelunit.framework.control.ext.IHeaderProcessor;
import net.bpelunit.framework.control.ext.ISOAPEncoder;
import net.bpelunit.framework.coverage.CoverageMeasurementTool;
import net.bpelunit.framework.exception.ConfigurationException;
import net.bpelunit.framework.exception.SpecificationException;
import org.apache.commons.io.FilenameUtils;

public abstract class BPELUnitBaseRunner
extends BPELUnitRunner {
    public static final String CONFIG_DIR = "conf";
    public static final String BPELUNIT_HOME_ENV = "BPELUNIT_HOME";
    public static final String EXTENSIONS_FILE_NAME = "extensions.xml";
    public static final String DEPLOYER_CONFIG_FILE_NAME = "configuration.xml";
    public static final String COVERAGETOOL_CONFIG_FILE_NAME = "coverageMetricsConfiguration.xml";
    private String fHomeDirectory;

    public void configureInit() throws ConfigurationException {
        this.setHomeDirectory(System.getenv(BPELUNIT_HOME_ENV));
    }

    public void configureExtensions() throws ConfigurationException {
        String extensionsFile = FilenameUtils.concat((String)this.fHomeDirectory, (String)FilenameUtils.concat((String)CONFIG_DIR, (String)EXTENSIONS_FILE_NAME));
        if (extensionsFile != null && new File(extensionsFile).exists()) {
            try {
                ExtensionRegistry.loadRegistry(new File(extensionsFile).toURI().toURL(), BPELUnitBaseRunner.isSkipUnknownExtensions());
            }
            catch (MalformedURLException e) {
                throw new ConfigurationException("BPELUnit could not locate the extension file: " + extensionsFile, e);
            }
        } else {
            ExtensionRegistry.loadRegistry(this.getClass().getResource("/conf/extensions.xml"), BPELUnitBaseRunner.isSkipUnknownExtensions());
        }
    }

    public void configureDeployers() throws ConfigurationException {
        String deploymentConfigFile = FilenameUtils.concat((String)this.fHomeDirectory, (String)FilenameUtils.concat((String)CONFIG_DIR, (String)DEPLOYER_CONFIG_FILE_NAME));
        if (deploymentConfigFile != null && new File(deploymentConfigFile).exists()) {
            try {
                ExtensionRegistry.loadDeploymentConfiguration(new File(deploymentConfigFile).toURI().toURL());
            }
            catch (MalformedURLException e) {
                throw new ConfigurationException("BPELUnit could not locate the deployer config file: " + deploymentConfigFile, e);
            }
        } else {
            ExtensionRegistry.loadDeploymentConfiguration(this.getClass().getResource("/conf/configuration.xml"));
        }
    }

    protected void setHomeDirectory(String homeDirectory) throws ConfigurationException {
        this.fHomeDirectory = homeDirectory;
    }

    public abstract void configureLogging() throws ConfigurationException;

    public IBPELDeployer createNewDeployer(String type) throws SpecificationException {
        IBPELDeployer deployer = ExtensionRegistry.createNewDeployerForType(type);
        ExtensionRegistry.configure(type, deployer);
        return deployer;
    }

    public IHeaderProcessor createNewHeaderProcessor(String name) throws SpecificationException {
        return ExtensionRegistry.createNewHeaderProcessorForType(name);
    }

    public ISOAPEncoder createNewSOAPEncoder(String styleEncoding) throws SpecificationException {
        return ExtensionRegistry.createNewEncoderForType(styleEncoding);
    }

    public IDataSource createNewDataSource(String type) throws SpecificationException {
        return ExtensionRegistry.createNewDataSourceForType(type);
    }

    public void configureCoverageTool() throws ConfigurationException {
        CoverageMeasurementTool coverageTool = new CoverageMeasurementTool();
        BPELUnitBaseRunner.setCoverageMeasurmentTool(coverageTool);
        BPELUnitBaseRunner.getCoverageMeasurmentTool().setPathToWSDL(FilenameUtils.concat((String)FilenameUtils.concat((String)this.fHomeDirectory, (String)CONFIG_DIR), (String)"CoverageReportingService.wsdl"));
        String coverageFile = FilenameUtils.concat((String)this.fHomeDirectory, (String)FilenameUtils.concat((String)CONFIG_DIR, (String)COVERAGETOOL_CONFIG_FILE_NAME));
        if (coverageFile == null || !new File(coverageFile).exists()) {
            coverageTool.setErrorStatus("BPELUnit was expecting a coverage tool configuration file.");
            throw new ConfigurationException("BPELUnit was expecting a coverage tool configuration file.");
        }
        Map<String, List<String>> configMap = ExtensionRegistry.loadCoverageToolConfiguration(new File(coverageFile));
        ArrayList<String> directory = new ArrayList<String>();
        directory.add(FilenameUtils.concat((String)this.fHomeDirectory, (String)CONFIG_DIR));
        coverageTool.configureMetrics(configMap);
    }
}

