/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.framework.control.datasource.excel;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import net.bpelunit.framework.control.ext.IDataSource;
import net.bpelunit.framework.exception.DataSourceException;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;

@IDataSource.DataSource(name="Excel Data Source", shortName="excel", contentTypes={"application/excel", "application/vnd.ms-excel", "application/x-excel", "application/x-msexcel", "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet"})
public class ExcelDataSource
implements IDataSource {
    private static final int DEFAULT_SHEET_INDEX = 0;
    private Sheet sheet;
    private List<String> headings;
    private static final int HEADING_ROW_INDEX = 0;
    private static final int START_DATA_ROW_INDEX = 1;
    private int currentDataRow = -1;
    private short firstCellIndex = 0;
    private int sheetIndex = 0;

    public void close() {
        this.sheet = null;
    }

    public String[] getFieldNames() {
        return this.headings.toArray(new String[this.headings.size()]);
    }

    public String getValueFor(String fieldName) {
        Row row = this.sheet.getRow(1 + this.currentDataRow);
        int cellIndex = this.firstCellIndex + this.headings.indexOf(fieldName);
        Cell cell = row.getCell(cellIndex);
        return StringUtils.defaultString((String)cell.getStringCellValue());
    }

    public void setRow(int index) throws DataSourceException {
        if (index >= this.getNumberOfRows() || this.sheet.getRow(1 + index) == null) {
            throw new DataSourceException(String.format("Index %d out of bounds [0, %d]", index, this.getNumberOfRows()));
        }
        this.currentDataRow = index;
    }

    public void loadFromStream(InputStream data) throws DataSourceException {
        Workbook workbook = this.readWorkbook(data);
        this.sheet = this.getSheetWithTestData(workbook);
        this.extractFieldNames();
    }

    protected Workbook readWorkbook(InputStream data) throws DataSourceException {
        try {
            return WorkbookFactory.create((InputStream)data);
        }
        catch (InvalidFormatException e) {
            throw new DataSourceException("The data source is not a valid MS Excel File!", (Throwable)e);
        }
        catch (FileNotFoundException e) {
            throw new DataSourceException("The data source does not exist!", (Throwable)e);
        }
        catch (IOException e) {
            throw new DataSourceException("The data source could not be read!", (Throwable)e);
        }
    }

    private Sheet getSheetWithTestData(Workbook workbook) throws DataSourceException {
        try {
            return workbook.getSheetAt(this.sheetIndex);
        }
        catch (IllegalArgumentException e) {
            throw new DataSourceException("Could not find sheet with index " + this.sheetIndex, (Throwable)e);
        }
    }

    private void extractFieldNames() throws DataSourceException {
        this.headings = new ArrayList<String>();
        Row headingRow = this.sheet.getRow(0);
        this.checkForNull(headingRow, "No headings found at row 0");
        for (short i = this.firstCellIndex = headingRow.getFirstCellNum(); i < headingRow.getLastCellNum(); i = (short)(i + 1)) {
            String heading = headingRow.getCell((int)i).getStringCellValue();
            this.headings.add(heading);
        }
    }

    private void checkForNull(Object o, String message) throws DataSourceException {
        if (o == null) {
            throw new DataSourceException(message);
        }
    }

    @IDataSource.ConfigurationOption(defaultValue="0", description="The number of the sheet in which the test data reside. Counting starts with 1 for the first sheet.")
    public void setSheet(String index) {
        this.checkIfMayAlterConfiguration();
        try {
            this.sheetIndex = Integer.parseInt(index) - 1;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Sheet Index must be a positive number", e);
        }
    }

    private void checkIfMayAlterConfiguration() {
        if (this.sheet != null) {
            throw new IllegalStateException("Data has already been loaded; must not alter settings anymore!");
        }
    }

    public int getNumberOfRows() {
        return this.sheet.getLastRowNum();
    }
}

