/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.framework.control.datasource.html;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLEditorKit;
import net.bpelunit.framework.control.ext.IDataSource;
import net.bpelunit.framework.exception.DataSourceException;

@IDataSource.DataSource(name="HTML Data Source", shortName="html", contentTypes={"text/html", "application/xhtml+xml", "application/xhtml+xml"})
public class HtmlDataSource
implements IDataSource {
    private int tableToUse = 1;
    private List<String> headings;
    private List<List<String>> data;
    private List<String> currentRow;
    private boolean hadRowOrColSpan = false;

    public void close() {
        this.data = null;
        this.headings = null;
        this.currentRow = null;
    }

    public String[] getFieldNames() {
        return this.headings.toArray(new String[0]);
    }

    public int getNumberOfRows() {
        return this.data.size();
    }

    public Object getValueFor(String fieldName) {
        int fieldIndex = this.headings.indexOf(fieldName);
        if (fieldIndex < 0) {
            throw new IllegalArgumentException("No row named \"" + fieldName + "\" found in HTML table");
        }
        try {
            return this.currentRow.get(fieldIndex);
        }
        catch (IndexOutOfBoundsException e) {
            return "";
        }
    }

    public void loadFromStream(InputStream is) throws DataSourceException {
        HTMLEditorKit.Parser parser = new HTMLParse().getParserPublic();
        this.data = new ArrayList<List<String>>();
        DataSourceHtmlParser callback = new DataSourceHtmlParser();
        try {
            parser.parse(new InputStreamReader(is), callback, true);
            is.close();
        }
        catch (IOException e) {
            throw new DataSourceException("Error while reading HTML: " + e.getMessage(), (Throwable)e);
        }
        if (this.hadRowOrColSpan) {
            throw new DataSourceException("The input table in the HTML file had rowspan or colspan attributes. These are not allowed for a data source!");
        }
        if (this.data.size() == 0) {
            throw new DataSourceException("No table data found in HTML file!");
        }
        this.headings = this.data.remove(0);
    }

    public void setRow(int index) throws DataSourceException {
        if (index >= this.getNumberOfRows()) {
            throw new DataSourceException(String.format("Index %d out of bounds [0, %d]", index, this.getNumberOfRows() - 1));
        }
        this.currentRow = this.data.get(index);
    }

    @IDataSource.ConfigurationOption(defaultValue="1", description="The index of the table in the HTML file in which the data is contained")
    public void setTable(String value) {
        int index;
        this.checkIfConfigurationMayBeChanged();
        this.tableToUse = index = Integer.parseInt(value);
    }

    private void checkIfConfigurationMayBeChanged() {
        if (this.headings != null) {
            throw new IllegalStateException("Data has already been read. Configuration must be changed anymore!");
        }
    }

    private static class HTMLParse
    extends HTMLEditorKit {
        private static final long serialVersionUID = 1L;

        private HTMLParse() {
        }

        public HTMLEditorKit.Parser getParserPublic() {
            return super.getParser();
        }
    }

    private final class DataSourceHtmlParser
    extends HTMLEditorKit.ParserCallback {
        private int tablesToWaitFor;
        private List<String> currentRow;
        private StringBuilder cellValue;
        private boolean isInCell;

        private DataSourceHtmlParser() {
            this.tablesToWaitFor = HtmlDataSource.this.tableToUse;
            this.currentRow = null;
            this.isInCell = false;
        }

        public void handleStartTag(HTML.Tag t, MutableAttributeSet a, int pos) {
            if (t == HTML.Tag.TABLE) {
                --this.tablesToWaitFor;
            }
            if (this.tablesToWaitFor == 0) {
                if (t == HTML.Tag.TR) {
                    this.currentRow = new ArrayList<String>();
                    HtmlDataSource.this.data.add(this.currentRow);
                }
                if (t == HTML.Tag.TD || t == HTML.Tag.TH) {
                    if (a.getAttribute(HTML.Attribute.COLSPAN) != null || a.getAttribute(HTML.Attribute.ROWSPAN) != null) {
                        HtmlDataSource.this.hadRowOrColSpan = true;
                    }
                    this.cellValue = new StringBuilder();
                    this.isInCell = true;
                }
            }
        }

        public void handleEndTag(HTML.Tag t, int pos) {
            if (this.isInCell && (t == HTML.Tag.TD || t == HTML.Tag.TH)) {
                this.isInCell = false;
                this.currentRow.add(this.cellValue.toString());
                this.cellValue = null;
            }
        }

        public void handleText(char[] data, int pos) {
            if (this.isInCell) {
                this.cellValue.append(data);
            }
        }
    }
}

