/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.test.unit;

import javax.wsdl.Definition;
import javax.xml.namespace.QName;
import net.bpelunit.framework.SpecificationLoader;
import net.bpelunit.framework.model.Partner;
import net.bpelunit.framework.model.test.data.SOAPOperationCallIdentifier;
import net.bpelunit.framework.model.test.data.SOAPOperationDirectionIdentifier;
import net.bpelunit.test.unit.SimpleTest;
import org.junit.Assert;
import org.junit.Test;

public class TestWSDLReader
extends SimpleTest {
    private static final String ABS_PATH = TestWSDLReader.class.getResource("/wsdlreader").getPath() + "/";

    private String getEncoding(String name) throws Exception {
        Definition d = SpecificationLoader.loadWsdlDefinition((String)ABS_PATH, (String)name, (String)"TEST");
        Partner p = new Partner("MyPartner", d, null, "");
        QName service = new QName("http://www.example.org/MyPartner/", "MyPartner");
        SOAPOperationCallIdentifier operation = p.getOperation(service, "MyPartnerSOAP", "NewOperation", SOAPOperationDirectionIdentifier.INPUT);
        return operation.getEncodingStyle();
    }

    private SOAPOperationCallIdentifier getOp(String name) throws Exception {
        Definition d = SpecificationLoader.loadWsdlDefinition((String)ABS_PATH, (String)name, (String)"TEST");
        Partner p = new Partner("MyPartner", d, null, "");
        QName service = new QName("http://www.example.org/MyPartner/", "MyPartner");
        SOAPOperationCallIdentifier operation = p.getOperation(service, "MyPartnerSOAP", "NewOperation", SOAPOperationDirectionIdentifier.INPUT);
        return operation;
    }

    @Test
    public void testGetDocumentLiteral1() throws Exception {
        String encodingStyle = this.getEncoding("MyPartner1.wsdl");
        Assert.assertEquals((Object)"document/literal", (Object)encodingStyle);
    }

    @Test
    public void testGetDocumentLiteral2() throws Exception {
        String encodingStyle = this.getEncoding("MyPartner2.wsdl");
        Assert.assertEquals((Object)"document/literal", (Object)encodingStyle);
    }

    @Test
    public void testGetDocumentLiteral5() throws Exception {
        String encodingStyle = this.getEncoding("MyPartner5.wsdl");
        Assert.assertEquals((Object)"document/literal", (Object)encodingStyle);
    }

    @Test
    public void testGetDocumentLiteral6() throws Exception {
        String encodingStyle = this.getEncoding("MyPartner6.wsdl");
        Assert.assertEquals((Object)"document/literal", (Object)encodingStyle);
    }

    @Test
    public void testGetRPCLiteral() throws Exception {
        String encodingStyle = this.getEncoding("MyPartner3.wsdl");
        Assert.assertEquals((Object)"rpc/literal", (Object)encodingStyle);
    }

    @Test
    public void testGetRPCEncoded() throws Exception {
        String encodingStyle = this.getEncoding("MyPartner4.wsdl");
        Assert.assertEquals((Object)"rpc/encoded", (Object)encodingStyle);
    }

    @Test
    public void testItems() throws Exception {
        SOAPOperationCallIdentifier c = this.getOp("MyPartner6.wsdl");
        Assert.assertEquals((Object)"http://www.example.org/", (Object)c.getTargetURL());
        Assert.assertEquals((Object)"http://www.example.org/MyPartner/", (Object)c.getTargetNamespace());
        Assert.assertEquals((Object)"http://www.example.org/MyPartner/NewOperation", (Object)c.getSOAPHTTPAction());
    }

    @Test
    public void testTwoWSDLsSpecified() throws Exception {
        Definition d1 = SpecificationLoader.loadWsdlDefinition((String)ABS_PATH, (String)"MyPartner1.wsdl", (String)"TEST");
        Definition d2 = SpecificationLoader.loadWsdlDefinition((String)ABS_PATH, (String)"Callback.wsdl", (String)"TEST");
        Partner p = new Partner("Partner", d1, d2, "");
        QName service = new QName("http://www.example.org/MyPartner/", "MyPartner");
        SOAPOperationCallIdentifier operation = p.getOperation(service, "MyPartnerSOAP", "NewOperation", SOAPOperationDirectionIdentifier.INPUT);
        Assert.assertNotNull((Object)operation);
        service = new QName("http://www.example.org/Callback/", "Callback");
        operation = p.getOperation(service, "CallbackSOAP", "NewOperation", SOAPOperationDirectionIdentifier.INPUT);
        Assert.assertNotNull((Object)operation);
    }
}

