/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.framework.verify;

import net.bpelunit.framework.exception.SpecificationException;
import net.bpelunit.framework.verify.PartnersInTestCasesHaveNamesValidator;
import net.bpelunit.framework.xml.suite.XMLTestCase;
import net.bpelunit.framework.xml.suite.XMLTestCasesSection;
import net.bpelunit.framework.xml.suite.XMLTestSuite;
import net.bpelunit.framework.xml.suite.XMLTestSuiteDocument;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class PartnersInTestCasesHaveNamesValidatorTest {
    private XMLTestSuiteDocument testSuiteDoc;
    private PartnersInTestCasesHaveNamesValidator validator = new PartnersInTestCasesHaveNamesValidator();
    private XMLTestCasesSection testCases;
    private XMLTestCase testCase1;

    @Before
    public void setUp() {
        this.testSuiteDoc = XMLTestSuiteDocument.Factory.newInstance();
        XMLTestSuite testSuite = this.testSuiteDoc.addNewTestSuite();
        this.testCases = testSuite.addNewTestCases();
        this.testCase1 = this.testCases.addNewTestCase();
    }

    @After
    public void tearDown() {
        this.testCases = null;
        this.testSuiteDoc = null;
    }

    @Test(expected=SpecificationException.class)
    public void testEmptyWSSOAPPartnerName() throws Exception {
        this.testCase1.addNewPartnerTrack().setName("A");
        this.testCase1.addNewPartnerTrack().setName("");
        this.validator.validate(this.testSuiteDoc);
    }

    @Test(expected=SpecificationException.class)
    public void testEmptyWSHTName() throws Exception {
        this.testCase1.addNewHumanPartnerTrack().setName("A");
        this.testCase1.addNewHumanPartnerTrack().setName("");
        this.validator.validate(this.testSuiteDoc);
    }

    @Test(expected=SpecificationException.class)
    public void testNullWSSOAPPartnerName() throws Exception {
        this.testCase1.addNewPartnerTrack().setName("A");
        this.testCase1.addNewPartnerTrack();
        this.validator.validate(this.testSuiteDoc);
    }

    @Test(expected=SpecificationException.class)
    public void testNullWSHTName() throws Exception {
        this.testCase1.addNewHumanPartnerTrack().setName("A");
        this.testCase1.addNewHumanPartnerTrack();
        this.validator.validate(this.testSuiteDoc);
    }

    @Test
    public void testAllHaveNames() throws Exception {
        this.testCase1.addNewHumanPartnerTrack().setName("A");
        this.testCase1.addNewHumanPartnerTrack().setName("B");
        this.testCase1.addNewPartnerTrack().setName("C");
        this.testCase1.addNewPartnerTrack().setName("D");
        this.validator.validate(this.testSuiteDoc);
    }

    @Test(expected=SpecificationException.class)
    public void testNullWSHTNameInSecondTestCase() throws Exception {
        XMLTestCase testCase2 = this.testCases.addNewTestCase();
        testCase2.addNewHumanPartnerTrack().setName("A");
        testCase2.addNewHumanPartnerTrack();
        this.validator.validate(this.testSuiteDoc);
    }
}

