/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.framework.wsht;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.codec.binary.Base64;
import org.apache.log4j.lf5.util.StreamUtils;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlTokenSource;
import org.example.wsHT.api.XMLTStatus;
import org.example.wsHT.api.xsd.XMLClaimDocument;
import org.example.wsHT.api.xsd.XMLCompleteDocument;
import org.example.wsHT.api.xsd.XMLGetInputDocument;
import org.example.wsHT.api.xsd.XMLGetInputResponseDocument;
import org.example.wsHT.api.xsd.XMLGetMyTasksDocument;
import org.example.wsHT.api.xsd.XMLGetMyTasksResponseDocument;
import org.example.wsHT.api.xsd.XMLSetOutputDocument;
import org.example.wsHT.api.xsd.XMLStartDocument;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class WSHTClient {
    private static final String NAMESPACE_SOAP = "http://schemas.xmlsoap.org/soap/envelope/";
    private URL wsHtEndpoint;
    private SOAPCreator soapCreator;
    private String authorizationRealm;

    public WSHTClient(URL endpoint, String username, String password) {
        this.wsHtEndpoint = endpoint;
        try {
            this.soapCreator = new SOAPCreator();
        }
        catch (Exception e) {
            throw new WSHTException("Build problem: Resource not found", e);
        }
        this.setAuthorizationRealm(username, password);
    }

    final void setAuthorizationRealm(String username, String password) {
        String effectivePassword = password;
        if (effectivePassword == null) {
            effectivePassword = "";
        }
        this.authorizationRealm = new String(Base64.encodeBase64((byte[])(username + ":" + effectivePassword).getBytes()));
    }

    public XMLGetMyTasksResponseDocument.GetMyTasksResponse getReadyTaskList() throws IOException, XmlException, ParserConfigurationException, SAXException {
        return this.getReadyTaskList(null);
    }

    public XMLGetMyTasksResponseDocument.GetMyTasksResponse getTaskList(String taskName, XMLTStatus.Enum[] state) throws IOException, XmlException, ParserConfigurationException, SAXException {
        XMLGetMyTasksDocument doc = XMLGetMyTasksDocument.Factory.newInstance();
        XMLGetMyTasksDocument.GetMyTasks getMyTasks = doc.addNewGetMyTasks();
        getMyTasks.setTaskType("TASK");
        getMyTasks.setStatusArray(state);
        if (taskName != null) {
            getMyTasks.setWhereClause("Task.Name = '" + taskName + "'");
        }
        Node result = this.makeWSHTSOAPRequest(doc.xmlText());
        XMLGetMyTasksResponseDocument resDoc = XMLGetMyTasksResponseDocument.Factory.parse(result);
        return resDoc.getGetMyTasksResponse();
    }

    public XMLGetMyTasksResponseDocument.GetMyTasksResponse getReadyTaskList(String taskName) throws IOException, XmlException, ParserConfigurationException, SAXException {
        return this.getTaskList(taskName, new XMLTStatus.Enum[]{XMLTStatus.Enum.forString("READY")});
    }

    public void completeTaskWithOutput(String taskId, XmlObject completeData) {
        this.claim(taskId);
        this.start(taskId);
        this.setOutput(taskId, completeData);
        this.complete(taskId);
    }

    public XMLGetInputResponseDocument.GetInputResponse getInput(String taskId) {
        try {
            XMLGetInputDocument getInputDoc = XMLGetInputDocument.Factory.newInstance();
            XMLGetInputDocument.GetInput getInput = getInputDoc.addNewGetInput();
            getInput.setIdentifier(taskId);
            Node response = this.makeWSHTSOAPRequest((XmlTokenSource)getInputDoc);
            XMLGetInputResponseDocument getInputResponseDoc = XMLGetInputResponseDocument.Factory.parse(response);
            return getInputResponseDoc.getGetInputResponse();
        }
        catch (Exception e) {
            throw new WSHTException(e.getMessage(), e);
        }
    }

    private void setOutput(String taskId, XmlObject xmlPayload) {
        try {
            XMLSetOutputDocument setOutputDoc = XMLSetOutputDocument.Factory.newInstance();
            XMLSetOutputDocument.SetOutput setOutput = setOutputDoc.addNewSetOutput();
            setOutput.setIdentifier(taskId);
            XmlObject taskData = setOutput.addNewTaskData();
            taskData.set(xmlPayload);
            this.makeWSHTSOAPRequest((XmlTokenSource)setOutputDoc);
        }
        catch (Exception e) {
            throw new WSHTException(e.getMessage(), e);
        }
    }

    private void complete(String taskId) {
        try {
            XMLCompleteDocument completeDoc = XMLCompleteDocument.Factory.newInstance();
            XMLCompleteDocument.Complete complete = completeDoc.addNewComplete();
            complete.setIdentifier(taskId);
            this.makeWSHTSOAPRequest((XmlTokenSource)completeDoc);
        }
        catch (Exception e) {
            throw new WSHTException(e.getMessage(), e);
        }
    }

    private void start(String taskId) {
        try {
            XMLStartDocument startDoc = XMLStartDocument.Factory.newInstance();
            XMLStartDocument.Start start = startDoc.addNewStart();
            start.setIdentifier(taskId);
            this.makeWSHTSOAPRequest((XmlTokenSource)startDoc);
        }
        catch (Exception e) {
            throw new WSHTException(e.getMessage(), e);
        }
    }

    private void claim(String taskId) {
        try {
            XMLClaimDocument claimDoc = XMLClaimDocument.Factory.newInstance();
            XMLClaimDocument.Claim claim = claimDoc.addNewClaim();
            claim.setIdentifier(taskId);
            this.makeWSHTSOAPRequest((XmlTokenSource)claimDoc);
        }
        catch (Exception e) {
            throw new WSHTException(e.getMessage(), e);
        }
    }

    private Node makeWSHTSOAPRequest(XmlTokenSource request) throws IOException, ParserConfigurationException, SAXException {
        return this.makeWSHTSOAPRequest(request.xmlText());
    }

    private Node makeWSHTSOAPRequest(String request) throws IOException, ParserConfigurationException, SAXException {
        HttpURLConnection con = (HttpURLConnection)this.wsHtEndpoint.openConnection();
        con.setRequestMethod("POST");
        con.setRequestProperty("Authorization", "Basic " + this.getAuthorizationRealm());
        con.setRequestProperty("Content-Type", "text/xml; charset=utf-8");
        con.setRequestProperty("Accept", "application/soap+xml, text/xml");
        con.setDoOutput(true);
        con.setDoInput(true);
        con.connect();
        OutputStream out = con.getOutputStream();
        String soapMessage = this.soapCreator.createSOAP(request);
        out.write(soapMessage.getBytes("UTF-8"));
        out.close();
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document document = db.parse(con.getInputStream());
        Node soapBody = document.getElementsByTagNameNS(NAMESPACE_SOAP, "Body").item(0);
        return soapBody.getFirstChild();
    }

    String getAuthorizationRealm() {
        return this.authorizationRealm;
    }

    private static class SOAPCreator {
        private String soapMessage = new String(StreamUtils.getBytes((InputStream)WSHTClient.class.getResourceAsStream("soap.xml")));

        public String createSOAP(String xml) {
            return this.soapMessage.replace("%xml%", xml);
        }
    }

    public class WSHTException
    extends RuntimeException {
        public WSHTException(String msg, Throwable t) {
            super(msg, t);
        }
    }
}

