/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.framework.model.test.report;

import java.util.ArrayList;
import java.util.List;
import net.bpelunit.framework.model.test.report.StateData;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ArtefactStatus {
    private static final Logger LOGGER = Logger.getLogger(ArtefactStatus.class);
    private StatusCode fCode;
    private String fMessage;
    private Exception fException;

    public static ArtefactStatus createInitialStatus() {
        return new ArtefactStatus(StatusCode.NOTYETSPECIFIED, "Not yet specified.", null);
    }

    public static ArtefactStatus createPassedStatus() {
        return new ArtefactStatus(StatusCode.PASSED, "Passed", null);
    }

    public static ArtefactStatus createFailedStatus(String message) {
        return new ArtefactStatus(StatusCode.FAILED, message, null);
    }

    public static ArtefactStatus createErrorStatus(String message) {
        return ArtefactStatus.createErrorStatus(message, null);
    }

    public static ArtefactStatus createErrorStatus(String message, Exception e) {
        LOGGER.error((Object)"Error status due to exception", (Throwable)e);
        return new ArtefactStatus(StatusCode.ERROR, message, e);
    }

    public static ArtefactStatus createAbortedStatus(String message, Exception e) {
        LOGGER.error((Object)"Aborted status due to exception", (Throwable)e);
        return new ArtefactStatus(StatusCode.ABORTED, message, e);
    }

    public static ArtefactStatus createAbortedStatus(String message) {
        return new ArtefactStatus(StatusCode.ABORTED, message, null);
    }

    public static ArtefactStatus createInProgressStatus() {
        return new ArtefactStatus(StatusCode.INPROGRESS, "In progress.", null);
    }

    private ArtefactStatus(StatusCode error, String string, Exception e) {
        this.fCode = error;
        this.fMessage = string;
        this.fException = e;
    }

    public boolean hasProblems() {
        return this.fCode == StatusCode.ABORTED || this.fCode == StatusCode.FAILED || this.fCode == StatusCode.ERROR;
    }

    public boolean isError() {
        return this.fCode == StatusCode.ERROR;
    }

    public boolean isFailure() {
        return this.fCode == StatusCode.FAILED;
    }

    public boolean isInitial() {
        return this.fCode == StatusCode.NOTYETSPECIFIED;
    }

    public boolean isAborted() {
        return this.fCode == StatusCode.ABORTED;
    }

    public boolean isPassed() {
        return this.fCode == StatusCode.PASSED;
    }

    public boolean isInProgress() {
        return this.fCode == StatusCode.INPROGRESS;
    }

    public StatusCode getCode() {
        return this.fCode;
    }

    public String getMessage() {
        return this.fMessage;
    }

    public String getExceptionMessage() {
        for (Throwable ex = this.fException; ex != null; ex = ex.getCause()) {
            String sMessage = ex.getMessage();
            if (sMessage == null) continue;
            return sMessage;
        }
        return null;
    }

    public List<StateData> getAsStateData() {
        ArrayList<StateData> stateData = new ArrayList<StateData>();
        stateData.add(new StateData("Status Code", this.fCode.name()));
        stateData.add(new StateData("Status Message", this.fMessage));
        if (this.fException != null) {
            stateData.add(new StateData("Exception", this.fException.getMessage()));
        }
        return stateData;
    }

    public String toString() {
        StringBuffer toString = new StringBuffer();
        toString.append("Status { Code => \"" + this.fCode.name() + "\", ");
        toString.append("Message => \"" + this.fMessage + "\"");
        if (this.fException != null) {
            toString.append(", Exception => \"" + this.fException.getMessage() + "\"");
        }
        toString.append(" }");
        return toString.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum StatusCode {
        NOTYETSPECIFIED,
        INPROGRESS,
        ABORTED,
        PASSED,
        FAILED,
        ERROR;

    }
}

