/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.framework.model.test.activity;

import java.util.ArrayList;
import java.util.List;
import net.bpelunit.framework.model.test.PartnerTrack;
import net.bpelunit.framework.model.test.activity.Activity;
import net.bpelunit.framework.model.test.activity.ActivityContext;
import net.bpelunit.framework.model.test.report.ArtefactStatus;
import net.bpelunit.framework.model.test.report.ITestArtefact;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Wait
extends Activity {
    private long waitDuration;

    public Wait(PartnerTrack partnerTrack) {
        super(partnerTrack);
    }

    @Override
    public String getActivityCode() {
        return "Wait";
    }

    @Override
    public int getActivityCount() {
        return 1;
    }

    @Override
    public List<ITestArtefact> getChildren() {
        return new ArrayList<ITestArtefact>();
    }

    @Override
    public String getName() {
        return "Wait";
    }

    @Override
    public ITestArtefact getParent() {
        return this.getPartnerTrack();
    }

    @Override
    public void run(ActivityContext context) {
        this.setStatus(ArtefactStatus.createInProgressStatus());
        long waitTill = System.currentTimeMillis() + this.waitDuration;
        while (System.currentTimeMillis() < waitTill) {
            try {
                Thread.sleep(Math.max(0L, waitTill - System.currentTimeMillis()));
            }
            catch (InterruptedException e) {}
        }
        this.setStatus(ArtefactStatus.createPassedStatus());
    }

    public void setWaitDuration(long waitForMilliseconds) {
        this.waitDuration = waitForMilliseconds;
    }
}

