/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.framework.model.test.activity;

import java.util.ArrayList;
import java.util.List;
import net.bpelunit.framework.exception.SynchronousSendException;
import net.bpelunit.framework.model.test.PartnerTrack;
import net.bpelunit.framework.model.test.activity.ActivityContext;
import net.bpelunit.framework.model.test.activity.TwoWaySyncActivity;
import net.bpelunit.framework.model.test.report.ArtefactStatus;
import net.bpelunit.framework.model.test.report.ITestArtefact;
import net.bpelunit.framework.model.test.report.StateData;
import net.bpelunit.framework.model.test.wire.IncomingMessage;
import net.bpelunit.framework.model.test.wire.OutgoingMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SendReceiveSync
extends TwoWaySyncActivity {
    private String fWrongReturnBody;

    public SendReceiveSync(PartnerTrack partnerTrack) {
        super(partnerTrack);
        this.setStatus(ArtefactStatus.createInitialStatus());
    }

    @Override
    public void run(ActivityContext context) {
        IncomingMessage returnMsg;
        context.setHeaderProcessor(this.getHeaderProcessor());
        this.getSendSpec().handle(context);
        if (this.getSendSpec().hasProblems()) {
            this.setStatus(this.getSendSpec().getStatus());
            return;
        }
        OutgoingMessage msg = new OutgoingMessage();
        msg.setTargetURL(this.getSendSpec().getTargetURL());
        msg.setSOAPAction(this.getSendSpec().getSOAPHTTPAction());
        msg.setBody(this.getSendSpec().getInWireFormat());
        try {
            this.getSendSpec().delay(context);
            returnMsg = context.sendMessage(msg);
        }
        catch (SynchronousSendException e) {
            this.setStatus(ArtefactStatus.createErrorStatus("HTTP Error while sending out synchronous message: " + e.getMessage(), e));
            return;
        }
        catch (InterruptedException e) {
            this.setStatus(ArtefactStatus.createAbortedStatus("Aborted due to error in other partner track", e));
            return;
        }
        catch (Exception e) {
            this.setStatus(ArtefactStatus.createAbortedStatus("Aborted while computing the delay for the send.", e));
            return;
        }
        if (returnMsg.getReturnCode() == 200) {
            this.getReceiveSpec().handle(context, returnMsg.getBody());
            this.setStatus(this.getReceiveSpec().getStatus());
        } else if (returnMsg.getReturnCode() >= 500 && returnMsg.getReturnCode() < 600) {
            this.getReceiveSpec().handle(context, returnMsg.getBody());
            this.setStatus(this.getReceiveSpec().getStatus());
        } else {
            this.setStatus(ArtefactStatus.createErrorStatus("Error: Answer from synchronous call had non-expected return code " + returnMsg.getReturnCode()));
            this.fWrongReturnBody = returnMsg.getBody();
            if ("".equals(this.fWrongReturnBody)) {
                this.fWrongReturnBody = "(empty)";
            }
        }
    }

    @Override
    public String getActivityCode() {
        return "SendReceiveSync";
    }

    @Override
    public String getName() {
        return "Send/Receive Synchronous";
    }

    @Override
    public List<ITestArtefact> getChildren() {
        ArrayList<ITestArtefact> children = new ArrayList<ITestArtefact>();
        children.add(this.getSendSpec());
        children.add(this.getReceiveSpec());
        return children;
    }

    @Override
    public List<StateData> getStateData() {
        ArrayList<StateData> stateData = new ArrayList<StateData>();
        stateData.addAll(this.getStatus().getAsStateData());
        if (this.fWrongReturnBody != null) {
            stateData.add(new StateData("Return Body", this.fWrongReturnBody));
        }
        return stateData;
    }
}

