/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.framework.coverage.receiver;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.wsdl.Definition;
import javax.wsdl.WSDLException;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import javax.xml.namespace.QName;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import net.bpelunit.framework.control.ext.ISOAPEncoder;
import net.bpelunit.framework.coverage.CoverageConstants;
import net.bpelunit.framework.coverage.receiver.MarkersRegisterForArchive;
import net.bpelunit.framework.exception.SOAPEncodingException;
import net.bpelunit.framework.exception.SpecificationException;
import net.bpelunit.framework.model.test.data.SOAPOperationCallIdentifier;
import net.bpelunit.framework.model.test.data.SOAPOperationDirectionIdentifier;
import org.apache.log4j.Logger;
import org.w3c.dom.Node;

public class CoverageMessageReceiver {
    private ISOAPEncoder encoder = null;
    private Logger logger = Logger.getLogger(this.getClass());
    private SOAPOperationCallIdentifier operation = null;
    private String testCase = null;
    private MarkersRegisterForArchive markersRegistry;

    public CoverageMessageReceiver(MarkersRegisterForArchive markersRegistry) {
        this.markersRegistry = markersRegistry;
    }

    public synchronized void putMessage(String message) {
        if (this.encoder != null && this.operation != null) {
            Node element = null;
            try {
                SOAPMessage fSOAPMessage = MessageFactory.newInstance().createMessage(null, (InputStream)new ByteArrayInputStream(message.getBytes()));
                element = this.encoder.deconstruct(this.operation, fSOAPMessage);
            }
            catch (IOException e) {
                this.logger.debug((Object)e.getLocalizedMessage());
            }
            catch (SOAPException e) {
                this.logger.debug((Object)("Could not create SOAP message from incoming message: " + e.getMessage()));
            }
            catch (SOAPEncodingException e) {
                this.logger.debug((Object)("Could not create SOAP message from incoming message: " + e.getMessage()));
            }
            this.markersRegistry.setCoverageStatusForAllMarker(element.getTextContent(), this.testCase);
        } else {
            this.logger.info((Object)"SOAPEncoder is not initialized.");
        }
    }

    public void setSOAPEncoder(ISOAPEncoder encoder) {
        this.encoder = encoder;
    }

    public void setPathToWSDL(String wsdl) {
        try {
            WSDLReader reader = WSDLFactory.newInstance().newWSDLReader();
            reader.setFeature("javax.wsdl.verbose", false);
            Definition fWSDLDefinition = reader.readWSDL(wsdl);
            this.operation = new SOAPOperationCallIdentifier(fWSDLDefinition, new QName(CoverageConstants.COVERAGETOOL_NAMESPACE.getURI(), "_CoverageReportingService_"), "Soap_service_port", "reportExecution", SOAPOperationDirectionIdentifier.INPUT);
        }
        catch (SpecificationException e) {
            this.logger.debug((Object)("WSDL of Coverage Logging Service is not valid:" + e.getMessage()));
        }
        catch (WSDLException e) {
            this.logger.debug((Object)("WSDL of Coverage Logging Service is not valid:" + e.getMessage()));
        }
    }

    public String getEncodingStyle() {
        String style = null;
        if (this.operation != null) {
            try {
                style = this.operation.getEncodingStyle();
            }
            catch (SpecificationException e) {
                this.logger.debug((Object)("Encoding style problem:" + e.getMessage()));
            }
        }
        return style;
    }

    public void setCurrentTestcase(String testCase) {
        this.testCase = testCase;
    }
}

