/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.framework.coverage.annotation.metrics.branchcoverage.impl;

import java.util.List;
import net.bpelunit.framework.coverage.annotation.metrics.branchcoverage.BranchMetricHandler;
import net.bpelunit.framework.coverage.annotation.metrics.branchcoverage.IStructuredActivityHandler;
import net.bpelunit.framework.coverage.annotation.tools.bpelxmltools.BpelXMLTools;
import net.bpelunit.framework.coverage.exceptions.BpelException;
import net.bpelunit.framework.coverage.receiver.MarkersRegisterForArchive;
import org.jdom.Content;
import org.jdom.Element;

public class SwitchHandler
implements IStructuredActivityHandler {
    private MarkersRegisterForArchive markersRegistry;

    public SwitchHandler(MarkersRegisterForArchive markersRegistry) {
        this.markersRegistry = markersRegistry;
    }

    public void insertBranchMarkers(Element structuredActivity) throws BpelException {
        List caseBranches = structuredActivity.getChildren("case", BpelXMLTools.getProcessNamespace());
        for (int i = 0; i < caseBranches.size(); ++i) {
            this.insertMarkerForCaseBranches(BpelXMLTools.getFirstEnclosedActivity((Element)caseBranches.get(i)));
        }
        Element otherwiseElement = structuredActivity.getChild("otherwise", BpelXMLTools.getProcessNamespace());
        if (otherwiseElement == null) {
            otherwiseElement = BpelXMLTools.insertOtherwiseBranch(structuredActivity);
            otherwiseElement.addContent((Content)BpelXMLTools.createSequence());
        }
        this.insertMarkerForOtherwiseBranch(otherwiseElement);
    }

    private void insertMarkerForOtherwiseBranch(Element otherwiseElement) throws BpelException {
        Element branchActivity = BpelXMLTools.getFirstEnclosedActivity(otherwiseElement);
        if (branchActivity == null) {
            throw new BpelException("Missing required activity");
        }
        this.markersRegistry.registerMarker(BranchMetricHandler.insertLabelBevorAllActivities(branchActivity));
    }

    private void insertMarkerForCaseBranches(Element branchActivity) throws BpelException {
        if (branchActivity == null) {
            throw new BpelException("Missing required activity");
        }
        this.markersRegistry.registerMarker(BranchMetricHandler.insertLabelBevorAllActivities(branchActivity));
    }
}

