/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.framework.coverage.annotation.metrics.activitycoverage;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.bpelunit.framework.coverage.annotation.metrics.IMetricHandler;
import net.bpelunit.framework.coverage.annotation.tools.bpelxmltools.BpelXMLTools;
import net.bpelunit.framework.coverage.receiver.MarkersRegisterForArchive;
import org.apache.log4j.Logger;
import org.jdom.Comment;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActivityMetricHandler
implements IMetricHandler {
    private MarkersRegisterForArchive markersRegistry;

    public ActivityMetricHandler(MarkersRegisterForArchive markersRegistry) {
        this.markersRegistry = markersRegistry;
        Logger.getLogger(this.getClass());
    }

    @Override
    public void insertMarkersForMetric(List<Element> activities) {
        for (Element activity : activities) {
            this.respectTargetActivities(activity);
            BpelXMLTools.ensureElementIsInSequence(activity);
            this.insertMarkerForActivity(activity);
        }
    }

    private void respectTargetActivities(Element element) {
        List<Element> targetElements = this.getTargetElements(element);
        if (targetElements.size() > 0) {
            Element realSequence = BpelXMLTools.encloseInSequence(element);
            for (Element targetElement : targetElements) {
                realSequence.addContent(0, targetElement.detach());
            }
        }
    }

    private List<Element> getTargetElements(Element element) {
        ArrayList<Element> targetElements = new ArrayList<Element>();
        Namespace bpelVersion = BpelXMLTools.getProcessNamespace();
        if (bpelVersion.equals((Object)BpelXMLTools.NAMESPACE_BPEL_2_0)) {
            Element targetElement = element.getChild("targets", bpelVersion);
            if (targetElement != null) {
                targetElements.add(targetElement);
            }
        } else if (bpelVersion.equals((Object)BpelXMLTools.NAMESPACE_BPEL_1_1)) {
            List list = element.getChildren("target", bpelVersion);
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                targetElements.add((Element)iter.next());
            }
        }
        return targetElements;
    }

    private void insertMarkerForActivity(Element element) {
        Element parent = element.getParentElement();
        String elementName = element.getName();
        String marker = elementName + '_' + BpelXMLTools.incrementCounter();
        this.markersRegistry.registerMarker(marker);
        Comment comment = new Comment("@coverageLabel" + marker);
        int index = parent.indexOf((Content)element);
        if (elementName.equals("receive")) {
            parent.addContent(index + 1, (Content)comment);
        } else {
            parent.addContent(index, (Content)comment);
        }
    }
}

