/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.framework.coverage.annotation;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.bpelunit.framework.coverage.annotation.MetricsManager;
import net.bpelunit.framework.coverage.annotation.metrics.IMetric;
import net.bpelunit.framework.coverage.annotation.tools.bpelxmltools.BasicActivities;
import net.bpelunit.framework.coverage.annotation.tools.bpelxmltools.BpelXMLTools;
import net.bpelunit.framework.coverage.annotation.tools.bpelxmltools.CMServiceFactory;
import net.bpelunit.framework.coverage.annotation.tools.bpelxmltools.StructuredActivities;
import net.bpelunit.framework.coverage.exceptions.BpelException;
import net.bpelunit.framework.coverage.exceptions.BpelVersionException;
import net.bpelunit.util.JDomUtil;
import org.jdom.Comment;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.filter.ElementFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Instrumenter {
    public static final String COVERAGE_LABEL_IDENTIFIER = "@coverageLabel";
    public static final char COVERAGE_LABEL_INNER_SEPARATOR = '_';
    public static final String SEPARATOR = "#";
    private CMServiceFactory cmServiceFactory;
    private String assignVariable = BpelXMLTools.createVariableName();

    public Document insertAnnotations(Document document, MetricsManager metricManager) throws BpelException {
        Element processElement = document.getRootElement();
        this.checkVersion(processElement);
        this.initializeBPELTools(processElement);
        if (metricManager.hasMetric("FaultHandlerCoverage") || metricManager.hasMetric("CompensationHandlerCoverage")) {
            this.replaceInlineHandler(processElement);
        }
        List<IMetric> metrics = metricManager.getMetrics();
        this.saveOriginalBPELElements(metrics, processElement);
        this.executeInstrumentation(metrics);
        this.createReportInvokesFromCoverageLabels(processElement);
        return document;
    }

    private void replaceInlineHandler(Element processElement) {
        Iterator iter = JDomUtil.getDescendants((Element)processElement, (ElementFilter)new ElementFilter("invoke", processElement.getNamespace()){

            public boolean matches(Object o) {
                if (super.matches(o)) {
                    Element invoke = (Element)o;
                    List children = JDomUtil.getChildren((Element)invoke, (String)"catch");
                    if (children.size() > 0) {
                        return true;
                    }
                    children = JDomUtil.getChildren((Element)invoke, (String)"catchAll");
                    if (children.size() > 0) {
                        return true;
                    }
                    children = JDomUtil.getChildren((Element)invoke, (String)"compensationHandler");
                    if (children.size() > 0) {
                        return true;
                    }
                }
                return false;
            }
        });
        while (iter.hasNext()) {
            this.replaceInlineHandlerForInvoke((Element)iter.next());
        }
    }

    private void replaceInlineHandlerForInvoke(Element element) {
        Element scope = null;
        List inlineElements = JDomUtil.getChildren((Element)element, (String)"catch");
        List inlineElements2 = JDomUtil.getChildren((Element)element, (String)"catchAll");
        if (inlineElements.size() > 0 || inlineElements2.size() > 0) {
            scope = BpelXMLTools.createBPELElement("scope");
            Element faultHandler = BpelXMLTools.createBPELElement("faultHandlers");
            scope.addContent((Content)faultHandler);
            Iterator iter = inlineElements.iterator();
            while (iter.hasNext()) {
                faultHandler.addContent(((Element)iter.next()).detach());
            }
            if (inlineElements2.size() > 0) {
                faultHandler.addContent(((Element)inlineElements2.get(0)).detach());
            }
        }
        if ((inlineElements = JDomUtil.getChildren((Element)element, (String)"compensationHandler")).size() > 0) {
            if (scope == null) {
                scope = BpelXMLTools.createBPELElement("scope");
            }
            scope.addContent(((Element)inlineElements.get(0)).detach());
        }
        if (scope != null) {
            int i = element.getParentElement().indexOf((Content)element);
            scope.setContent(i, (Content)scope);
            scope.addContent((Content)element);
        }
    }

    private void saveOriginalBPELElements(List<IMetric> metrics, Element processElement) {
        for (IMetric metric : metrics) {
            metric.setOriginalBPELProcess(processElement);
        }
    }

    private void checkVersion(Element processElement) throws BpelVersionException {
        Namespace processNamespace = processElement.getNamespace();
        if (!processNamespace.equals((Object)BpelXMLTools.NAMESPACE_BPEL_1_1) && !processNamespace.equals((Object)BpelXMLTools.NAMESPACE_BPEL_2_0)) {
            throw new BpelVersionException("Wrong version. Version " + processNamespace.getURI() + "is not supported. Expected " + BpelXMLTools.NAMESPACE_BPEL_1_1.getURI() + " or " + BpelXMLTools.NAMESPACE_BPEL_2_0.getURI());
        }
    }

    private void initializeBPELTools(Element processElement) throws BpelVersionException {
        BpelXMLTools.setProcessElement(processElement);
        BasicActivities.initialize();
        StructuredActivities.initialize();
    }

    private void executeInstrumentation(List<IMetric> metrics) throws BpelException {
        for (IMetric metric : metrics) {
            metric.insertMarkers();
        }
    }

    private void createReportInvokesFromCoverageLabels(Element processElement) {
        this.cmServiceFactory = CMServiceFactory.getInstance();
        this.cmServiceFactory.prepareBPELFile(processElement);
        this.handleCoverageLabelsInElement(processElement, null);
    }

    private void handleCoverageLabelsInElement(Element element, String variable) {
        ArrayList childElements = new ArrayList();
        List children = JDomUtil.getElementsInContent((Element)element);
        for (int i = 0; i < children.size(); ++i) {
            childElements.add(children.get(i));
        }
        this.replaceCoverageLabelsWithReportInvokes(element, variable);
        boolean isFlow = element.getName().equals("flow");
        for (int i = 0; i < childElements.size(); ++i) {
            if (isFlow) {
                this.handleCoverageLabelsInElement((Element)childElements.get(i), BpelXMLTools.createVariableName());
                continue;
            }
            this.handleCoverageLabelsInElement((Element)childElements.get(i), null);
        }
    }

    private void replaceCoverageLabelsWithReportInvokes(Element element, String variable) {
        List children = JDomUtil.getCommentsInContent((Element)element);
        int indexOfLastMarker = -1;
        String marker = "";
        for (int i = children.size() - 1; i > -1; --i) {
            Comment comment = (Comment)children.get(i);
            int index = element.indexOf((Content)comment);
            String commentText = comment.getText();
            if (this.isCoverageLabel(commentText)) {
                if (indexOfLastMarker - 1 == index) {
                    marker = marker + this.getMarker(commentText, COVERAGE_LABEL_IDENTIFIER) + SEPARATOR;
                } else {
                    if (marker.length() > 0) {
                        this.insertInvokeForLabels(marker, indexOfLastMarker, element, variable);
                    }
                    marker = this.getMarker(commentText, COVERAGE_LABEL_IDENTIFIER) + SEPARATOR;
                }
                comment.detach();
            }
            indexOfLastMarker = index;
            if (i != 0 || marker.length() <= 0) continue;
            this.insertInvokeForLabels(marker, indexOfLastMarker, element, variable);
        }
    }

    private void insertInvokeForLabels(String marker, int index, Element element, String variable) {
        String realVariable = variable;
        if (realVariable == null) {
            realVariable = this.assignVariable;
        }
        Element assign = this.cmServiceFactory.createAssignElement(marker, realVariable);
        Element invoke = this.cmServiceFactory.createInvokeElementForLoggingService(realVariable);
        element.addContent(index, (Content)invoke);
        element.addContent(index, (Content)assign);
    }

    private String getMarker(String complettLabel, String identifier) {
        int startIndex = complettLabel.indexOf(identifier) + identifier.length();
        return complettLabel.substring(startIndex);
    }

    private boolean isCoverageLabel(String label) {
        return label.startsWith(COVERAGE_LABEL_IDENTIFIER);
    }
}

