/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.framework.control.result;

import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import net.bpelunit.framework.model.test.PartnerTrack;
import net.bpelunit.framework.model.test.TestCase;
import net.bpelunit.framework.model.test.TestSuite;
import net.bpelunit.framework.model.test.activity.Activity;
import net.bpelunit.framework.model.test.data.DataCopyOperation;
import net.bpelunit.framework.model.test.data.DataSpecification;
import net.bpelunit.framework.model.test.data.ReceiveCondition;
import net.bpelunit.framework.model.test.report.ITestArtefact;
import net.bpelunit.framework.model.test.report.StateData;
import net.bpelunit.framework.xml.result.XMLActivity;
import net.bpelunit.framework.xml.result.XMLArtefact;
import net.bpelunit.framework.xml.result.XMLCopyOperation;
import net.bpelunit.framework.xml.result.XMLData;
import net.bpelunit.framework.xml.result.XMLInfo;
import net.bpelunit.framework.xml.result.XMLPartnerTrack;
import net.bpelunit.framework.xml.result.XMLReceiveCondition;
import net.bpelunit.framework.xml.result.XMLTestCase;
import net.bpelunit.framework.xml.result.XMLTestResult;
import net.bpelunit.framework.xml.result.XMLTestResultDocument;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;

public final class XMLResultProducer {
    private XMLResultProducer() {
    }

    public static void writeXML(OutputStream out, TestSuite suite) throws IOException {
        XMLTestResultDocument xmlTestResultDocument = XMLResultProducer.getXMLResults(suite);
        XmlOptions opts = new XmlOptions();
        opts.setSavePrettyPrint();
        opts.setSavePrettyPrintIndent(4);
        xmlTestResultDocument.save(out, opts);
    }

    private static void handleLowLevel(XMLActivity xmlActivity, ITestArtefact testArtefact) {
        if (testArtefact instanceof Activity) {
            Activity activity = (Activity)testArtefact;
            XMLActivity xmlActivityNew = xmlActivity.addNewActivity();
            XMLResultProducer.transferState(activity, xmlActivityNew);
            xmlActivityNew.setType(activity.getActivityCode());
            List<ITestArtefact> children = activity.getChildren();
            for (ITestArtefact innerArtefact : children) {
                XMLResultProducer.handleLowLevel(xmlActivityNew, innerArtefact);
            }
        } else if (testArtefact instanceof DataSpecification) {
            DataSpecification dataSpec = (DataSpecification)testArtefact;
            XMLData xmlData = xmlActivity.addNewDataPackage();
            XMLResultProducer.transferState(dataSpec, xmlData);
            List<ITestArtefact> children = dataSpec.getChildren();
            for (ITestArtefact artefact : children) {
                if (artefact instanceof net.bpelunit.framework.model.test.data.XMLData) {
                    net.bpelunit.framework.model.test.data.XMLData data = (net.bpelunit.framework.model.test.data.XMLData)artefact;
                    XMLData.XmlData xmlDataNew = xmlData.addNewXmlData();
                    try {
                        xmlDataNew.set(XmlObject.Factory.parse((String)data.getXmlData()));
                    }
                    catch (XmlException e) {
                        // empty catch block
                    }
                    xmlDataNew.setName(data.getName());
                    continue;
                }
                if (!(artefact instanceof ReceiveCondition)) continue;
                ReceiveCondition cond = (ReceiveCondition)artefact;
                XMLReceiveCondition xmlReceiveCondition = xmlData.addNewReceiveCondition();
                XMLResultProducer.handleReceiveCondition(cond, xmlReceiveCondition);
            }
        } else if (testArtefact instanceof DataCopyOperation) {
            DataCopyOperation dataCopy = (DataCopyOperation)testArtefact;
            XMLCopyOperation xmlCopy = xmlActivity.addNewCopyOperation();
            xmlCopy.setFrom(dataCopy.getFromXPath());
            xmlCopy.setTo(dataCopy.getToXPath());
            xmlCopy.setCopyiedValue(dataCopy.getCopiedValue());
            XMLResultProducer.transferState(dataCopy, xmlCopy);
        }
    }

    private static void handleReceiveCondition(ReceiveCondition cond, XMLReceiveCondition xmlReceiveCondition) {
        XMLReceiveCondition.Condition condition = xmlReceiveCondition.addNewCondition();
        condition.setExpression(cond.getExpression());
        condition.setExpectedValue(cond.getExpectedValue());
        condition.setActualValue(cond.getActualValue());
        XMLResultProducer.transferState(cond, xmlReceiveCondition);
    }

    private static void handleStateData(XMLInfo info, StateData stateData) {
        info.setName(stateData.getKey());
        info.setStringValue(stateData.getValue());
    }

    private static void transferState(ITestArtefact artefact, XMLArtefact result) {
        result.setName(artefact.getName());
        result.setResult(artefact.getStatus().getCode().toString());
        result.setMessage(artefact.getStatus().getMessage());
        String exceptionMessage = artefact.getStatus().getExceptionMessage();
        if (exceptionMessage != null) {
            result.setException(exceptionMessage);
        }
        List<StateData> stateData = artefact.getStateData();
        for (StateData data : stateData) {
            XMLResultProducer.handleStateData(result.addNewState(), data);
        }
    }

    public static XMLTestResultDocument getXMLResults(TestSuite suite) {
        XMLTestResultDocument xmlTestResultDocument = XMLTestResultDocument.Factory.newInstance();
        XMLTestResult xmlTestResult = xmlTestResultDocument.addNewTestResult();
        XMLResultProducer.transferState(suite, xmlTestResult);
        List<ITestArtefact> children = suite.getChildren();
        for (ITestArtefact artefact : children) {
            TestCase testCase = (TestCase)artefact;
            XMLTestCase xmlTestCase = xmlTestResult.addNewTestCase();
            XMLResultProducer.transferState(testCase, xmlTestCase);
            List<PartnerTrack> partnerTracks = testCase.getPartnerTracks();
            for (PartnerTrack track : partnerTracks) {
                XMLPartnerTrack xmlPartnerTrack = xmlTestCase.addNewPartnerTrack();
                XMLResultProducer.transferState(track, xmlPartnerTrack);
                List<ITestArtefact> trackChildren = track.getChildren();
                for (ITestArtefact artefact2 : trackChildren) {
                    Activity activity = (Activity)artefact2;
                    XMLPartnerTrack.Activity xmlActivity = xmlPartnerTrack.addNewActivity();
                    xmlActivity.setType(activity.getActivityCode());
                    XMLResultProducer.transferState(activity, xmlActivity);
                    List<ITestArtefact> activityChildren = activity.getChildren();
                    for (ITestArtefact artefact3 : activityChildren) {
                        XMLResultProducer.handleLowLevel(xmlActivity, artefact3);
                    }
                }
            }
        }
        return xmlTestResultDocument;
    }
}

