/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.framework.control.ext;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import net.bpelunit.framework.BPELUnitRunner;
import net.bpelunit.framework.control.ext.IBPELDeployer;
import net.bpelunit.framework.control.ext.IDataSource;
import net.bpelunit.framework.control.ext.IHeaderProcessor;
import net.bpelunit.framework.control.ext.ISOAPEncoder;
import net.bpelunit.framework.control.run.TestCaseRunner;
import net.bpelunit.framework.coverage.CoverageConstants;
import net.bpelunit.framework.exception.ConfigurationException;
import net.bpelunit.framework.exception.SpecificationException;
import net.bpelunit.framework.xml.config.XMLConfiguration;
import net.bpelunit.framework.xml.config.XMLProperty;
import net.bpelunit.framework.xml.config.XMLTestConfiguration;
import net.bpelunit.framework.xml.config.XMLTestConfigurationDocument;
import net.bpelunit.framework.xml.extension.XMLBPELUnitCoreExtensions;
import net.bpelunit.framework.xml.extension.XMLExtension;
import net.bpelunit.framework.xml.extension.XMLExtensionRegistryDocument;
import net.bpelunit.util.JDomUtil;
import org.apache.log4j.Logger;
import org.apache.xmlbeans.XmlException;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ExtensionRegistry {
    private static final String SETTER_PREFIX = "set";
    private static Logger fsLogger = Logger.getLogger((String)"net.bpelunit.framework.ExtensionRegistry");
    private static Map<String, Class<? extends IBPELDeployer>> fsDeployerRegistry;
    private static Map<String, Map<String, String>> fsDeployerOptions;
    private static Map<String, Class<? extends ISOAPEncoder>> fsEncoderRegistry;
    private static Map<String, Class<? extends IHeaderProcessor>> fsHeaderRegistry;
    private static Map<String, Class<? extends IDataSource>> fsDataSourceRegistry;
    private static boolean fsIgnoreOnNotFound;

    private ExtensionRegistry() {
    }

    public static void loadRegistry(URL configurationFileURL, boolean ignoreOnNotFound) throws ConfigurationException {
        fsIgnoreOnNotFound = ignoreOnNotFound;
        fsDeployerRegistry = new HashMap<String, Class<? extends IBPELDeployer>>();
        fsEncoderRegistry = new HashMap<String, Class<? extends ISOAPEncoder>>();
        fsHeaderRegistry = new HashMap<String, Class<? extends IHeaderProcessor>>();
        fsDataSourceRegistry = new HashMap<String, Class<? extends IDataSource>>();
        fsDeployerOptions = new HashMap<String, Map<String, String>>();
        try {
            XMLExtensionRegistryDocument document = XMLExtensionRegistryDocument.Factory.parse(configurationFileURL);
            XMLBPELUnitCoreExtensions testExtensions = document.getExtensionRegistry();
            for (XMLExtension deployer : testExtensions.getDeployerList()) {
                ExtensionRegistry.load(deployer, IBPELDeployer.class, "Deployer", fsDeployerRegistry);
            }
            for (XMLExtension encoder : testExtensions.getEncoderList()) {
                ExtensionRegistry.load(encoder, ISOAPEncoder.class, "Encoder", fsEncoderRegistry);
            }
            for (XMLExtension hproc : testExtensions.getHeaderProcessorList()) {
                ExtensionRegistry.load(hproc, IHeaderProcessor.class, "Header Processor", fsHeaderRegistry);
            }
            for (XMLExtension dataSource : testExtensions.getDataSourceList()) {
                ExtensionRegistry.load(dataSource, IDataSource.class, "Data Source", fsDataSourceRegistry);
            }
        }
        catch (XmlException e) {
            throw new ConfigurationException("An XML reading error occurred reading the deployment plug-ins from file " + configurationFileURL, e);
        }
        catch (IOException e) {
            throw new ConfigurationException("An I/O error occurred reading the deployment plug-ins from file " + configurationFileURL, e);
        }
    }

    public static IBPELDeployer createNewDeployerForType(String type) throws SpecificationException {
        return (IBPELDeployer)ExtensionRegistry.createObject(fsDeployerRegistry.get(type), type);
    }

    public static ISOAPEncoder createNewEncoderForType(String styleEncoding) throws SpecificationException {
        return (ISOAPEncoder)ExtensionRegistry.createObject(fsEncoderRegistry.get(styleEncoding), styleEncoding);
    }

    public static IHeaderProcessor createNewHeaderProcessorForType(String type) throws SpecificationException {
        return (IHeaderProcessor)ExtensionRegistry.createObject(fsHeaderRegistry.get(type), type);
    }

    public static IDataSource createNewDataSourceForType(String type) throws SpecificationException {
        return (IDataSource)ExtensionRegistry.createObject(fsDataSourceRegistry.get(type), type);
    }

    protected static int getExtensionCount() {
        return fsDeployerRegistry.size() + fsEncoderRegistry.size() + fsHeaderRegistry.size();
    }

    private static Object createObject(Class<?> clazz, String type) throws SpecificationException {
        if (clazz == null) {
            throw new SpecificationException("No deployer class registered for type " + type);
        }
        Object deployer = null;
        try {
            deployer = clazz.newInstance();
            return deployer;
        }
        catch (InstantiationException e) {
            throw new SpecificationException("The deployment class for type " + type + " from the configuration could not be instantiated. Is it a non-abstract class?", e);
        }
        catch (IllegalAccessException e) {
            throw new SpecificationException("The deployment class for type " + type + " from the configuration is not accessible. Does it have a nullary constructor?", e);
        }
    }

    private static <T> void load(XMLExtension extension, Class<? extends T> requiredType, String readableName, Map<String, Class<? extends T>> registry) throws ConfigurationException {
        try {
            Class<?> theClazz = ExtensionRegistry.getClassFor(extension);
            if (!requiredType.isAssignableFrom(theClazz)) {
                throw new ConfigurationException("The " + readableName + " class for type " + extension.getType() + " from the configuration does not implement " + requiredType.getSimpleName());
            }
            registry.put(extension.getType(), theClazz);
        }
        catch (ConfigurationException e) {
            if (!fsIgnoreOnNotFound) {
                throw new ConfigurationException(e.getMessage(), e);
            }
            fsLogger.debug((Object)("Configuration Error in extensions.xml; " + e.getMessage()));
        }
    }

    private static Class<?> getClassFor(XMLExtension deployer) throws ConfigurationException {
        String type = deployer.getType();
        String clazz = deployer.getExtensionClass();
        try {
            return Class.forName(clazz);
        }
        catch (ClassNotFoundException e) {
            throw new ConfigurationException("The extension class for type " + type + " from the configuration could not be found. Check the CLASSPATH.", e);
        }
        catch (NoClassDefFoundError e) {
            throw new ConfigurationException("Requirements for extension class of type " + type + " from the configuration could not be found. Check the CLASSPATH.", e);
        }
    }

    public static void loadDeploymentConfiguration(URL fileURL) throws ConfigurationException {
        try {
            XMLTestConfigurationDocument document = XMLTestConfigurationDocument.Factory.parse(fileURL);
            XMLTestConfiguration testConfig = document.getTestConfiguration();
            for (XMLConfiguration configuration : testConfig.getConfigurationList()) {
                String deployer = configuration.getDeployer();
                for (XMLProperty property : configuration.getPropertyList()) {
                    Map<String, String> options = fsDeployerOptions.get(deployer);
                    if (options == null) {
                        options = new HashMap<String, String>();
                        fsDeployerOptions.put(deployer, options);
                    }
                    options.put(property.getName(), property.getStringValue());
                }
            }
        }
        catch (XmlException e) {
            throw new ConfigurationException("An XML reading error occurred reading the deployment configuration from file " + fileURL, e);
        }
        catch (IOException e) {
            throw new ConfigurationException("An I/O error occurred reading the deployment configuration from file " + fileURL, e);
        }
    }

    public static void configure(String deployerID, IBPELDeployer deployer) {
        Map<String, String> options = fsDeployerOptions.get(deployerID);
        if (options == null) {
            fsLogger.warn((Object)("No deployment configuration for type " + deployerID + " was found."));
            options = new HashMap<String, String>();
        }
        ExtensionRegistry.configureDeployer(deployer, options);
    }

    public static Map<String, String> getGlobalConfigurationForDeployer(IBPELDeployer deployer) {
        String deployerId = ExtensionRegistry.getIdForDeployer(deployer);
        return fsDeployerOptions.get(deployerId);
    }

    private static String getIdForDeployer(IBPELDeployer deployer) {
        String deployerId = null;
        for (String key : fsDeployerRegistry.keySet()) {
            if (deployer.getClass() != fsDeployerRegistry.get(key)) continue;
            deployerId = key;
            break;
        }
        return deployerId;
    }

    public static void configureDeployer(IBPELDeployer deployer, Map<String, String> options) {
        for (String key : options.keySet()) {
            try {
                Method m = deployer.getClass().getMethod(ExtensionRegistry.setterName(key), String.class);
                if (m.getAnnotation(IBPELDeployer.IBPELDeployerOption.class) == null) continue;
                m.invoke((Object)deployer, options.get(key));
            }
            catch (Exception e) {}
        }
    }

    private static String setterName(String key) {
        return SETTER_PREFIX + key;
    }

    public static Map<String, List<String>> loadCoverageToolConfiguration(File file) throws ConfigurationException {
        SAXBuilder builder = new SAXBuilder();
        Map<String, List<String>> map = null;
        try {
            Document doc = builder.build(file);
            Element config = doc.getRootElement();
            String attribute = config.getAttributeValue("waitingTime");
            if (attribute != null) {
                try {
                    int i = Integer.parseInt(attribute);
                    TestCaseRunner.setWaitTimeForCoverageMarkers(i);
                }
                catch (Exception e) {
                    BPELUnitRunner.getCoverageMeasurmentTool().setErrorStatus("Configuration of wait time is not valid.");
                }
            }
            map = ExtensionRegistry.handleMetricElements(config);
        }
        catch (JDOMException e) {
            throw new ConfigurationException("An XML reading error occurred reading the configuration of coverage tool from file " + file.getAbsolutePath(), e);
        }
        catch (IOException e) {
            throw new ConfigurationException("An I/O error occurred reading the configuration of coverage tool from file " + file.getAbsolutePath(), e);
        }
        return map;
    }

    private static Map<String, List<String>> handleMetricElements(Element config) {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        List children = JDomUtil.getChildren((Element)config, (String)"metric", (Namespace)CoverageConstants.NAMESPACE_CONFIGURATION);
        for (Element element : children) {
            String attribute = element.getAttributeValue("name");
            if (attribute == null) continue;
            if (attribute.equalsIgnoreCase("ActivityCoverage")) {
                map.put("ActivityCoverage", null);
                Element child2 = element.getChild("property", CoverageConstants.NAMESPACE_CONFIGURATION);
                String name = child2.getAttributeValue("name");
                if (name == null || !name.equals("IncludeBasicActivities")) continue;
                ArrayList<String> list = new ArrayList<String>();
                list.addAll(ExtensionRegistry.analyzeString(child2.getText()));
                map.put("ActivityCoverage", list);
                continue;
            }
            if (attribute.equalsIgnoreCase("BranchCoverage")) {
                map.put("BranchCoverage", null);
                continue;
            }
            if (attribute.equalsIgnoreCase("LinkCoverage")) {
                map.put("LinkCoverage", null);
                continue;
            }
            if (attribute.equalsIgnoreCase("FaultHandlerCoverage")) {
                map.put("FaultHandlerCoverage", null);
                continue;
            }
            if (!attribute.equalsIgnoreCase("CompensationHandlerCoverage")) continue;
            map.put("CompensationHandlerCoverage", null);
        }
        return map;
    }

    static List<String> analyzeString(String activities) {
        ArrayList<String> basicActivities = new ArrayList<String>();
        Scanner scanner = new Scanner(activities);
        scanner.useDelimiter(",");
        while (scanner.hasNext()) {
            basicActivities.add(scanner.next().trim());
        }
        return basicActivities;
    }

    public static Collection<String> getPossibleConfigurationOptions(Class<? extends IBPELDeployer> deployerClass, boolean forSuite) {
        return ExtensionRegistry.getConfigurationAnnotations(deployerClass, forSuite).keySet();
    }

    public static Map<String, IBPELDeployer.IBPELDeployerOption> getConfigurationAnnotations(Class<? extends IBPELDeployer> deployerClass, boolean forSuite) {
        HashMap<String, IBPELDeployer.IBPELDeployerOption> configurationOptions = new HashMap<String, IBPELDeployer.IBPELDeployerOption>();
        for (Method m : deployerClass.getMethods()) {
            String name = m.getName();
            IBPELDeployer.IBPELDeployerOption annotation = m.getAnnotation(IBPELDeployer.IBPELDeployerOption.class);
            if (annotation == null || !ExtensionRegistry.isStringSetter(m) || !forSuite && annotation.testSuiteSpecific()) continue;
            String optionName = name.substring(SETTER_PREFIX.length());
            configurationOptions.put(optionName, annotation);
        }
        return configurationOptions;
    }

    public static String getDefaultValueFor(Class<? extends IBPELDeployer> deployer, String configurationParameter) {
        try {
            Method m = deployer.getMethod(ExtensionRegistry.setterName(configurationParameter), String.class);
            IBPELDeployer.IBPELDeployerOption annotation = m.getAnnotation(IBPELDeployer.IBPELDeployerOption.class);
            return annotation.defaultValue();
        }
        catch (Exception e) {
            return "";
        }
    }

    public static Map<String, IDataSource.ConfigurationOption> getConfigurationAnnotations(Class<? extends IDataSource> dsClass) {
        HashMap<String, IDataSource.ConfigurationOption> configurationOptions = new HashMap<String, IDataSource.ConfigurationOption>();
        for (Method m : dsClass.getMethods()) {
            IDataSource.ConfigurationOption annotation = m.getAnnotation(IDataSource.ConfigurationOption.class);
            if (annotation == null || !ExtensionRegistry.isStringSetter(m)) continue;
            String name = m.getName();
            String optionName = name.substring(SETTER_PREFIX.length());
            configurationOptions.put(optionName, annotation);
        }
        return configurationOptions;
    }

    static boolean isStringSetter(Method m) {
        Class<?>[] parameters = m.getParameterTypes();
        Class<?> returnType = m.getReturnType();
        String name = m.getName();
        return name.startsWith(SETTER_PREFIX) && parameters.length == 1 && String.class.equals(parameters[0]) && returnType.equals(Void.TYPE);
    }
}

