/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.framework.control.deploy.activebpel;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.soap.SOAPException;
import net.bpelunit.framework.control.deploy.activebpel.BPRDeployRequestEntity;
import net.bpelunit.framework.control.deploy.activebpel.ProcessListRequestEntity;
import net.bpelunit.framework.control.deploy.activebpel.TerminateProcessRequestEntity;
import net.bpelunit.framework.control.ext.IBPELDeployer;
import net.bpelunit.framework.control.ext.IDeployment;
import net.bpelunit.framework.control.util.NoPersistenceConnectionManager;
import net.bpelunit.framework.exception.DeploymentException;
import net.bpelunit.framework.model.ProcessUnderTest;
import org.apache.commons.httpclient.DefaultHttpMethodRetryHandler;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@IBPELDeployer.IBPELDeployerCapabilities(canDeploy=true, canMeasureTestCoverage=true)
public class ActiveBPELDeployer
implements IBPELDeployer {
    private static final int HTTP_OK = 200;
    private static final String ERRCOUNT_START = "&lt;deploymentSummary numErrors=&quot;";
    private static final String ERRCOUNT_END = "&quot";
    static final String DEFAULT_DEPLOYMENT_URL = "http://localhost:8080/active-bpel/services/DeployBPRService";
    static final String DEFAULT_ADMIN_URL = "http://localhost:8080/active-bpel/services/ActiveBpelAdmin";
    static final String DEFAULT_APPSERVER_DIR_ENVVAR = "CATALINA_HOME";
    private Logger fLogger = Logger.getLogger(this.getClass());
    private String fResultingFile;
    private File fBPRFile;
    private String fDeploymentDirectory;
    private String fDeploymentAdminServiceURL = "http://localhost:8080/active-bpel/services/DeployBPRService";
    private String fAdminServiceURL = "http://localhost:8080/active-bpel/services/ActiveBpelAdmin";
    private ProcessUnderTest put;
    private static int terminatedProcessCount = 0;

    @IBPELDeployer.IBPELDeployerOption(testSuiteSpecific=false)
    public void setBPRFile(String bprFile) {
        this.fBPRFile = new File(bprFile);
    }

    @IBPELDeployer.IBPELDeployerOption
    public void setDeploymentDirectory(String deploymentDirectory) {
        if (deploymentDirectory != null) {
            this.fDeploymentDirectory = deploymentDirectory;
        }
    }

    public String getDeploymentAdminServiceURL() {
        return this.fDeploymentAdminServiceURL;
    }

    @IBPELDeployer.IBPELDeployerOption(defaultValue="http://localhost:8080/active-bpel/services/DeployBPRService")
    public void setDeploymentAdminServiceURL(String deploymentAdminServiceURL) {
        if (deploymentAdminServiceURL != null) {
            this.fDeploymentAdminServiceURL = deploymentAdminServiceURL;
        }
    }

    public String getAdministrationServiceURL() {
        return this.fAdminServiceURL;
    }

    @IBPELDeployer.IBPELDeployerOption(defaultValue="http://localhost:8080/active-bpel/services/ActiveBpelAdmin")
    public void setAdministrationServiceURL(String adminServiceURL) {
        if (adminServiceURL != null) {
            this.fAdminServiceURL = adminServiceURL;
        }
    }

    @Override
    public void deploy(String pathToTest, ProcessUnderTest put) throws DeploymentException {
        BPRDeployRequestEntity re;
        this.put = put;
        this.fLogger.info((Object)("ActiveBPEL deployer got request to deploy " + put));
        if (this.fDeploymentDirectory == null && System.getenv(DEFAULT_APPSERVER_DIR_ENVVAR) != null) {
            this.fDeploymentDirectory = System.getenv(DEFAULT_APPSERVER_DIR_ENVVAR) + File.separator + "bpr";
        }
        this.check(this.fBPRFile, "BPR File");
        this.check(this.fDeploymentDirectory, "deployment directory path");
        this.check(this.fDeploymentAdminServiceURL, "deployment admin server URL");
        this.check(this.fAdminServiceURL, "engine admin server URL");
        boolean fileReplaced = false;
        String archivePath = this.getArchiveLocation(pathToTest);
        File uploadingFile = new File(archivePath);
        if (!uploadingFile.exists()) {
            throw new DeploymentException("ActiveBPEL deployer could not find BPR file " + this.fBPRFile);
        }
        File resultingFile = new File(this.fDeploymentDirectory, this.fBPRFile.getName());
        try {
            re = new BPRDeployRequestEntity(uploadingFile);
        }
        catch (IOException e) {
            throw new DeploymentException("An input/output error occured in ActivBPEL deployer when deploying: " + e.getMessage(), e);
        }
        catch (SOAPException e) {
            throw new DeploymentException("An error occurred while creating SOAP message for ActiveBPEL deployment: " + e.getMessage(), (Exception)((Object)e));
        }
        this.fLogger.info((Object)("ActiveBPEL deployer about to send SOAP request to deploy " + put));
        try {
            RequestResult result = ActiveBPELDeployer.sendRequestToActiveBPEL(this.fDeploymentAdminServiceURL, re);
            if (result.getStatusCode() < 200 || result.getStatusCode() > 299 || this.errorsInSummary(result.getResponseBody())) {
                throw new DeploymentException("ActiveBPEL Server reported a Deployment Error: " + result.getResponseBody());
            }
            this.fResultingFile = resultingFile.toString();
        }
        catch (HttpException e) {
            throw new DeploymentException("Problem contacting the ActiveBPEL Server: " + e.getMessage(), (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new DeploymentException("Problem contacting the ActiveBPEL Server: " + e.getMessage(), e);
        }
        finally {
            if (fileReplaced && uploadingFile.exists()) {
                uploadingFile.delete();
            }
        }
    }

    @Override
    public void undeploy(String path, ProcessUnderTest deployable) throws DeploymentException {
        if (this.fResultingFile == null) {
            return;
        }
        File bprFile = new File(this.fResultingFile);
        if (this.fResultingFile == null) {
            throw new DeploymentException("Cannot undeploy BPR for Deployable " + deployable + ": Metadata about file name not found.");
        }
        if (!bprFile.exists()) {
            throw new DeploymentException("Cannot undeploy BPR for Deployable " + deployable + ": File " + bprFile + " not found.");
        }
        if (!bprFile.delete()) {
            throw new DeploymentException("Cannot undeploy BPR for Deployable " + deployable + ": File " + bprFile + " could not be deleted.");
        }
        try {
            this.terminateAllRunningProcesses(deployable.getName());
        }
        catch (Exception e) {
            throw new DeploymentException(e.getLocalizedMessage(), e);
        }
    }

    @Override
    public String getArchiveLocation(String pathToTest) {
        try {
            if (this.fBPRFile.isAbsolute()) {
                return this.fBPRFile.getCanonicalPath();
            }
            return new File(pathToTest, this.fBPRFile.getName()).getCanonicalPath();
        }
        catch (IOException e) {
            return this.fBPRFile.getAbsolutePath();
        }
    }

    @Override
    public void setArchiveLocation(String archive) {
        this.setBPRFile(archive);
    }

    private void check(Object toCheck, String description) throws DeploymentException {
        if (toCheck == null) {
            throw new DeploymentException("ActiveBPEL deployment configuration is missing the " + description + ".");
        }
    }

    @Override
    public IDeployment getDeployment(ProcessUnderTest processUnderTest) throws DeploymentException {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static RequestResult sendRequestToActiveBPEL(String url, RequestEntity re) throws IOException {
        PostMethod method = null;
        try {
            HttpClient client = new HttpClient((HttpConnectionManager)new NoPersistenceConnectionManager());
            method = new PostMethod(url);
            method.setRequestEntity(re);
            method.getParams().setParameter("http.method.retry-handler", (Object)new DefaultHttpMethodRetryHandler(1, false));
            method.addRequestHeader("SOAPAction", "");
            client.executeMethod((HttpMethod)method);
            RequestResult result = new RequestResult();
            result.setStatusCode(method.getStatusCode());
            result.setResponseBody(method.getResponseBodyAsString());
            RequestResult requestResult = result;
            return requestResult;
        }
        finally {
            if (method != null) {
                method.releaseConnection();
            }
        }
    }

    private void terminateAllRunningProcesses(String processName) throws DeploymentException {
        for (int pid : this.listRunningProcesses(processName)) {
            this.terminateProcess(pid);
        }
    }

    private List<Integer> listRunningProcesses(String processName) throws DeploymentException {
        try {
            ArrayList<Integer> vProcesses = new ArrayList<Integer>();
            RequestResult listResponse = ActiveBPELDeployer.sendRequestToActiveBPEL(this.fAdminServiceURL, new ProcessListRequestEntity(processName));
            if (listResponse.getStatusCode() != 200) {
                throw new DeploymentException(String.format("Could not obtain the running process list: got status code %d\nResponse:\n%s", listResponse.getStatusCode(), listResponse.getResponseBody()));
            }
            Pattern patPID = Pattern.compile("<[^>]*processId>\\s*([0-9]+)\\s*</[^>]+>");
            Matcher matcher = patPID.matcher(listResponse.getResponseBody());
            while (matcher.find()) {
                vProcesses.add(Integer.parseInt(matcher.group(1)));
            }
            return vProcesses;
        }
        catch (Exception e) {
            throw new DeploymentException("Could not obtain the running process list: " + e.toString(), e);
        }
    }

    private void terminateProcess(int pid) throws DeploymentException {
        try {
            ++terminatedProcessCount;
            RequestResult response = ActiveBPELDeployer.sendRequestToActiveBPEL(this.fAdminServiceURL, new TerminateProcessRequestEntity(pid));
            if (response.getStatusCode() != 200) {
                throw new Exception(String.format("Could not kill process #%d: non-OK status code %d\nResponse:\n%s", pid, response.getStatusCode(), response.getResponseBody()));
            }
        }
        catch (Exception e) {
            throw new DeploymentException(String.format("Could not kill process #%d: %s", pid, e.toString()), e);
        }
    }

    private boolean errorsInSummary(String responseBody) {
        int startErrorCount = responseBody.indexOf(ERRCOUNT_START);
        if (startErrorCount == -1) {
            return false;
        }
        int endErrorCount = responseBody.indexOf(ERRCOUNT_END, startErrorCount += ERRCOUNT_START.length());
        if (endErrorCount == -1) {
            return false;
        }
        String sErrorCount = responseBody.substring(startErrorCount, endErrorCount);
        int errorCount = Integer.parseInt(sErrorCount);
        return errorCount > 0;
    }

    @Override
    public void cleanUpAfterTestCase() throws DeploymentException {
        this.terminateAllRunningProcesses(this.put.getName());
    }

    static int getTerminatedProcessCount() {
        return terminatedProcessCount;
    }

    private static class RequestResult {
        private int statusCode;
        private String responseBody;

        private RequestResult() {
        }

        public void setStatusCode(int statusCode) {
            this.statusCode = statusCode;
        }

        public int getStatusCode() {
            return this.statusCode;
        }

        public void setResponseBody(String responseBody) {
            this.responseBody = responseBody;
        }

        public String getResponseBody() {
            return this.responseBody;
        }
    }
}

