/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.framework.control.datasource;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.bpelunit.framework.BPELUnitRunner;
import net.bpelunit.framework.control.ext.IDataSource;
import net.bpelunit.framework.exception.DataSourceException;
import net.bpelunit.framework.exception.SpecificationException;
import net.bpelunit.framework.xml.suite.XMLDataSource;
import net.bpelunit.framework.xml.suite.XMLProperty;
import net.bpelunit.framework.xml.suite.XMLTestCase;
import net.bpelunit.framework.xml.suite.XMLTestSuite;
import org.apache.log4j.Logger;
import org.apache.velocity.context.Context;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DataSourceUtil {
    private static final Logger LOGGER = Logger.getLogger(DataSourceUtil.class);

    private DataSourceUtil() {
    }

    public static IDataSource createDataSource(XMLTestSuite xmlTestSuite, XMLTestCase xmlTestCase, File bptsDir, BPELUnitRunner runner) throws DataSourceException {
        XMLDataSource xmlDataSource = null;
        if (xmlTestCase.isSetSetUp() && xmlTestCase.getSetUp().isSetDataSource()) {
            xmlDataSource = xmlTestCase.getSetUp().getDataSource();
        } else if (xmlTestSuite.isSetSetUp() && xmlTestSuite.getSetUp().isSetDataSource()) {
            xmlDataSource = xmlTestSuite.getSetUp().getDataSource();
        }
        if (xmlDataSource != null) {
            String type = xmlDataSource.getType();
            InputStream istream = DataSourceUtil.getStreamForDataSource(xmlDataSource, bptsDir);
            Map<String, String> properties = DataSourceUtil.createPropertyMap(xmlDataSource.getPropertyList());
            try {
                IDataSource dataSource = runner.createNewDataSource(type);
                return DataSourceUtil.initializeDataSource(dataSource, istream, properties);
            }
            catch (SpecificationException e) {
                throw new DataSourceException("Could not create data source instance for type " + type, e);
            }
        }
        return null;
    }

    public static IDataSource initializeDataSource(IDataSource dataSource, InputStream istream, Map<String, String> properties) throws DataSourceException {
        for (Map.Entry<String, String> prop : properties.entrySet()) {
            DataSourceUtil.setProperty(dataSource, prop.getKey(), prop.getValue());
        }
        dataSource.loadFromStream(istream);
        return dataSource;
    }

    private static void setProperty(IDataSource ds, String key, String value) throws DataSourceException {
        try {
            Method method = ds.getClass().getMethod("set" + DataSourceUtil.toFirstUpper(key), String.class);
            if (method.getAnnotation(IDataSource.ConfigurationOption.class) == null) {
                throw new Exception("@ConfigurationOption missing for " + method.getName());
            }
            method.invoke((Object)ds, value);
        }
        catch (InvocationTargetException e) {
            Throwable targetException = e.getTargetException();
            if (targetException instanceof DataSourceException) {
                throw (DataSourceException)targetException;
            }
            throw new DataSourceException("Property " + key + " is invalid for data source", targetException);
        }
        catch (Exception e) {
            throw new DataSourceException("Property " + key + " is invalid for data source", e);
        }
    }

    static String toFirstUpper(String s) {
        if (s == null || "".equals(s)) {
            return "";
        }
        return s.substring(0, 1).toUpperCase() + s.substring(1);
    }

    public static InputStream getStreamForDataSource(XMLDataSource xmlDataSource, File basedir) throws DataSourceException {
        return DataSourceUtil.getStreamForDataSource(xmlDataSource.getContents(), xmlDataSource.getSrc(), basedir);
    }

    public static InputStream getStreamForDataSource(String contents, String externalReference, File basedir) throws DataSourceException {
        if (contents != null) {
            if (externalReference != null) {
                throw new DataSourceException("Inline content and external references cannot be used at the same time in a data source: it is ambiguous");
            }
            return new ByteArrayInputStream(contents.getBytes());
        }
        if (externalReference != null) {
            try {
                return new URL(externalReference).openStream();
            }
            catch (MalformedURLException e) {
            }
            catch (IllegalArgumentException e) {
            }
            catch (IOException e) {
                throw new DataSourceException("Error while opening URL '" + externalReference + "'", e);
            }
            try {
                File f = new File(externalReference);
                if (f.isAbsolute()) {
                    return new FileInputStream(f);
                }
                return new FileInputStream(new File(basedir, externalReference));
            }
            catch (FileNotFoundException e) {
                throw new DataSourceException("File not found: '" + externalReference + "'", e);
            }
        }
        throw new DataSourceException("No inline contents and no external reference are available");
    }

    public static void initializeContext(Context ctx, IDataSource ds, int rowIndex) throws DataSourceException {
        String[] fieldNames;
        ds.setRow(rowIndex);
        for (String fieldName : fieldNames = ds.getFieldNames()) {
            LOGGER.debug((Object)("Put " + fieldName + " -> " + ds.getValueFor(fieldName)));
            ctx.put(fieldName, ds.getValueFor(fieldName));
        }
    }

    private static Map<String, String> createPropertyMap(List<XMLProperty> propertyList) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (XMLProperty prop : propertyList) {
            map.put(prop.getName(), prop.getStringValue());
        }
        return map;
    }
}

