/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.framework;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.wsdl.Definition;
import javax.wsdl.WSDLException;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import net.bpelunit.framework.BPELUnitRunner;
import net.bpelunit.framework.control.datasource.DataSourceUtil;
import net.bpelunit.framework.control.ext.IBPELDeployer;
import net.bpelunit.framework.control.ext.IDataSource;
import net.bpelunit.framework.control.ext.IHeaderProcessor;
import net.bpelunit.framework.control.ext.ISOAPEncoder;
import net.bpelunit.framework.control.soap.NamespaceContextImpl;
import net.bpelunit.framework.control.util.ActivityUtil;
import net.bpelunit.framework.control.util.BPELUnitConstants;
import net.bpelunit.framework.control.util.BPELUnitUtil;
import net.bpelunit.framework.coverage.ICoverageMeasurementTool;
import net.bpelunit.framework.exception.DataSourceException;
import net.bpelunit.framework.exception.SpecificationException;
import net.bpelunit.framework.model.HumanPartner;
import net.bpelunit.framework.model.Partner;
import net.bpelunit.framework.model.ProcessUnderTest;
import net.bpelunit.framework.model.test.PartnerTrack;
import net.bpelunit.framework.model.test.TestCase;
import net.bpelunit.framework.model.test.TestSuite;
import net.bpelunit.framework.model.test.activity.Activity;
import net.bpelunit.framework.model.test.activity.CompleteHumanTask;
import net.bpelunit.framework.model.test.activity.ReceiveAsync;
import net.bpelunit.framework.model.test.activity.ReceiveSendAsync;
import net.bpelunit.framework.model.test.activity.ReceiveSendSync;
import net.bpelunit.framework.model.test.activity.SendAsync;
import net.bpelunit.framework.model.test.activity.SendReceiveAsync;
import net.bpelunit.framework.model.test.activity.SendReceiveSync;
import net.bpelunit.framework.model.test.activity.TwoWayAsyncActivity;
import net.bpelunit.framework.model.test.activity.Wait;
import net.bpelunit.framework.model.test.data.CompleteHumanTaskSpecification;
import net.bpelunit.framework.model.test.data.DataCopyOperation;
import net.bpelunit.framework.model.test.data.DataSpecification;
import net.bpelunit.framework.model.test.data.ReceiveCondition;
import net.bpelunit.framework.model.test.data.ReceiveDataSpecification;
import net.bpelunit.framework.model.test.data.SOAPOperationCallIdentifier;
import net.bpelunit.framework.model.test.data.SOAPOperationDirectionIdentifier;
import net.bpelunit.framework.model.test.data.SendDataSpecification;
import net.bpelunit.framework.verify.ConditionGroupsExistInTestSuiteValidator;
import net.bpelunit.framework.verify.ITestSuiteValidator;
import net.bpelunit.framework.verify.NoCyclesInConditionGroupInheritanceValidator;
import net.bpelunit.framework.verify.PartnersHaveUniqueNamesValidator;
import net.bpelunit.framework.verify.PartnersInTestCasesHaveNamesValidator;
import net.bpelunit.framework.verify.PartnersUsedInTestCaseAreDeclaredInTestSuiteValidator;
import net.bpelunit.framework.verify.TestSuiteRootInformationValidator;
import net.bpelunit.framework.verify.TestSuiteXMLValidator;
import net.bpelunit.framework.verify.XMLDataIsEitherSetOrImportedValidator;
import net.bpelunit.framework.xml.suite.XMLActivity;
import net.bpelunit.framework.xml.suite.XMLAnyElement;
import net.bpelunit.framework.xml.suite.XMLCompleteHumanTaskActivity;
import net.bpelunit.framework.xml.suite.XMLCondition;
import net.bpelunit.framework.xml.suite.XMLConditionGroup;
import net.bpelunit.framework.xml.suite.XMLCopy;
import net.bpelunit.framework.xml.suite.XMLDeploymentSection;
import net.bpelunit.framework.xml.suite.XMLHeaderProcessor;
import net.bpelunit.framework.xml.suite.XMLHumanPartnerDeploymentInformation;
import net.bpelunit.framework.xml.suite.XMLHumanPartnerTrack;
import net.bpelunit.framework.xml.suite.XMLMapping;
import net.bpelunit.framework.xml.suite.XMLPUTDeploymentInformation;
import net.bpelunit.framework.xml.suite.XMLPartnerDeploymentInformation;
import net.bpelunit.framework.xml.suite.XMLPartnerTrack;
import net.bpelunit.framework.xml.suite.XMLProperty;
import net.bpelunit.framework.xml.suite.XMLReceiveActivity;
import net.bpelunit.framework.xml.suite.XMLSendActivity;
import net.bpelunit.framework.xml.suite.XMLSetUp;
import net.bpelunit.framework.xml.suite.XMLSoapActivity;
import net.bpelunit.framework.xml.suite.XMLTestCase;
import net.bpelunit.framework.xml.suite.XMLTestCasesSection;
import net.bpelunit.framework.xml.suite.XMLTestSuite;
import net.bpelunit.framework.xml.suite.XMLTestSuiteDocument;
import net.bpelunit.framework.xml.suite.XMLTrack;
import net.bpelunit.framework.xml.suite.XMLTwoWayActivity;
import net.bpelunit.framework.xml.suite.XMLWaitActivity;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpecificationLoader {
    private Logger fLogger;
    private BPELUnitRunner fRunner;
    private Map<String, XMLConditionGroup> conditionGroups = new HashMap<String, XMLConditionGroup>();

    public SpecificationLoader(BPELUnitRunner runner) {
        this.fRunner = runner;
        this.fLogger = Logger.getLogger(this.getClass());
    }

    public TestSuite loadTestSuite(File suite) throws SpecificationException {
        try {
            this.fLogger.info((Object)("Loading test suite from file " + suite));
            String path = suite.getCanonicalFile().getParent() + File.separator;
            this.fLogger.info((Object)("Using base path: " + path));
            XMLTestSuiteDocument doc = XMLTestSuiteDocument.Factory.parse(suite);
            this.validateTestSuite(doc);
            this.extractConditionGroups(doc);
            TestSuite testSuite = this.parseSuite(path, doc);
            this.fLogger.info((Object)("Loaded test suite with name \"" + testSuite.getName() + "\" and " + testSuite.getTestCaseCount() + " test cases."));
            if (BPELUnitRunner.measureTestCoverage()) {
                ICoverageMeasurementTool tool = BPELUnitRunner.getCoverageMeasurmentTool();
                try {
                    String encodingStyle = tool.getEncodingStyle();
                    if (encodingStyle != null) {
                        tool.setSOAPEncoder(this.fRunner.createNewSOAPEncoder(encodingStyle));
                    }
                }
                catch (Exception e) {
                    tool.setErrorStatus("CoverageTool: " + e.getMessage());
                }
            }
            return testSuite;
        }
        catch (XmlException e) {
            throw new SpecificationException("An XML reading error occurred when reading the test suite file.", e);
        }
        catch (IOException e) {
            throw new SpecificationException("An I/O error occurred when reading the test suite file.", e);
        }
    }

    private void extractConditionGroups(XMLTestSuiteDocument doc) {
        if (doc == null || doc.getTestSuite() == null || doc.getTestSuite().getConditionGroups() == null) {
            return;
        }
        List<XMLConditionGroup> cgList = doc.getTestSuite().getConditionGroups().getConditionGroupList();
        if (cgList != null) {
            for (XMLConditionGroup cg : cgList) {
                this.conditionGroups.put(cg.getName(), cg);
            }
        }
    }

    private void validateTestSuite(XMLTestSuiteDocument doc) throws SpecificationException {
        ITestSuiteValidator[] validators;
        for (ITestSuiteValidator v : validators = new ITestSuiteValidator[]{new TestSuiteXMLValidator(), new PartnersHaveUniqueNamesValidator(), new PartnersUsedInTestCaseAreDeclaredInTestSuiteValidator(), new TestSuiteRootInformationValidator(), new PartnersInTestCasesHaveNamesValidator(), new ConditionGroupsExistInTestSuiteValidator(), new NoCyclesInConditionGroupInheritanceValidator(), new XMLDataIsEitherSetOrImportedValidator()}) {
            v.validate(doc);
        }
    }

    private TestSuite parseSuite(String testDirectory, XMLTestSuiteDocument xmlTestSuiteDocument) throws SpecificationException, XmlException, IOException {
        XMLTestSuite xmlTestSuite = xmlTestSuiteDocument.getTestSuite();
        String xmlSuiteName = xmlTestSuite.getName();
        URL suiteBaseURL = this.getBaseURL(xmlTestSuite);
        XMLDeploymentSection xmlDeployment = xmlTestSuite.getDeployment();
        XMLPUTDeploymentInformation xmlPut = xmlDeployment.getPut();
        HashMap<String, Partner> suitePartners = new HashMap<String, Partner>();
        ProcessUnderTest processUnderTest = this.createProcessUnderTest(testDirectory, suiteBaseURL, suitePartners, xmlPut);
        String xmlPutWSDL = xmlPut.getWsdl();
        String xmlPutPartnerWSDL = xmlPut.getPartnerWSDL();
        Partner suiteClient = new Partner("client", SpecificationLoader.loadWsdlDefinition(testDirectory, xmlPutWSDL, "client"), SpecificationLoader.loadWsdlDefinition(testDirectory, xmlPutPartnerWSDL, "client"), suiteBaseURL.toString());
        this.createPartners(testDirectory, suiteBaseURL, xmlDeployment, suitePartners);
        Map<String, HumanPartner> humanPartners = this.createHumanPartners(xmlDeployment, suiteBaseURL);
        TestSuite suite = new TestSuite(xmlSuiteName, suiteBaseURL, processUnderTest);
        try {
            this.readTestSuiteSetUpBlock(suite, xmlTestSuite);
        }
        catch (Exception ex) {
            throw new SpecificationException("Error during test suite set up", ex);
        }
        this.createTestCases(testDirectory, xmlTestSuiteDocument, xmlTestSuite, suitePartners, humanPartners, suiteClient, suite);
        return suite;
    }

    private Map<String, HumanPartner> createHumanPartners(XMLDeploymentSection xmlDeployment, URL baseURL) throws SpecificationException {
        HashMap<String, HumanPartner> humanPartners = new HashMap<String, HumanPartner>();
        if (xmlDeployment.getHumanPartnerList() != null) {
            for (XMLHumanPartnerDeploymentInformation hp : xmlDeployment.getHumanPartnerList()) {
                humanPartners.put(hp.getName(), new HumanPartner(hp.getName(), baseURL, hp.getWshtEndpoint(), hp.getUsername(), hp.getPassword()));
            }
        }
        return humanPartners;
    }

    private void createTestCases(String testDirectory, XMLTestSuiteDocument xmlTestSuiteDocument, XMLTestSuite xmlTestSuite, Map<String, Partner> suitePartners, Map<String, HumanPartner> suiteHumanPartners, Partner suiteClient, TestSuite suite) throws SpecificationException {
        XMLTestCasesSection xmlTestCases = xmlTestSuite.getTestCases();
        List<XMLTestCase> xmlTestCaseList = xmlTestCases.getTestCaseList();
        int currentNumber = 0;
        for (XMLTestCase xmlTestCase : xmlTestCaseList) {
            this.createTestCase(testDirectory, xmlTestSuiteDocument, xmlTestSuite, suitePartners, suiteHumanPartners, suiteClient, suite, ++currentNumber, xmlTestCase);
        }
    }

    private void createTestCase(String testDirectory, XMLTestSuiteDocument xmlTestSuiteDocument, XMLTestSuite xmlTestSuite, Map<String, Partner> suitePartners, Map<String, HumanPartner> suiteHumanPartners, Partner suiteClient, TestSuite suite, int currentNumber, XMLTestCase xmlTestCase) throws SpecificationException {
        String xmlTestCaseName = this.getTestCaseName(currentNumber, xmlTestCase);
        boolean isVary = xmlTestCase.getVary();
        int rounds = this.computeNumberOfRounds(xmlTestSuiteDocument, isVary);
        this.fLogger.info((Object)("Varying: " + isVary + " (Rounds: " + rounds + ")"));
        IDataSource dataSource = this.readDataSource(testDirectory, xmlTestSuite, xmlTestCase);
        int nRows = this.getNumberOfRows(dataSource);
        int nRounds = this.getNumberOfRounds(isVary, rounds);
        for (int iRow = 0; iRow < nRows; ++iRow) {
            for (int iRound = 0; iRound < nRounds; ++iRound) {
                String currentTestCaseName = this.getHumanReadableTestCaseName(xmlTestCaseName, rounds, dataSource, iRow, iRound);
                if (xmlTestCase.getAbstract()) continue;
                TestCase test = this.createTestCase(suitePartners, suiteHumanPartners, suiteClient, suite, xmlTestCase, currentTestCaseName, iRound, testDirectory);
                test.setDataSource(dataSource);
                test.setRowIndex(iRow);
                suite.addTestCase(test);
            }
        }
    }

    private String getHumanReadableTestCaseName(String xmlTestCaseName, int rounds, IDataSource dataSource, int iRow, int iRound) {
        String currentTestCaseName = xmlTestCaseName;
        if (dataSource != null) {
            currentTestCaseName = currentTestCaseName + " (Row " + (iRow + 1) + ")";
        }
        if (rounds > 1) {
            currentTestCaseName = currentTestCaseName + " (Round " + (iRound + 1) + ")";
        }
        return currentTestCaseName;
    }

    private int getNumberOfRounds(boolean isVary, int rounds) {
        return isVary && rounds > 0 ? rounds : 1;
    }

    private int getNumberOfRows(IDataSource dataSource) {
        int nRows = dataSource != null ? dataSource.getNumberOfRows() : 1;
        return nRows;
    }

    private String getTestCaseName(int currentNumber, XMLTestCase xmlTestCase) {
        String xmlTestCaseName = xmlTestCase.getName();
        if (xmlTestCaseName == null) {
            xmlTestCaseName = "Test Case " + currentNumber;
        }
        return xmlTestCaseName;
    }

    private IDataSource readDataSource(String testDirectory, XMLTestSuite xmlTestSuite, XMLTestCase xmlTestCase) throws SpecificationException {
        IDataSource dataSource;
        try {
            dataSource = DataSourceUtil.createDataSource(xmlTestSuite, xmlTestCase, new File(testDirectory), this.fRunner);
        }
        catch (DataSourceException e) {
            throw new SpecificationException("There was a problem while initializing the specified data source.", e);
        }
        return dataSource;
    }

    private void createPartners(String testDirectory, URL suiteBaseURL, XMLDeploymentSection xmlDeployment, Map<String, Partner> suitePartners) throws SpecificationException {
        for (XMLPartnerDeploymentInformation xmlPDI : xmlDeployment.getPartnerList()) {
            String name = xmlPDI.getName();
            Partner p = new Partner(name, SpecificationLoader.loadWsdlDefinition(testDirectory, xmlPDI.getWsdl(), name), SpecificationLoader.loadWsdlDefinition(testDirectory, xmlPDI.getPartnerWsdl(), name), suiteBaseURL.toString());
            suitePartners.put(p.getName(), p);
        }
    }

    public static Definition loadWsdlDefinition(String baseDir, String wsdlFileName, String partnerName) throws SpecificationException {
        if (wsdlFileName == null || wsdlFileName.equals("")) {
            return null;
        }
        return SpecificationLoader.loadWsdlDefinition(new File(baseDir, wsdlFileName).getPath(), partnerName);
    }

    public static Definition loadWsdlDefinition(String wsdlFileName, String partnerName) throws SpecificationException {
        if (!new File(wsdlFileName).exists()) {
            throw new SpecificationException("Cannot read WSDL file for partner " + partnerName + ": File \"" + wsdlFileName + "\" not found.");
        }
        try {
            WSDLFactory factory = WSDLFactory.newInstance();
            WSDLReader reader = factory.newWSDLReader();
            reader.setFeature("javax.wsdl.verbose", false);
            return reader.readWSDL(wsdlFileName);
        }
        catch (WSDLException e) {
            throw new SpecificationException("Error while reading WSDL for partner " + partnerName + " from file \"" + wsdlFileName + "\".", e);
        }
    }

    private ProcessUnderTest createProcessUnderTest(String testDirectory, URL suiteBaseURL, Map<String, Partner> suitePartners, XMLPUTDeploymentInformation xmlPut) throws SpecificationException {
        String xmlPutName = xmlPut.getName();
        String xmlPutWSDL = xmlPut.getWsdl();
        String xmlPutPartnerWSDL = xmlPut.getPartnerWSDL();
        String xmlPutType = xmlPut.getType();
        ProcessUnderTest processUnderTest = new ProcessUnderTest(xmlPutName, testDirectory, SpecificationLoader.loadWsdlDefinition(testDirectory, xmlPutWSDL, xmlPutName), SpecificationLoader.loadWsdlDefinition(testDirectory, xmlPutPartnerWSDL, xmlPutName), suiteBaseURL.toString());
        for (XMLProperty property : xmlPut.getPropertyList()) {
            processUnderTest.setXMLDeploymentOption(property.getName(), property.getStringValue());
        }
        IBPELDeployer suitePutDeployer = this.fRunner.createNewDeployer(xmlPutType);
        processUnderTest.setDeployer(suitePutDeployer);
        processUnderTest.setGlobalConfiguration(this.fRunner.getGlobalConfigurationForDeployer(suitePutDeployer));
        suitePartners.put(processUnderTest.getName(), processUnderTest);
        processUnderTest.setPartners(suitePartners);
        return processUnderTest;
    }

    private URL getBaseURL(XMLTestSuite xmlTestSuite) throws SpecificationException {
        try {
            String path;
            URL suiteBaseURL;
            int port;
            String xmlUrl = xmlTestSuite.getBaseURL();
            if (xmlUrl == null) {
                xmlUrl = "http://localhost:7777/ws/";
            }
            if ((port = (suiteBaseURL = new URL(xmlUrl)).getPort()) == -1) {
                port = 80;
            }
            if (!(path = suiteBaseURL.getPath()).endsWith("/")) {
                path = path + "/";
            }
            suiteBaseURL = new URL(suiteBaseURL.getProtocol(), suiteBaseURL.getHost(), port, path);
            return suiteBaseURL;
        }
        catch (MalformedURLException e) {
            throw new SpecificationException("Could not create a valid URL from specified base URL.", e);
        }
    }

    private int computeNumberOfRounds(XMLTestSuiteDocument xmlTestSuiteDocument, boolean isVary) throws SpecificationException {
        int rounds = 0;
        if (isVary) {
            XPath xpath = XPathFactory.newInstance().newXPath();
            NamespaceContextImpl nsContext = new NamespaceContextImpl();
            nsContext.setNamespace("ts", "http://www.bpelunit.org/schema/testSuite");
            xpath.setNamespaceContext(nsContext);
            try {
                NodeList set = (NodeList)xpath.evaluate("//@delaySequence", xmlTestSuiteDocument.getDomNode(), XPathConstants.NODESET);
                int currentMax = 0;
                for (int i = 0; i < set.getLength(); ++i) {
                    Attr attr;
                    List<Double> ints;
                    if (!(set.item(i) instanceof Attr) || (ints = this.getRoundInformation((attr = (Attr)set.item(i)).getValue())) == null) continue;
                    currentMax = ints.size();
                }
                rounds = currentMax;
            }
            catch (XPathExpressionException e) {
                throw new SpecificationException("There was a problem finding delay sequences. This most likely indicates a bug in the framework.", e);
            }
        }
        return rounds;
    }

    private void readTestSuiteSetUpBlock(TestSuite testSuite, XMLTestSuite xmlTestSuite) {
        if (!xmlTestSuite.isSetSetUp()) {
            return;
        }
        XMLSetUp xmlSetUp = xmlTestSuite.getSetUp();
        if (xmlSetUp.isSetScript()) {
            testSuite.setSetUpVelocityScript(xmlSetUp.getScript());
        }
    }

    private TestCase createTestCase(Map<String, Partner> suitePartners, Map<String, HumanPartner> suiteHumanPartners, Partner suiteClient, TestSuite suite, XMLTestCase xmlTestCase, String xmlTestCaseName, int round, String testDirectory) throws SpecificationException {
        TestCase test = new TestCase(suite, xmlTestCaseName);
        this.readMetaData(xmlTestCase, test);
        this.readTestCaseSetUpBlock(test, xmlTestCase);
        this.readClientTrack(suiteClient, xmlTestCase, round, testDirectory, test);
        this.readPartners(suitePartners, xmlTestCase, round, testDirectory, test);
        this.readHumanPartners(suiteHumanPartners, xmlTestCase, testDirectory, test);
        return test;
    }

    private void readHumanPartners(Map<String, HumanPartner> suiteHumanPartners, XMLTestCase xmlTestCase, String testDirectory, TestCase test) throws SpecificationException {
        List<XMLHumanPartnerTrack> humanPartnerTrackList = xmlTestCase.getHumanPartnerTrackList();
        if (humanPartnerTrackList != null) {
            for (XMLHumanPartnerTrack xmlHumanPartnerTrack : humanPartnerTrackList) {
                this.readHumanPartner(suiteHumanPartners, testDirectory, test, xmlHumanPartnerTrack);
            }
        }
    }

    private void readHumanPartner(Map<String, HumanPartner> suiteHumanPartners, String testDirectory, TestCase test, XMLHumanPartnerTrack xmlHumanPartnerTrack) throws SpecificationException {
        String xmlPartnerTrackName = xmlHumanPartnerTrack.getName();
        HumanPartner realPartner = suiteHumanPartners.get(xmlPartnerTrackName);
        PartnerTrack pTrack = new PartnerTrack(test, realPartner);
        this.readActivities(pTrack, xmlHumanPartnerTrack, testDirectory);
        pTrack.setNamespaceContext(this.getNamespaceMap(xmlHumanPartnerTrack.newCursor()));
        test.addPartnerTrack(pTrack);
    }

    private void readActivities(PartnerTrack pTrack, XMLHumanPartnerTrack xmlHumanPartnerTrack, String testDirectory) throws SpecificationException {
        if (xmlHumanPartnerTrack.getCompleteHumanTaskList() != null) {
            for (XMLCompleteHumanTaskActivity xmlActivity : xmlHumanPartnerTrack.getCompleteHumanTaskList()) {
                CompleteHumanTask activity = new CompleteHumanTask(pTrack);
                activity.setTaskName(xmlActivity.getTaskName());
                NamespaceContextImpl context = this.getNamespaceMap(xmlActivity.newCursor());
                CompleteHumanTaskSpecification spec = new CompleteHumanTaskSpecification(activity, context, (Element)this.getLiteralDataForSend(xmlActivity.getData(), testDirectory).getFirstChild(), pTrack);
                List<XMLCondition> xmlConditionList = xmlActivity.getConditionList();
                ArrayList<ReceiveCondition> cList = new ArrayList<ReceiveCondition>();
                if (xmlConditionList != null) {
                    for (XMLCondition xmlCondition : xmlConditionList) {
                        cList.add(new ReceiveCondition(spec, xmlCondition.getExpression(), xmlCondition.getTemplate(), xmlCondition.getValue()));
                    }
                }
                this.addConditionsFromConditionGroups(xmlActivity.getConditionGroupList(), spec, cList);
                spec.setConditions(cList);
                activity.initialize(spec);
                pTrack.addActivity(activity);
            }
        }
    }

    private void readPartners(Map<String, Partner> suitePartners, XMLTestCase xmlTestCase, int round, String testDirectory, TestCase test) throws SpecificationException {
        List<XMLPartnerTrack> partnerTrackList = xmlTestCase.getPartnerTrackList();
        if (partnerTrackList != null) {
            for (XMLPartnerTrack xmlPartnerTrack : partnerTrackList) {
                this.readPartner(suitePartners, xmlTestCase, round, testDirectory, test, xmlPartnerTrack);
            }
        }
    }

    private void readPartner(Map<String, Partner> suitePartners, XMLTestCase xmlTestCase, int round, String testDirectory, TestCase test, XMLPartnerTrack xmlPartnerTrack) throws SpecificationException {
        String xmlPartnerTrackName = xmlPartnerTrack.getName();
        Partner realPartner = suitePartners.get(xmlPartnerTrackName);
        PartnerTrack pTrack = new PartnerTrack(test, realPartner);
        this.readActivities(pTrack, xmlTestCase, xmlPartnerTrack, round, testDirectory);
        pTrack.setNamespaceContext(this.getNamespaceMap(xmlPartnerTrack.newCursor()));
        if (xmlPartnerTrack.isSetAssume()) {
            pTrack.setAssumption(xmlPartnerTrack.getAssume());
        }
        test.addPartnerTrack(pTrack);
    }

    private void readClientTrack(Partner suiteClient, XMLTestCase xmlTestCase, int round, String testDirectory, TestCase test) throws SpecificationException {
        XMLTrack xmlClientTrack = xmlTestCase.getClientTrack();
        PartnerTrack track = new PartnerTrack(test, suiteClient);
        this.readActivities(track, xmlTestCase, xmlClientTrack, round, testDirectory);
        track.setNamespaceContext(this.getNamespaceMap(xmlClientTrack.newCursor()));
        test.addPartnerTrack(track);
    }

    private void readMetaData(XMLTestCase xmlTestCase, TestCase test) {
        for (XMLProperty data : xmlTestCase.getPropertyList()) {
            String xmlPropertyName = data.getName();
            String xmlPropertyData = data.getStringValue();
            test.addProperty(xmlPropertyName, xmlPropertyData);
        }
    }

    private void readTestCaseSetUpBlock(TestCase test, XMLTestCase xmlTestCase) {
        if (!xmlTestCase.isSetSetUp()) {
            return;
        }
        XMLSetUp xmlSetUp = xmlTestCase.getSetUp();
        if (xmlSetUp.isSetScript()) {
            test.setSetUpVelocityScript(xmlSetUp.getScript());
        }
    }

    private void readActivities(PartnerTrack partnerTrack, XMLTestCase xmlTestCase, XMLTrack xmlTrack, int round, String testDirectory) throws SpecificationException {
        List<XMLActivity> xmlActivities = ActivityUtil.getActivities(xmlTrack);
        if (xmlActivities.isEmpty()) {
            if (xmlTestCase.getBasedOn() != null && !"".equals(xmlTestCase.getBasedOn())) {
                XMLTrack trackInNewTestCase;
                String trackName = null;
                trackName = this.getPartnerTrackName(xmlTrack);
                XMLTestCase basedOnTestCase = this.findInHierarchy(xmlTestCase, trackName);
                if (basedOnTestCase != null && (trackInNewTestCase = this.getPartnerTrack(basedOnTestCase, trackName)) != null) {
                    this.readActivities(partnerTrack, basedOnTestCase, trackInNewTestCase, round, testDirectory);
                    return;
                }
            }
            partnerTrack.setActivities(new ArrayList<Activity>());
        } else {
            ArrayList<Activity> activities = new ArrayList<Activity>();
            for (XMLActivity event : xmlActivities) {
                if (event instanceof XMLWaitActivity) {
                    this.readWait(partnerTrack, activities, event, (XMLWaitActivity)event);
                    continue;
                }
                if (event instanceof XMLReceiveActivity) {
                    this.readReceive(partnerTrack, activities, event, (XMLReceiveActivity)event);
                    continue;
                }
                if (event instanceof XMLSendActivity) {
                    this.readSend(partnerTrack, round, testDirectory, activities, event, (XMLSendActivity)event);
                    continue;
                }
                if (event instanceof XMLTwoWayActivity) {
                    XMLTwoWayActivity op = (XMLTwoWayActivity)event;
                    this.readTwoWayActivity(partnerTrack, round, testDirectory, activities, event, op);
                    continue;
                }
                throw new SpecificationException("No activity found when reading event list for " + partnerTrack);
            }
            partnerTrack.setActivities(activities);
        }
    }

    private void readTwoWayActivity(PartnerTrack partnerTrack, int round, String testDirectory, List<Activity> activities, XMLActivity event, XMLTwoWayActivity op) throws SpecificationException {
        Activity activity = null;
        if (ActivityUtil.isActivity(op, ActivityUtil.ActivityConstant.RECEIVE_SEND_SYNC)) {
            activity = this.createReceiveSendSynchronous(op, partnerTrack, round, testDirectory);
        } else if (ActivityUtil.isActivity(op, ActivityUtil.ActivityConstant.SEND_RECEIVE_SYNC)) {
            activity = this.createSendReceiveSynchronous(op, partnerTrack, round, testDirectory);
        } else if (ActivityUtil.isActivity(op, ActivityUtil.ActivityConstant.RECEIVE_SEND_ASYNC)) {
            ReceiveSendAsync a = new ReceiveSendAsync(partnerTrack);
            this.fillAsyncTwoWay(a, op, round, testDirectory);
            activity = a;
        } else if (ActivityUtil.isActivity(op, ActivityUtil.ActivityConstant.SEND_RECEIVE_ASYNC)) {
            SendReceiveAsync a = new SendReceiveAsync(partnerTrack);
            this.fillAsyncTwoWay(a, op, round, testDirectory);
            activity = a;
        }
        activity.setAssumption(event.getAssume());
        activities.add(activity);
    }

    private void readSend(PartnerTrack partnerTrack, int round, String testDirectory, List<Activity> activities, XMLActivity event, XMLSendActivity xmlSend) throws SpecificationException {
        SendAsync activity = new SendAsync(partnerTrack);
        SendDataSpecification spec = this.createSendSpecificationFromStandalone(activity, xmlSend, SOAPOperationDirectionIdentifier.INPUT, round, testDirectory);
        activity.initialize(spec);
        activity.setAssumption(event.getAssume());
        activities.add(activity);
    }

    private void readReceive(PartnerTrack partnerTrack, List<Activity> activities, XMLActivity event, XMLReceiveActivity xmlReceive) throws SpecificationException {
        ReceiveAsync activity = new ReceiveAsync(partnerTrack);
        ReceiveDataSpecification spec = this.createReceiveSpecificationStandalone(activity, xmlReceive, SOAPOperationDirectionIdentifier.INPUT);
        activity.initialize(spec);
        activity.setAssumption(event.getAssume());
        activities.add(activity);
    }

    private void readWait(PartnerTrack partnerTrack, List<Activity> activities, XMLActivity event, XMLWaitActivity xmlWait) {
        Wait activity = new Wait(partnerTrack);
        activity.setWaitDuration(xmlWait.getWaitForMilliseconds());
        activity.setAssumption(event.getAssume());
        activities.add(activity);
    }

    private String getPartnerTrackName(XMLTrack xmlTrack) {
        String trackName = xmlTrack instanceof XMLPartnerTrack ? ((XMLPartnerTrack)xmlTrack).getName() : "client";
        return trackName;
    }

    private Activity createSendReceiveSynchronous(XMLTwoWayActivity xmlSendReceiveSync, PartnerTrack partnerTrack, int round, String testDirectory) throws SpecificationException {
        SendReceiveSync activity = new SendReceiveSync(partnerTrack);
        XMLSendActivity xmlSend = xmlSendReceiveSync.getSend();
        XMLReceiveActivity xmlReceive = xmlSendReceiveSync.getReceive();
        if (xmlSend == null || xmlReceive == null) {
            throw new SpecificationException("A synchronous send/receive activity must have both receive and send children.");
        }
        XMLHeaderProcessor xmlHeaderProcessor = xmlSendReceiveSync.getHeaderProcessor();
        SendDataSpecification sSpec = this.createSendSpecificationFromParent(activity, xmlSendReceiveSync, xmlSend, SOAPOperationDirectionIdentifier.INPUT, round, testDirectory);
        SOAPOperationDirectionIdentifier receiveDirection = SOAPOperationDirectionIdentifier.OUTPUT;
        if (xmlReceive.getFault()) {
            receiveDirection = SOAPOperationDirectionIdentifier.FAULT;
        }
        ReceiveDataSpecification rSpec = this.createReceiveSpecificationFromParent(activity, xmlSendReceiveSync, xmlReceive, receiveDirection);
        IHeaderProcessor proc = this.getHeaderProcessor(xmlHeaderProcessor);
        List<DataCopyOperation> mapping = this.getCopyOperations(activity, xmlSendReceiveSync);
        activity.initialize(sSpec, rSpec, proc, mapping);
        return activity;
    }

    private Activity createReceiveSendSynchronous(XMLTwoWayActivity xmlReceiveSendSync, PartnerTrack partnerTrack, int round, String testDirectory) throws SpecificationException {
        ReceiveSendSync activity = new ReceiveSendSync(partnerTrack);
        activity.setAssumption(xmlReceiveSendSync.getAssume());
        XMLSendActivity xmlSend = xmlReceiveSendSync.getSend();
        XMLReceiveActivity xmlReceive = xmlReceiveSendSync.getReceive();
        if (xmlSend == null || xmlReceive == null) {
            throw new SpecificationException("A synchronous receive/send activity must have both receive and send children.");
        }
        XMLHeaderProcessor xmlHeaderProcessor = xmlReceiveSendSync.getHeaderProcessor();
        ReceiveDataSpecification rSpec = this.createReceiveSpecificationFromParent(activity, xmlReceiveSendSync, xmlReceive, SOAPOperationDirectionIdentifier.INPUT);
        SOAPOperationDirectionIdentifier sendDirection = SOAPOperationDirectionIdentifier.OUTPUT;
        if (xmlSend.getFault()) {
            sendDirection = SOAPOperationDirectionIdentifier.FAULT;
        }
        SendDataSpecification sSpec = this.createSendSpecificationFromParent(activity, xmlReceiveSendSync, xmlSend, sendDirection, round, testDirectory);
        IHeaderProcessor proc = this.getHeaderProcessor(xmlHeaderProcessor);
        List<DataCopyOperation> mapping = this.getCopyOperations(activity, xmlReceiveSendSync);
        activity.initialize(sSpec, rSpec, proc, mapping);
        return activity;
    }

    private void fillAsyncTwoWay(TwoWayAsyncActivity twoWayActivity, XMLTwoWayActivity xmlAsyncTwoWay, int round, String testDirectory) throws SpecificationException {
        XMLSendActivity xmlSend = xmlAsyncTwoWay.getSend();
        XMLReceiveActivity xmlReceive = xmlAsyncTwoWay.getReceive();
        if (xmlSend == null || xmlReceive == null) {
            throw new SpecificationException("An asynchronous receive/send or send/receive activity must have both receive and send children.");
        }
        XMLHeaderProcessor xmlHeaderProcessor = xmlAsyncTwoWay.getHeaderProcessor();
        List<DataCopyOperation> mapping = this.getCopyOperations(twoWayActivity, xmlAsyncTwoWay);
        SendAsync sendAct = new SendAsync(twoWayActivity);
        SendDataSpecification sSpec = this.createSendSpecificationFromStandalone(sendAct, xmlSend, SOAPOperationDirectionIdentifier.INPUT, round, testDirectory);
        sendAct.initialize(sSpec);
        ReceiveAsync receiveAct = new ReceiveAsync(twoWayActivity);
        ReceiveDataSpecification rSpec = this.createReceiveSpecificationStandalone(receiveAct, xmlReceive, SOAPOperationDirectionIdentifier.INPUT);
        receiveAct.initialize(rSpec);
        IHeaderProcessor proc = this.getHeaderProcessor(xmlHeaderProcessor);
        twoWayActivity.initialize(sendAct, receiveAct, proc, mapping);
    }

    private SendDataSpecification createSendSpecificationFromStandalone(Activity parentActivity, XMLSendActivity xmlSend, SOAPOperationDirectionIdentifier direction, int round, String testDirectory) throws SpecificationException {
        SOAPOperationCallIdentifier operation = this.getOperationCallIdentifier(parentActivity, this.getService(parentActivity, xmlSend), xmlSend.getPort(), xmlSend.getOperation(), direction);
        return this.createSendSpecification(parentActivity, operation, xmlSend, round, testDirectory);
    }

    private SendDataSpecification createSendSpecificationFromParent(Activity parentActivity, XMLTwoWayActivity xmlSendReceiveSync, XMLSendActivity xmlSend, SOAPOperationDirectionIdentifier direction, int round, String testDirectory) throws SpecificationException {
        SOAPOperationCallIdentifier operation = this.getOperationCallIdentifier(parentActivity, this.getService(parentActivity, xmlSendReceiveSync), xmlSendReceiveSync.getPort(), xmlSendReceiveSync.getOperation(), direction);
        return this.createSendSpecification(parentActivity, operation, xmlSend, round, testDirectory);
    }

    private SendDataSpecification createSendSpecification(Activity activity, SOAPOperationCallIdentifier operation, XMLSendActivity xmlSend, int round, String testDirectory) throws SpecificationException {
        String faultString;
        NamespaceContextImpl context = this.getNamespaceMap(xmlSend.newCursor());
        SendDataSpecification spec = new SendDataSpecification(activity, context);
        String encodingStyle = operation.getEncodingStyle();
        String targetURL = operation.getTargetURL();
        String soapAction = operation.getSOAPHTTPAction();
        ISOAPEncoder encoder = this.fRunner.createNewSOAPEncoder(encodingStyle);
        for (XMLProperty p : xmlSend.getTransportOptionList()) {
            spec.putProtocolOption(p.getName(), p.getStringValue());
        }
        if (xmlSend.isSetDelay() && xmlSend.isSetDelaySequence()) {
            throw new SpecificationException("Send Element can only have exactly one of {delay, delaySequence}, and not both");
        }
        String delayExpression = xmlSend.getDelay();
        Element rawDataRoot = null;
        String templateText = null;
        try {
            if (xmlSend.isSetData()) {
                rawDataRoot = this.getLiteralDataForSend(xmlSend.getData(), testDirectory);
            } else if (xmlSend.isSetTemplate()) {
                if (xmlSend.getTemplate().isSetSrc()) {
                    StringBuffer sbuf = new StringBuffer();
                    sbuf.append("<");
                    sbuf.append("literalData");
                    sbuf.append(">");
                    sbuf.append(FileUtils.readFileToString((File)new File(testDirectory, xmlSend.getTemplate().getSrc())));
                    sbuf.append("</");
                    sbuf.append("literalData");
                    sbuf.append(">");
                    templateText = sbuf.toString();
                } else {
                    Element templateRoot = this.copyAsRootWithNamespaces(xmlSend.getTemplate());
                    templateText = XmlObject.Factory.parse((Node)templateRoot).xmlText();
                }
            }
        }
        catch (Exception ex) {
            throw new SpecificationException("There was a problem while interpreting the 'src' attribute in activity " + activity, ex);
        }
        String delaySequence = xmlSend.getDelaySequence();
        List<Double> sequence = this.getRoundInformation(delaySequence);
        double currentDelay = 0.0;
        if (sequence != null && sequence.size() > round) {
            currentDelay = sequence.get(round);
        }
        QName faultCode = xmlSend.isSetFaultcode() ? xmlSend.getFaultcode() : BPELUnitConstants.SOAP_FAULT_CODE_CLIENT;
        String string = faultString = xmlSend.isSetFaultstring() ? xmlSend.getFaultstring() : "BPELUnit Framework Generated Fault";
        if (activity instanceof ReceiveSendSync) {
            spec.initialize(operation, currentDelay, delayExpression, null, null, encodingStyle, encoder, rawDataRoot, templateText, faultCode, faultString);
        } else {
            spec.initialize(operation, currentDelay, delayExpression, targetURL, soapAction, encodingStyle, encoder, rawDataRoot, templateText, faultCode, faultString);
        }
        return spec;
    }

    private Element getLiteralDataForSend(XMLAnyElement dataInSend, String testDirectory) throws SpecificationException {
        Element rawDataRoot;
        if (dataInSend.isSetSrc()) {
            String path = dataInSend.getSrc();
            try {
                rawDataRoot = this.copyAsRootWithNamespaces(XmlObject.Factory.parse((File)new File(testDirectory, path)));
            }
            catch (Exception e) {
                throw new SpecificationException("Error while importing data: " + e.getMessage(), e);
            }
        } else {
            rawDataRoot = this.copyAsRootWithNamespaces(dataInSend);
        }
        return rawDataRoot;
    }

    private Element copyAsRootWithNamespaces(XmlObject xmlData) throws SpecificationException {
        try {
            Element rawDataRoot = BPELUnitUtil.generateDummyElementNode();
            XmlObject test = XmlObject.Factory.parse((String)xmlData.xmlText());
            NodeList cn = test.getDomNode().getChildNodes();
            for (int i = 0; i < cn.getLength(); ++i) {
                Node currentItem = cn.item(i);
                if (!(currentItem instanceof Element)) continue;
                rawDataRoot.appendChild(rawDataRoot.getOwnerDocument().importNode(currentItem, true));
            }
            return rawDataRoot;
        }
        catch (XmlException e) {
            throw new SpecificationException("An error occurred when reading the literal data or template of send for an activity", e);
        }
    }

    private ReceiveDataSpecification createReceiveSpecificationStandalone(Activity parentActivity, XMLReceiveActivity xmlReceive, SOAPOperationDirectionIdentifier direction) throws SpecificationException {
        SOAPOperationCallIdentifier operation = this.getOperationCallIdentifier(parentActivity, this.getService(parentActivity, xmlReceive), xmlReceive.getPort(), xmlReceive.getOperation(), direction);
        return this.createReceiveSpecification(parentActivity, operation, xmlReceive);
    }

    private ReceiveDataSpecification createReceiveSpecificationFromParent(Activity parentActivity, XMLTwoWayActivity xmlReceiveSendSync, XMLReceiveActivity xmlReceive, SOAPOperationDirectionIdentifier direction) throws SpecificationException {
        SOAPOperationCallIdentifier operation = this.getOperationCallIdentifier(parentActivity, this.getService(parentActivity, xmlReceiveSendSync), xmlReceiveSendSync.getPort(), xmlReceiveSendSync.getOperation(), direction);
        return this.createReceiveSpecification(parentActivity, operation, xmlReceive);
    }

    private ReceiveDataSpecification createReceiveSpecification(Activity activity, SOAPOperationCallIdentifier operation, XMLReceiveActivity xmlReceive) throws SpecificationException {
        NamespaceContextImpl context = this.getNamespaceMap(xmlReceive.newCursor());
        ReceiveDataSpecification spec = new ReceiveDataSpecification(activity, context);
        String encodingStyle = operation.getEncodingStyle();
        ISOAPEncoder encoder = this.fRunner.createNewSOAPEncoder(encodingStyle);
        List<XMLCondition> xmlConditionList = xmlReceive.getConditionList();
        ArrayList<ReceiveCondition> cList = new ArrayList<ReceiveCondition>();
        if (xmlConditionList != null) {
            for (XMLCondition xmlCondition : xmlConditionList) {
                cList.add(new ReceiveCondition(spec, xmlCondition.getExpression(), xmlCondition.getTemplate(), xmlCondition.getValue()));
            }
        }
        this.addConditionsFromConditionGroups(xmlReceive.getConditionGroupList(), spec, cList);
        QName faultCode = xmlReceive.getFaultcode();
        String faultString = xmlReceive.getFaultstring();
        spec.initialize(operation, encodingStyle, encoder, cList, faultCode, faultString);
        return spec;
    }

    private void addConditionsFromConditionGroups(List<String> conditionGroupNames, DataSpecification spec, List<ReceiveCondition> cList) throws SpecificationException {
        if (conditionGroupNames != null) {
            for (String cgName : conditionGroupNames) {
                XMLConditionGroup cg = this.conditionGroups.get(cgName);
                this.addConditionsFromConditionGroup(spec, cList, cg);
            }
        }
    }

    private void addConditionsFromConditionGroup(DataSpecification spec, List<ReceiveCondition> cList, XMLConditionGroup cg) throws SpecificationException {
        List<XMLCondition> conditionList = this.resolveConditionsForGroup(cg);
        for (XMLCondition xmlCondition : conditionList) {
            cList.add(new ReceiveCondition(spec, xmlCondition.getExpression(), xmlCondition.getTemplate(), xmlCondition.getValue()));
        }
    }

    private List<XMLCondition> resolveConditionsForGroup(XMLConditionGroup cg) {
        List<XMLConditionGroup> cgs = this.getInheritanceBranch(cg);
        ArrayList<XMLCondition> conditions = new ArrayList<XMLCondition>();
        for (XMLConditionGroup currentCG : cgs) {
            if (currentCG.getConditionList() == null) continue;
            conditions.addAll(currentCG.getConditionList());
        }
        return conditions;
    }

    private List<XMLConditionGroup> getInheritanceBranch(XMLConditionGroup cg) {
        ArrayList<XMLConditionGroup> cgs = new ArrayList<XMLConditionGroup>();
        XMLConditionGroup currentCG = cg;
        cgs.add(currentCG);
        while (currentCG.getInheritFrom() != null) {
            currentCG = this.conditionGroups.get(currentCG.getInheritFrom());
            cgs.add(0, currentCG);
        }
        return cgs;
    }

    private List<DataCopyOperation> getCopyOperations(Activity activity, XMLTwoWayActivity xmlTwoWayType) throws SpecificationException {
        List<XMLCopy> xmlCopyList;
        ArrayList<DataCopyOperation> copyDataOperations = new ArrayList<DataCopyOperation>();
        XMLMapping xmlMapping = xmlTwoWayType.getMapping();
        if (xmlMapping != null && (xmlCopyList = xmlMapping.getCopyList()) != null) {
            for (XMLCopy xmlCopy : xmlCopyList) {
                String xmlCopyFrom = xmlCopy.getFrom();
                String xmlCopyTo = xmlCopy.getTo();
                if (xmlCopyFrom == null || xmlCopyTo == null) {
                    throw new SpecificationException("Copy operations need both copy-from and copy-to specifications.");
                }
                copyDataOperations.add(new DataCopyOperation(activity, xmlCopyFrom, xmlCopyTo));
            }
        }
        return copyDataOperations;
    }

    private IHeaderProcessor getHeaderProcessor(XMLHeaderProcessor xmlHeaderProcessor) throws SpecificationException {
        if (xmlHeaderProcessor == null) {
            return null;
        }
        String xmlHeaderProcessorName = xmlHeaderProcessor.getName();
        if (xmlHeaderProcessorName == null) {
            throw new SpecificationException("Header Processor needs a name.");
        }
        List<XMLProperty> propertyList = xmlHeaderProcessor.getPropertyList();
        IHeaderProcessor proc = this.fRunner.createNewHeaderProcessor(xmlHeaderProcessorName);
        if (propertyList != null) {
            for (XMLProperty property : propertyList) {
                String xmlPropertyName = property.getName();
                String xmlPropertyData = property.getStringValue();
                if (xmlPropertyName == null || xmlPropertyData == null) {
                    throw new SpecificationException("Properties in Header Processor " + xmlHeaderProcessorName + " need both property name and value.");
                }
                proc.setProperty(xmlPropertyName, xmlPropertyData);
            }
        }
        return proc;
    }

    private SOAPOperationCallIdentifier getOperationCallIdentifier(Activity activity, QName service, String port, String operation, SOAPOperationDirectionIdentifier direction) throws SpecificationException {
        Partner partner = (Partner)activity.getPartner();
        if (service == null) {
            throw new SpecificationException("Expected a service specification in activity " + activity.getName() + " (PartnerTrack for partner " + partner + ").");
        }
        if (port == null) {
            throw new SpecificationException("Expected a port specification in activity " + activity.getName() + " (PartnerTrack for partner " + partner + ").");
        }
        if (operation == null) {
            throw new SpecificationException("Expected a operation specification in activity " + activity.getName() + " (PartnerTrack for partner " + partner + ").");
        }
        return partner.getOperation(service, port, operation, direction);
    }

    private QName getService(Activity parentActivity, XMLSoapActivity xmlActivity) throws SpecificationException {
        QName service = null;
        try {
            service = xmlActivity.getService();
        }
        catch (Exception e) {
            // empty catch block
        }
        if (service == null) {
            throw new SpecificationException("Could not find service for activity " + parentActivity.getName() + ": not specified or wrong prefix.");
        }
        return service;
    }

    private NamespaceContextImpl getNamespaceMap(XmlCursor newCursor) {
        HashMap namespaces = new HashMap();
        newCursor.getAllNamespaces(namespaces);
        NamespaceContextImpl context = new NamespaceContextImpl();
        for (String prefix : namespaces.keySet()) {
            context.setNamespace(prefix, (String)namespaces.get(prefix));
        }
        return context;
    }

    private XMLTestCase findInHierarchy(XMLTestCase xmlTestCase, String partnerTrackName) {
        XmlCursor cursor = xmlTestCase.newCursor();
        String basedOn = xmlTestCase.getBasedOn();
        if (cursor.toParent()) {
            XMLTestCasesSection section = (XMLTestCasesSection)cursor.getObject();
            for (XMLTestCase xmlTestCaseFor : section.getTestCaseList()) {
                if (!basedOn.equals(xmlTestCaseFor.getName())) continue;
                if (this.hasNonEmptyPartnerTrack(xmlTestCaseFor, partnerTrackName)) {
                    return xmlTestCaseFor;
                }
                if (xmlTestCaseFor.getBasedOn() == null || "".equals(xmlTestCaseFor.getBasedOn())) continue;
                return this.findInHierarchy(xmlTestCaseFor, partnerTrackName);
            }
        }
        return null;
    }

    private boolean hasNonEmptyPartnerTrack(XMLTestCase xmlTestCase, String partnerTrackName) {
        XMLTrack track = this.getPartnerTrack(xmlTestCase, partnerTrackName);
        if (track != null) {
            return !ActivityUtil.getActivities(track).isEmpty();
        }
        return false;
    }

    private XMLTrack getPartnerTrack(XMLTestCase xmlTestCase, String trackName) {
        XMLTrack track = null;
        if (trackName.equalsIgnoreCase("client")) {
            track = xmlTestCase.getClientTrack();
        } else {
            for (XMLPartnerTrack pTrack : xmlTestCase.getPartnerTrackList()) {
                if (!trackName.equals(pTrack.getName())) continue;
                track = pTrack;
                break;
            }
        }
        return track;
    }

    private List<Double> getRoundInformation(String roundsAsText) {
        ArrayList<Double> list = new ArrayList<Double>();
        if (roundsAsText != null && !"".equals(roundsAsText)) {
            String[] values = roundsAsText.split(",");
            for (int j = 0; j < values.length; ++j) {
                try {
                    list.add(Double.parseDouble(values[j].trim()));
                    continue;
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }
            return list;
        }
        return null;
    }
}

