/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.framework;

import java.io.File;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import net.bpelunit.framework.SpecificationLoader;
import net.bpelunit.framework.control.ext.ExtensionRegistry;
import net.bpelunit.framework.control.ext.IBPELDeployer;
import net.bpelunit.framework.control.ext.IDataSource;
import net.bpelunit.framework.control.ext.IHeaderProcessor;
import net.bpelunit.framework.control.ext.ISOAPEncoder;
import net.bpelunit.framework.control.util.BPELUnitUtil;
import net.bpelunit.framework.coverage.ICoverageMeasurementTool;
import net.bpelunit.framework.exception.ConfigurationException;
import net.bpelunit.framework.exception.SpecificationException;
import net.bpelunit.framework.model.test.TestSuite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BPELUnitRunner {
    public static final String SKIP_UNKNOWN_EXTENSIONS = "SKIP_UNKNOWN_EXTENSIONS";
    public static final String GLOBAL_TIMEOUT = "GLOBAL_TIMEOUT";
    public static final String HALT_ON_ERROR = "HALT_ON_ERROR";
    public static final String HALT_ON_FAILURE = "HALT_ON_FAILURE";
    public static final String MEASURE_COVERAGE = "MEASURE_COVERAGE";
    public static final String CHANGE_ENDPOINTS = "CHANGE_ENDPOINTS";
    private static boolean fSkipUnknownExtensions = false;
    private static int fGlobalTimeout = 50000;
    private static boolean fHaltOnError = false;
    private static boolean fHaltOnFailure = false;
    private static boolean fMeasureCoverage = false;
    private static boolean fChangeEndpoints = false;
    private static ICoverageMeasurementTool coverageMeasurmentTool = null;
    private boolean fInitialized = false;

    public void initialize(Map<String, String> options) throws ConfigurationException {
        String changeEndpoints;
        this.fInitialized = false;
        fSkipUnknownExtensions = false;
        String skipUnknown = options.get(SKIP_UNKNOWN_EXTENSIONS);
        if (skipUnknown != null && skipUnknown.equalsIgnoreCase("true")) {
            fSkipUnknownExtensions = true;
        }
        fHaltOnError = false;
        String haltOnErr = options.get(HALT_ON_ERROR);
        if (haltOnErr != null && haltOnErr.equalsIgnoreCase("true")) {
            fHaltOnError = true;
        }
        fHaltOnFailure = false;
        String haltOnFail = options.get(HALT_ON_FAILURE);
        if (haltOnFail != null && haltOnFail.equalsIgnoreCase("true")) {
            fHaltOnFailure = true;
        }
        coverageMeasurmentTool = null;
        fMeasureCoverage = false;
        String measureCoverage = options.get(MEASURE_COVERAGE);
        if (measureCoverage != null && measureCoverage.equalsIgnoreCase("true")) {
            fMeasureCoverage = true;
        }
        if ((changeEndpoints = options.get(CHANGE_ENDPOINTS)) != null && changeEndpoints.equalsIgnoreCase("true")) {
            fChangeEndpoints = true;
        }
        fGlobalTimeout = 50000;
        String timeout = options.get(GLOBAL_TIMEOUT);
        if (timeout != null) {
            try {
                fGlobalTimeout = Integer.parseInt(timeout);
            }
            catch (NumberFormatException e) {
                throw new ConfigurationException("Global timeout value in options is not an integer: " + timeout, e);
            }
        }
        this.configureInit();
        this.configureLogging();
        this.initializeXMLParser();
        this.configureExtensions();
        this.configureDeployers();
        if (fMeasureCoverage) {
            this.configureCoverageTool();
        }
        this.fInitialized = true;
    }

    public abstract void configureInit() throws ConfigurationException;

    public abstract void configureLogging() throws ConfigurationException;

    public abstract void configureExtensions() throws ConfigurationException;

    public abstract void configureDeployers() throws ConfigurationException;

    public abstract void configureCoverageTool() throws ConfigurationException;

    public TestSuite loadTestSuite(File suiteFile) throws SpecificationException {
        if (!this.fInitialized) {
            throw new SpecificationException("BPELUnitCore was not properly initialized. Please call initialize() first.");
        }
        return new SpecificationLoader(this).loadTestSuite(suiteFile);
    }

    public abstract IBPELDeployer createNewDeployer(String var1) throws SpecificationException;

    public abstract IHeaderProcessor createNewHeaderProcessor(String var1) throws SpecificationException;

    public abstract ISOAPEncoder createNewSOAPEncoder(String var1) throws SpecificationException;

    public abstract IDataSource createNewDataSource(String var1) throws SpecificationException;

    public Map<String, String> getGlobalConfigurationForDeployer(IBPELDeployer deployer) {
        return ExtensionRegistry.getGlobalConfigurationForDeployer(deployer);
    }

    public static int getTimeout() {
        return fGlobalTimeout;
    }

    public static boolean isSkipUnknownExtensions() {
        return fSkipUnknownExtensions;
    }

    public static boolean isHaltOnError() {
        return fHaltOnError;
    }

    public static boolean isHaltOnFailure() {
        return fHaltOnFailure;
    }

    public static boolean measureTestCoverage() {
        return fMeasureCoverage;
    }

    public static boolean changeEndpoints() {
        return fChangeEndpoints;
    }

    public static void setCoverageMeasurmentTool(ICoverageMeasurementTool tool) {
        coverageMeasurmentTool = tool;
    }

    public static ICoverageMeasurementTool getCoverageMeasurmentTool() {
        return coverageMeasurmentTool;
    }

    private void initializeXMLParser() throws ConfigurationException {
        try {
            BPELUnitUtil.initializeParsing();
        }
        catch (ParserConfigurationException e) {
            throw new ConfigurationException("Could not initialize XML Parser Component.", e);
        }
    }
}

