/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.framework.control.datasource.ods;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import net.bpelunit.framework.control.ext.IDataSource;
import net.bpelunit.framework.exception.DataSourceException;
import org.apache.commons.lang.StringUtils;
import org.odftoolkit.odfdom.doc.OdfDocument;
import org.odftoolkit.odfdom.doc.OdfSpreadsheetDocument;
import org.odftoolkit.odfdom.doc.table.OdfTable;
import org.odftoolkit.odfdom.doc.table.OdfTableRow;

@IDataSource.DataSource(name="ODS Data Source", shortName="ods", contentTypes={"application/vnd.oasis.opendocument.spreadsheet", "application/x-vnd.oasis.opendocument.spreadsheet"})
public class OdsDataSource
implements IDataSource {
    private static final int DEFAULT_SHEET_INDEX = 0;
    private static final int MAX_CELL_SEARCH_DEPTH = 10;
    private OdfTable table;
    private int headingRowIndex;
    private List<String> headings;
    private int sheetIndex;
    private int firstCellIndex;
    private int currentRowIndex;
    private OdfTableRow currentRow;
    private int lastRow;

    public OdsDataSource() {
        this.currentRowIndex = this.headingRowIndex;
    }

    @IDataSource.ConfigurationOption(defaultValue="0", description="The number of the sheet in which the test data reside. Counting starts with 1 for the first sheet.")
    public void setSheet(String index) {
        this.checkIfMayAlterConfiguration();
        try {
            int currentSheetIndex = Integer.parseInt(index) - 1;
            if (currentSheetIndex < 0) {
                throw new IllegalArgumentException("Sheet Index must be a positive number but was " + currentSheetIndex);
            }
            this.sheetIndex = currentSheetIndex;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Sheet Index must be a positive number", e);
        }
    }

    public void close() {
    }

    public String[] getFieldNames() {
        return this.headings.toArray(new String[this.headings.size()]);
    }

    public String getValueFor(String fieldName) {
        int cellIndex = this.headings.indexOf(fieldName);
        return this.currentRow.getCellByIndex(cellIndex += this.firstCellIndex).getStringValue();
    }

    public void setRow(int index) throws DataSourceException {
        if (index >= this.getNumberOfRows()) {
            throw new DataSourceException(String.format("Index %d out of bounds [0, %d]", index, this.lastRow - 1));
        }
        this.currentRowIndex = this.headingRowIndex + 1 + index;
        this.currentRow = this.table.getRowByIndex(this.currentRowIndex);
    }

    public void loadFromStream(InputStream data) throws DataSourceException {
        OdfDocument ods;
        try {
            ods = OdfSpreadsheetDocument.loadDocument((InputStream)data);
        }
        catch (Exception e) {
            throw new DataSourceException("Error while reading the ODS data source", (Throwable)e);
        }
        this.table = (OdfTable)ods.getTableList().get(this.sheetIndex);
        this.extractFieldNames();
        this.calculateRowCount();
    }

    private void calculateRowCount() {
        this.lastRow = this.headingRowIndex;
        while (this.isDataRow(this.lastRow + 1)) {
            ++this.lastRow;
        }
    }

    private boolean isDataRow(int lastRow) {
        return !StringUtils.isEmpty((String)this.table.getCellByPosition(this.firstCellIndex, lastRow).getStringValue());
    }

    private void extractFieldNames() throws DataSourceException {
        this.headings = new ArrayList<String>();
        OdfTableRow headingRow = this.table.getRowByIndex(this.headingRowIndex);
        this.findFirstCellIndex(headingRow);
        if (this.firstCellIndex < 0) {
            throw new DataSourceException("No headings found at row " + this.headingRowIndex);
        }
        int i = this.firstCellIndex;
        do {
            String heading = headingRow.getCellByIndex(i).getStringValue();
            this.headings.add(heading);
        } while (!StringUtils.isEmpty((String)headingRow.getCellByIndex(++i).getStringValue()));
        this.currentRowIndex = this.headingRowIndex;
    }

    private void findFirstCellIndex(OdfTableRow headingRow) {
        this.firstCellIndex = 0;
        while (StringUtils.isEmpty((String)headingRow.getCellByIndex(this.firstCellIndex).getStringValue())) {
            if (this.firstCellIndex > 10) {
                this.firstCellIndex = -1;
                return;
            }
            ++this.firstCellIndex;
        }
    }

    private void checkIfMayAlterConfiguration() {
        if (this.table != null) {
            throw new IllegalStateException("Data has already been loaded; must not alter settings anymore!");
        }
    }

    public int getNumberOfRows() {
        return this.lastRow - this.headingRowIndex;
    }
}

