/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.model.bpel._2_0;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.bpelunit.model.bpel.IActivity;
import net.bpelunit.model.bpel.IBpelObject;
import net.bpelunit.model.bpel.IMultiContainer;
import net.bpelunit.model.bpel._2_0.AbstractActivity;
import net.bpelunit.model.bpel._2_0.BpelFactory;
import org.oasis_open.docs.wsbpel._2_0.process.executable.TActivity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractMultiContainer<T extends TActivity>
extends AbstractActivity<T>
implements IMultiContainer {
    private List<AbstractActivity<?>> wrappedActivities = new ArrayList();
    private List<Object> activities = new ArrayList<Object>();

    AbstractMultiContainer(T wrappedActivity, List<Object> children, BpelFactory f) {
        super(wrappedActivity, f);
        this.activities = children;
        for (Object child : children) {
            this.wrappedActivities.add(this.getFactory().createActivity(child));
        }
    }

    public List<AbstractActivity<?>> getActivities() {
        return Collections.unmodifiableList(this.wrappedActivities);
    }

    @Override
    public void addActivity(IActivity a) {
        AbstractActivity<?> activity = this.checkForCorrectModel(a);
        this.wrappedActivities.add(activity);
        this.activities.add(activity.getNativeActivity());
    }

    @Override
    public void removeActivity(IActivity a) {
        AbstractActivity<?> activity = this.checkForCorrectModel(a);
        int i = this.activities.indexOf(activity.getNativeActivity());
        this.wrappedActivities.remove(i);
        this.activities.remove(i);
    }

    @Override
    public boolean isBasicActivity() {
        return false;
    }

    @Override
    IBpelObject getObjectForNativeObject(Object nativeObject) {
        IBpelObject o = super.getObjectForNativeObject(nativeObject);
        if (o != null) {
            return o;
        }
        for (AbstractActivity<?> child : this.wrappedActivities) {
            o = child.getObjectForNativeObject(nativeObject);
            if (o == null) continue;
            return o;
        }
        return null;
    }
}

