/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.framework.ui.command;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.bpelunit.framework.BPELUnitRunner;
import net.bpelunit.framework.base.BPELUnitBaseRunner;
import net.bpelunit.framework.control.result.XMLResultProducer;
import net.bpelunit.framework.control.util.BPELUnitConstants;
import net.bpelunit.framework.control.util.BPELUnitUtil;
import net.bpelunit.framework.coverage.ICoverageMeasurementTool;
import net.bpelunit.framework.coverage.result.XMLCoverageResultProducer;
import net.bpelunit.framework.exception.ConfigurationException;
import net.bpelunit.framework.exception.DeploymentException;
import net.bpelunit.framework.exception.SpecificationException;
import net.bpelunit.framework.exception.TestCaseNotFoundException;
import net.bpelunit.framework.model.test.ITestResultListener;
import net.bpelunit.framework.model.test.PartnerTrack;
import net.bpelunit.framework.model.test.TestCase;
import net.bpelunit.framework.model.test.TestSuite;
import net.bpelunit.framework.model.test.data.XMLData;
import net.bpelunit.framework.model.test.report.ITestArtefact;
import net.bpelunit.framework.ui.command.Messages;
import net.bpelunit.framework.util.Console;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Appender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.varia.NullAppender;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BPELUnitCommandLineRunner
extends BPELUnitBaseRunner
implements ITestResultListener {
    private static final String PARAMETER_DETAILEDCOVERAGEFILE = "d";
    private static final String PARAMETER_COVERAGEFILE = "c";
    private static final String PARAMETER_LOGFILE = "l";
    private static final String PARAMETER_XMLFILE = "x";
    private static final String PARAMETER_VERBOSE = "v";
    private static final int MAX_LINE_LENGTH = 800;
    private final Logger logger = Logger.getLogger(((Object)((Object)this)).getClass());
    private Console console;
    private boolean saveCoverageDetails = false;
    private boolean verbose;
    private String xmlFileName;
    private String logFileName;
    private String covFileName;
    private PrintWriter screen;
    private File testSuiteFile;
    private List<String> testCaseNames;
    private Options options;

    public BPELUnitCommandLineRunner(String[] args) {
        this(new Console(), args);
    }

    public BPELUnitCommandLineRunner(Console consoleToUse, String[] args) {
        this.console = consoleToUse;
        this.screen = this.console.getScreen();
        this.createOptions();
        this.parseOptionsFromCommandLine(args);
    }

    private final void createOptions() {
        this.options = new Options();
        this.options.addOption(PARAMETER_VERBOSE, false, Messages.getString("BPELUnitCommandLineRunner.PARAMTER_DESCRIPTION_VERBOSE"));
        OptionBuilder.withDescription((String)Messages.getString("BPELUnitCommandLineRunner.PARAMETER_DESCRIPTION_XMLFILE"));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"FILE");
        this.options.addOption(OptionBuilder.create((String)PARAMETER_XMLFILE));
        OptionBuilder.withDescription((String)Messages.getString("BPELUnitCommandLineRunner.PARAMETER_DESCRIPTION_LOGFILE"));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"FILE");
        this.options.addOption(OptionBuilder.create((String)PARAMETER_LOGFILE));
        OptionBuilder.withDescription((String)Messages.getString("BPELUnitCommandLineRunner.PARAMETER_DESCRIPTION_COVERAGEFILE"));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"FILE");
        this.options.addOption(OptionBuilder.create((String)PARAMETER_COVERAGEFILE));
        OptionBuilder.withDescription((String)Messages.getString("BPELUnitCommandLineRunner.PARAMTER_DESCRIPTION_DETAILEDCOVERAGEFILE"));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"FILE");
        this.options.addOption(OptionBuilder.create((String)PARAMETER_DETAILEDCOVERAGEFILE));
    }

    private final void parseOptionsFromCommandLine(String[] args) {
        this.saveCoverageDetails = false;
        PosixParser parser = new PosixParser();
        try {
            CommandLine cmd = parser.parse(this.options, args);
            this.verifyCommandLineArguments(cmd);
            this.verbose = cmd.hasOption(PARAMETER_VERBOSE);
            this.xmlFileName = this.trimEqualsSignFromStart(cmd.getOptionValue(PARAMETER_XMLFILE));
            this.logFileName = this.trimEqualsSignFromStart(cmd.getOptionValue(PARAMETER_LOGFILE));
            if (cmd.hasOption(PARAMETER_COVERAGEFILE)) {
                this.covFileName = this.trimEqualsSignFromStart(cmd.getOptionValue(PARAMETER_COVERAGEFILE));
            }
            if (cmd.hasOption(PARAMETER_DETAILEDCOVERAGEFILE)) {
                this.covFileName = this.trimEqualsSignFromStart(cmd.getOptionValue(PARAMETER_DETAILEDCOVERAGEFILE));
                this.saveCoverageDetails = true;
            }
            ArrayList<String> remainingOptions = new ArrayList<String>(cmd.getArgList());
            this.setAndValidateTestSuiteFileName((String)remainingOptions.remove(0));
            this.testCaseNames = remainingOptions;
        }
        catch (ParseException e) {
            this.showHelpAndExit();
        }
    }

    private void setAndValidateTestSuiteFileName(String testSuiteFileName) {
        this.testSuiteFile = new File(testSuiteFileName);
        if (!this.testSuiteFile.exists()) {
            this.abort(String.format(Messages.getString("BPELUnitCommandLineRunner.MSG_ERR_TESTSUITE_FILE_NOT_EXISTING"), this.testSuiteFile));
        }
    }

    private String trimEqualsSignFromStart(String optionValue) {
        if (optionValue == null) {
            return null;
        }
        if (!optionValue.startsWith("=")) {
            return optionValue;
        }
        return optionValue.substring(1);
    }

    private void verifyCommandLineArguments(CommandLine cmd) {
        if (cmd.hasOption(PARAMETER_COVERAGEFILE) && cmd.hasOption(PARAMETER_DETAILEDCOVERAGEFILE)) {
            this.abort(String.format(Messages.getString("BPELUnitCommandLineRunner.MSG_ERR_PARAMETER_COVERAGE_DETAILEDCOVERAGE_ARE_EXCLUSIVE"), PARAMETER_COVERAGEFILE, PARAMETER_DETAILEDCOVERAGEFILE));
        }
        if (cmd.getArgList().size() == 0) {
            this.showHelpAndExit();
        }
    }

    public static void main(String[] args) {
        new BPELUnitCommandLineRunner(args).run();
    }

    private void abort(String message) {
        this.abort(message, null);
    }

    private void abort(String message, Exception e) {
        this.screen.println(message);
        if (e != null) {
            this.screen.println(Messages.getString("BPELUnitCommandLineRunner.MESSAGE_DESCRIPTION") + e.getMessage());
            this.logger.error((Object)Messages.getString("BPELUnitCommandLineRunner.MSG_ERROR_CANNOT_WRITE_COVERAGE_INFORMATION"), (Throwable)e);
        }
        this.console.exit(1);
    }

    private void showHelpAndExit() {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp(Messages.getString("BPELUnitCommandLineRunner.MSG_HELP_USAGE"), this.options);
        this.console.exit(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void run() {
        String bpelUnitRunner = Messages.getString("BPELUnitCommandLineRunner.MSG_TITLE_BPELUNIT_COMMANDLINE_RUNNER");
        this.screen.println(bpelUnitRunner);
        this.screen.println(StringUtils.repeat((String)"-", (int)bpelUnitRunner.length()));
        try {
            HashMap<String, String> options;
            if (this.covFileName != null) {
                options = new HashMap<String, String>();
                options.put("MEASURE_COVERAGE", Boolean.TRUE.toString());
            } else {
                options = BPELUnitConstants.NULL_OPTIONS;
            }
            this.initialize(options);
            this.screen.println(Messages.getString("BPELUnitCommandLineRunner.MSG_PROGRESS_LOADING_TESTSUITE"));
            TestSuite suite = this.loadTestSuite(this.testSuiteFile);
            for (String testCaseName : this.testCaseNames) {
                if (suite.hasTestCase(testCaseName)) continue;
                this.abort(String.format(Messages.getString("BPELUnitCommandLineRunner.MSG_ERROR_UNKNOWN_TESTCASE"), testCaseName));
            }
            this.screen.println(Messages.getString("BPELUnitCommandLineRunner.MSG_PROGRESS_TESTSUITE_LOADED"));
            this.screen.println(Messages.getString("BPELUnitCommandLineRunner.MSG_PROGRESS_DEPLOYING_SERVICES"));
            try {
                suite.setUp();
            }
            catch (DeploymentException e) {
                try {
                    suite.shutDown();
                }
                catch (DeploymentException e1) {
                    // empty catch block
                }
                this.abort(Messages.getString("BPELUnitCommandLineRunner.MSG_ERROR_DEPLOYMENT_ERROR"), (Exception)((Object)e));
            }
            this.screen.println(Messages.getString("BPELUnitCommandLineRunner.MSG_PROGRESS_DEPLOYMENT_DONE"));
            this.screen.println(Messages.getString("BPELUnitCommandLineRunner.MSG_PROGRESS_RUNNING_TEST_CASES"));
            suite.addResultListener((ITestResultListener)this);
            if (this.testCaseNames.size() > 0) {
                try {
                    suite.setFilter(this.testCaseNames);
                }
                catch (TestCaseNotFoundException e1) {
                    // empty catch block
                }
            }
            suite.run();
            suite.removeResultListener((ITestResultListener)this);
            this.screen.println(Messages.getString("BPELUnitCommandLineRunner.MSG_PROGRESS_TESTCASES_FINISHED"));
            if (this.xmlFileName != null) {
                try {
                    XMLResultProducer.writeXML((OutputStream)new FileOutputStream(this.xmlFileName), (TestSuite)suite);
                }
                catch (Exception e) {
                    this.abort(String.format(Messages.getString("BPELUnitCommandLineRunner.MSG_ERROR_ERROR_WRITING_XML_FILE"), this.xmlFileName), e);
                }
            }
            this.screen.println(Messages.getString("BPELUnitCommandLineRunner.MSG_PROGRESS_UNDEPLOY"));
            try {
                suite.shutDown();
            }
            catch (DeploymentException e) {
                this.abort(Messages.getString("BPELUnitCommandLineRunner.MSG_ERROR_UNDEPLOY"), (Exception)((Object)e));
            }
            if (this.covFileName != null) {
                try {
                    ICoverageMeasurementTool tool = BPELUnitRunner.getCoverageMeasurmentTool();
                    if (tool != null) {
                        XMLCoverageResultProducer.writeResult((OutputStream)new FileOutputStream(this.covFileName), (List)tool.getStatistics(), (String)tool.getErrorStatus(), (boolean)this.saveCoverageDetails);
                    }
                }
                catch (IOException e) {
                    this.abort(String.format(Messages.getString("BPELUnitCommandLineRunner.MSG_ERROR_COVERAGEFILE"), this.covFileName), e);
                }
            }
            this.screen.println(Messages.getString("BPELUnitCommandLineRunner.MSG_PROGRESS_UNDEPLOYED"));
            this.screen.println(Messages.getString("BPELUnitCommandLineRunner.MSG_BYE"));
        }
        catch (ConfigurationException e) {
            this.abort(Messages.getString("BPELUnitCommandLineRunner.MSG_ERROR_COFIGURATION_ERROR"), (Exception)((Object)e));
        }
        catch (SpecificationException e) {
            this.abort(Messages.getString("BPELUnitCommandLineRunner.MSG_ERROR_BPTS_ERROR"), (Exception)((Object)e));
        }
        finally {
            BPELUnitRunner.setCoverageMeasurmentTool(null);
        }
    }

    public void testCaseEnded(TestCase test) {
        String status = "ended";
        String error = null;
        if (test.getStatus().isError()) {
            status = "had an error";
            error = test.getStatus().getMessage();
        }
        if (test.getStatus().isFailure()) {
            status = "failed";
            error = test.getStatus().getMessage();
        }
        if (test.getStatus().isAborted()) {
            status = "was aborted";
        }
        if (test.getStatus().isPassed()) {
            status = "passed";
        }
        this.screen.println("Test Case " + status + ": " + test.getName() + "." + (error != null ? error : ""));
    }

    public void testCaseStarted(TestCase test) {
        if (this.verbose) {
            this.screen.println(Messages.getString("BPELUnitCommandLineRunner.MSG_PROGRESS_TESTCASE_STARTED") + test.getName() + ".\n");
        }
    }

    public void progress(ITestArtefact test) {
        if (this.verbose && test instanceof PartnerTrack) {
            this.screen.println(this.createReadableOutput(test, false));
        }
    }

    private String createReadableOutput(ITestArtefact artefact, boolean recursive) {
        return this.createReadableOutputInternal(artefact, recursive, "");
    }

    private String createReadableOutputInternal(ITestArtefact artefact, boolean recursive, String inline) {
        StringBuffer output = new StringBuffer();
        output.append(inline + "<Artefact \"" + artefact.getName() + "\">\n");
        String internalInline = inline + "  ";
        output.append(internalInline + "Status: " + artefact.getStatus().toString() + "\n");
        if (recursive) {
            for (ITestArtefact child : artefact.getChildren()) {
                if (artefact instanceof XMLData) {
                    XMLData sd = (XMLData)artefact;
                    output.append(internalInline + sd.getName() + " : " + StringUtils.abbreviate((String)BPELUnitUtil.removeSpaceLineBreaks((String)sd.getXmlData()), (int)800) + "\n");
                    continue;
                }
                output.append(this.createReadableOutputInternal(child, recursive, internalInline));
            }
        }
        output.append(inline + "</Artefact \"" + artefact.getName() + "\">\n");
        return output.toString();
    }

    public void configureLogging() throws ConfigurationException {
        Logger.getRootLogger().removeAllAppenders();
        if (this.logFileName != null) {
            try {
                Logger.getRootLogger().addAppender((Appender)new FileAppender((Layout)new PatternLayout(), this.logFileName));
            }
            catch (IOException e) {
                this.screen.println(Messages.getString("BPELUnitCommandLineRunner.MSG_ERROR_LOGFILE"));
            }
            Logger.getRootLogger().setLevel(Level.INFO);
        } else {
            Logger.getRootLogger().addAppender((Appender)new NullAppender());
        }
    }

    boolean getCoverageDetails() {
        return this.saveCoverageDetails;
    }

    File getTestSuiteFile() {
        return this.testSuiteFile;
    }

    List<String> getTestCaseNames() {
        return new ArrayList<String>(this.testCaseNames);
    }

    boolean isSaveCoverageDetails() {
        return this.saveCoverageDetails;
    }

    boolean isVerbose() {
        return this.verbose;
    }

    String getXmlFileName() {
        return this.xmlFileName;
    }

    String getLogFileName() {
        return this.logFileName;
    }

    String getCovFileName() {
        return this.covFileName;
    }
}

