/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.framework.verify;

import java.util.HashSet;
import net.bpelunit.framework.exception.SpecificationException;
import net.bpelunit.framework.verify.ITestSuiteValidator;
import net.bpelunit.framework.xml.suite.XMLDeploymentSection;
import net.bpelunit.framework.xml.suite.XMLHumanPartnerDeploymentInformation;
import net.bpelunit.framework.xml.suite.XMLPartnerDeploymentInformation;
import net.bpelunit.framework.xml.suite.XMLTestSuiteDocument;

public class PartnersHaveUniqueNamesValidator
implements ITestSuiteValidator {
    public void validate(XMLTestSuiteDocument suite) throws SpecificationException {
        String name;
        HashSet<String> partnerNames = new HashSet<String>();
        XMLDeploymentSection deployment = suite.getTestSuite().getDeployment();
        for (XMLPartnerDeploymentInformation xMLPartnerDeploymentInformation : deployment.getPartnerList()) {
            name = xMLPartnerDeploymentInformation.getName();
            if (partnerNames.contains(name)) {
                throw new SpecificationException("There are at least two partners with the name <" + name + ">. There must be only one.");
            }
            partnerNames.add(name);
        }
        for (XMLHumanPartnerDeploymentInformation xMLHumanPartnerDeploymentInformation : deployment.getHumanPartnerList()) {
            name = xMLHumanPartnerDeploymentInformation.getName();
            if (partnerNames.contains(name)) {
                throw new SpecificationException("There are at least two partners with the name <" + name + ">. There must be only one.");
            }
            partnerNames.add(name);
        }
    }
}

