/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.framework.ui.ant;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import net.bpelunit.framework.base.BPELUnitBaseRunner;
import net.bpelunit.framework.control.result.ITestResultListener;
import net.bpelunit.framework.control.result.XMLResultProducer;
import net.bpelunit.framework.exception.ConfigurationException;
import net.bpelunit.framework.exception.DeploymentException;
import net.bpelunit.framework.exception.SpecificationException;
import net.bpelunit.framework.model.test.PartnerTrack;
import net.bpelunit.framework.model.test.TestCase;
import net.bpelunit.framework.model.test.TestSuite;
import net.bpelunit.framework.model.test.report.ITestArtefact;
import net.bpelunit.framework.ui.ant.BPELUnit;
import org.apache.log4j.Appender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.WriterAppender;
import org.apache.log4j.varia.NullAppender;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BPELUnitAntRunner
extends BPELUnitBaseRunner
implements ITestResultListener {
    private String fBPELUnitHomeDirectory;
    private List<BPELUnit.Logging> fLoggers;
    private List<BPELUnit.Output> fOutputs;
    private int fFailures;
    private int fErrors;
    private int fRuns;

    public BPELUnitAntRunner(String homedir, List<BPELUnit.Logging> loggers, List<BPELUnit.Output> outputList) {
        this.fBPELUnitHomeDirectory = homedir;
        this.fLoggers = loggers;
        this.fOutputs = outputList;
        this.fFailures = 0;
        this.fErrors = 0;
        this.fRuns = 0;
    }

    public void configureInit() throws ConfigurationException {
        this.setHomeDirectory(this.fBPELUnitHomeDirectory);
        for (BPELUnit.Output output : this.fOutputs) {
            output.initialize();
        }
    }

    public void configureLogging() throws ConfigurationException {
        Logger.getRootLogger().removeAllAppenders();
        for (BPELUnit.Logging log : this.fLoggers) {
            log.initialize();
            Logger.getRootLogger().addAppender((Appender)new WriterAppender((Layout)new PatternLayout("%r [%t] %p %c %x - %m%n"), log.getOutputStream()));
            Logger.getRootLogger().setLevel(Level.toLevel((String)log.getLevel()));
        }
        if (this.fLoggers.isEmpty()) {
            Logger.getRootLogger().addAppender((Appender)new NullAppender());
        }
    }

    public void run(File testSuite) throws SpecificationException, DeploymentException, ConfigurationException {
        TestSuite suite = this.loadTestSuite(testSuite);
        suite.addResultListener((ITestResultListener)this);
        try {
            suite.setUp();
        }
        catch (DeploymentException e) {
            try {
                suite.shutDown();
            }
            catch (DeploymentException e2) {
                // empty catch block
            }
            throw e;
        }
        this.outputPlain("START", (ITestArtefact)suite);
        suite.run();
        suite.removeResultListener((ITestResultListener)this);
        this.outputPlain("END", (ITestArtefact)suite);
        String result = "Test Run Completed. " + this.fRuns + " " + this.getPluralOf(this.fRuns, "run") + " (" + this.fFailures + " " + this.getPluralOf(this.fFailures, "failure") + ", " + this.fErrors + " " + this.getPluralOf(this.fErrors, "error") + ") \n";
        this.outputPlain(result);
        System.out.println(result);
        this.outputXML(suite);
        this.closeOutputs();
        suite.shutDown();
    }

    public void testCaseStarted(TestCase testCase) {
        this.outputPlain("START", (ITestArtefact)testCase);
    }

    public void testCaseEnded(TestCase testCase) {
        if (testCase.getStatus().isFailure()) {
            ++this.fFailures;
        }
        if (testCase.getStatus().isError()) {
            ++this.fErrors;
        }
        ++this.fRuns;
        this.outputPlain("END", (ITestArtefact)testCase);
    }

    public void progress(ITestArtefact testArtefact) {
        if (testArtefact instanceof PartnerTrack) {
            this.outputPlain("PROGRESS", testArtefact);
        }
    }

    private void outputPlain(String head, ITestArtefact testCase) {
        String info = head + ": " + testCase.getName() + ": " + testCase.getStatus().toString() + "\n";
        this.outputPlain(info);
    }

    private void outputPlain(String info) {
        Iterator<BPELUnit.Output> i = this.fOutputs.iterator();
        while (i.hasNext()) {
            BPELUnit.Output output = i.next();
            try {
                if (!output.getStyle().equals("PLAIN")) continue;
                output.write(info);
            }
            catch (IOException e) {
                System.out.println("I/O Error writing to output stream - canceling output.");
                output.dispose();
                i.remove();
            }
        }
    }

    private void outputXML(TestSuite suite) {
        Iterator<BPELUnit.Output> i = this.fOutputs.iterator();
        while (i.hasNext()) {
            BPELUnit.Output output = i.next();
            try {
                if (!output.getStyle().equals("XML")) continue;
                XMLResultProducer.writeXML((OutputStream)output.getOutput(), (TestSuite)suite);
            }
            catch (IOException e) {
                System.out.println("I/O Error writing to output stream - canceling output.");
                output.dispose();
                i.remove();
            }
        }
    }

    private String getPluralOf(int no, String name) {
        return no == 1 ? name : name + "s";
    }

    private void closeOutputs() {
        for (BPELUnit.Logging l : this.fLoggers) {
            l.dispose();
        }
        for (BPELUnit.Output o : this.fOutputs) {
            o.dispose();
        }
    }

    public void configureCoverageTool() throws ConfigurationException {
    }
}

