/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.test.unit;

import javax.xml.namespace.NamespaceContext;
import net.bpelunit.framework.control.soap.NamespaceContextImpl;
import net.bpelunit.framework.model.test.data.DataCopyOperation;
import net.bpelunit.test.unit.SimpleTest;
import net.bpelunit.test.util.TestUtil;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class TestDataCopy
extends SimpleTest {
    private static final String PATH_TO_FILES = "/dataCopy/";

    private DataCopyOperation getCopyFrom(String string) {
        return new DataCopyOperation(null, string, "");
    }

    private DataCopyOperation getCopyTo(String string) {
        return new DataCopyOperation(null, "", string);
    }

    @Test
    public void testSimpleGet() throws Exception {
        Element parent = TestUtil.readLiteralData("/dataCopy/dc.xmlfrag");
        NamespaceContextImpl c = new NamespaceContextImpl();
        c.setNamespace("emp", "http://packtpub.com/service/employee/");
        c.setNamespace("aln", "http://packtpub.com/service/airline/");
        DataCopyOperation copy = this.getCopyFrom("emp:employee/emp:FirstName[1]");
        copy.retrieveTextNodes(parent, (NamespaceContext)c);
        String textNodeFrom = copy.getCopiedValue();
        Assert.assertEquals((Object)"Phil", (Object)textNodeFrom);
        DataCopyOperation copy2 = this.getCopyFrom("emp:employee/emp:LastName/@myName");
        copy2.retrieveTextNodes(parent, (NamespaceContext)c);
        String attribute = copy2.getCopiedValue();
        Assert.assertEquals((Object)"Huhu", (Object)attribute);
    }

    @Test
    public void testSimplePut() throws Exception {
        Element parent = TestUtil.readLiteralData("/dataCopy/dc.xmlfrag");
        NamespaceContextImpl c = new NamespaceContextImpl();
        c.setNamespace("emp", "http://packtpub.com/service/employee/");
        c.setNamespace("aln", "http://packtpub.com/service/airline/");
        DataCopyOperation copy = this.getCopyTo("emp:employee/emp:FirstName");
        copy.setCopiedValue("Amen");
        copy.setTextNodes(parent, (NamespaceContext)c);
        Node firstNameElement = TestUtil.getNode(parent, c, "emp:employee/emp:FirstName");
        Assert.assertEquals((Object)"Amen", (Object)firstNameElement.getTextContent());
        DataCopyOperation copy2 = this.getCopyTo("emp:employee/emp:LastName/@myName");
        copy2.setCopiedValue("Foo");
        copy2.setTextNodes(parent, (NamespaceContext)c);
        Element lastName = (Element)TestUtil.getNode(parent, c, "emp:employee/emp:LastName");
        Assert.assertEquals((Object)"Foo", (Object)lastName.getAttribute("myName"));
    }
}

