/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.framework.verify;

import net.bpelunit.framework.exception.SpecificationException;
import net.bpelunit.framework.verify.PartnersHaveUniqueNamesValidator;
import net.bpelunit.framework.xml.suite.XMLDeploymentSection;
import net.bpelunit.framework.xml.suite.XMLTestSuite;
import net.bpelunit.framework.xml.suite.XMLTestSuiteDocument;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class PartnersHaveUniqueNamesValidatorTest {
    private XMLDeploymentSection deployment;
    private XMLTestSuiteDocument testSuiteDoc;
    private PartnersHaveUniqueNamesValidator validator = new PartnersHaveUniqueNamesValidator();

    @Before
    public void setUp() {
        this.testSuiteDoc = XMLTestSuiteDocument.Factory.newInstance();
        XMLTestSuite testSuite = this.testSuiteDoc.addNewTestSuite();
        this.deployment = testSuite.addNewDeployment();
    }

    @Test
    public void testAllPartnerNamesUnique() throws Exception {
        this.deployment.addNewPartner().setName("A");
        this.deployment.addNewPartner().setName("B");
        this.deployment.addNewHumanPartner().setName("C");
        this.deployment.addNewHumanPartner().setName("D");
        this.validator.validate(this.testSuiteDoc);
    }

    @Test(expected=SpecificationException.class)
    public void testTwoSOAPPartnersWithSameName() throws Exception {
        this.deployment.addNewPartner().setName("A");
        this.deployment.addNewPartner().setName("B");
        this.deployment.addNewPartner().setName("A");
        this.deployment.addNewHumanPartner().setName("C");
        this.deployment.addNewHumanPartner().setName("D");
        this.validator.validate(this.testSuiteDoc);
    }

    @Test(expected=SpecificationException.class)
    public void testTwoHumanPartnersWithSameName() throws Exception {
        this.deployment.addNewPartner().setName("A");
        this.deployment.addNewPartner().setName("B");
        this.deployment.addNewHumanPartner().setName("C");
        this.deployment.addNewHumanPartner().setName("D");
        this.deployment.addNewHumanPartner().setName("C");
        this.validator.validate(this.testSuiteDoc);
    }

    @Test(expected=SpecificationException.class)
    public void testOneSOAPPartnerAndOneHumanPartnerWithSameName() throws Exception {
        this.deployment.addNewPartner().setName("A");
        this.deployment.addNewPartner().setName("B");
        this.deployment.addNewHumanPartner().setName("C");
        this.deployment.addNewHumanPartner().setName("A");
        this.validator.validate(this.testSuiteDoc);
    }

    @After
    public void tearDown() {
        this.deployment = null;
        this.testSuiteDoc = null;
    }
}

