/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.framework.control.result;

import java.io.OutputStream;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.bpelunit.framework.control.result.XMLResultProducer;
import net.bpelunit.framework.model.test.TestSuite;
import net.bpelunit.framework.model.test.report.ArtefactStatus;
import net.bpelunit.framework.xml.result.XMLArtefact;
import net.bpelunit.framework.xml.result.XMLData;
import net.bpelunit.framework.xml.result.XMLInfo;
import net.bpelunit.framework.xml.result.XMLPartnerTrack;
import net.bpelunit.framework.xml.result.XMLReceiveCondition;
import net.bpelunit.framework.xml.result.XMLTestCase;
import net.bpelunit.framework.xml.result.XMLTestResult;
import net.bpelunit.framework.xml.result.XMLTestResultDocument;
import net.bpelunit.test.end2end.End2EndTester;
import net.bpelunit.test.util.StringOutputStream;
import net.bpelunit.test.util.TestTestRunner;
import org.apache.xmlbeans.XmlOptions;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLResultProducerTest {
    @Test
    public void testSendOnlyReceiveOnlyResultsAreValid() throws Exception {
        this.assertValid(this.getResults(End2EndTester.getSendOnlyReceiveOnlyRunner()));
    }

    @Test
    public void testSendReceiveSyncResultsAreValid() throws Exception {
        this.assertValid(this.getResults(End2EndTester.getSendReceiveSyncRunner()));
    }

    @Test
    public void testSendReceiveAsyncResultsAreValid() throws Exception {
        this.assertValid(this.getResults(End2EndTester.getSendReceiveAsyncRunner()));
    }

    @Test
    public void testInvalidAssumptionResultsAreValid() throws Exception {
        TestTestRunner runner = new TestTestRunner("src/test/resources/result/InvalidAssumption/", "WastePaperBasketTestSuite.bpts");
        this.assertValid(this.getResults(runner));
    }

    @Test
    public void testSendOnlyReceiveOnlyResultsAreComplete() throws Exception {
        String sPassed = ArtefactStatus.StatusCode.PASSED.toString();
        HashMap<String, String> passedState = new HashMap<String, String>();
        passedState.put("Status Code", sPassed);
        passedState.put("Status Message", "Passed");
        XMLTestResultDocument resDoc = this.getResults(End2EndTester.getSendOnlyReceiveOnlyRunner());
        XMLTestResult res = resDoc.getTestResult();
        Assert.assertNotNull((Object)res);
        this.assertState((XMLArtefact)res, sPassed, passedState);
        List testCases = res.getTestCaseList();
        Assert.assertEquals((String)"There should be results for 1 test case", (long)1L, (long)testCases.size());
        XMLTestCase testCase = res.getTestCaseArray(0);
        Assert.assertEquals((Object)"Test Case Throw something in!", (Object)testCase.getName());
        this.assertState((XMLArtefact)testCase, sPassed, passedState);
        List partnerTracks = testCase.getPartnerTrackList();
        Assert.assertEquals((String)"There should be 2 partner tracks", (long)2L, (long)partnerTracks.size());
        String[] partnerTrackNames = new String[]{"Partner Track client", "Partner Track WastePaperBasket"};
        for (int iPartnerTrack = 0; iPartnerTrack < partnerTracks.size(); ++iPartnerTrack) {
            XMLPartnerTrack partnerTrack = (XMLPartnerTrack)partnerTracks.get(iPartnerTrack);
            String sPartnerTrackName = partnerTrackNames[iPartnerTrack];
            Assert.assertEquals((Object)sPartnerTrackName, (Object)partnerTrack.getName());
            this.assertState((XMLArtefact)partnerTrack, sPassed, passedState);
            List activities = partnerTrack.getActivityList();
            Assert.assertEquals((String)("Partner track " + sPartnerTrackName + " should have 1 activity"), (long)1L, (long)activities.size());
            XMLPartnerTrack.Activity activity = (XMLPartnerTrack.Activity)activities.get(0);
            this.assertState((XMLArtefact)activity, sPassed, passedState);
            List dataPackages = activity.getDataPackageList();
            Assert.assertEquals((String)("Activity " + activity.getName() + " should have 1 data package"), (long)1L, (long)dataPackages.size());
            XMLData dataPackage = (XMLData)dataPackages.get(0);
            if (iPartnerTrack == 0) {
                this.checkDataPackage(dataPackage, true, new String[]{"Literal XML data", "SOAP Message data", "Plain outgoing message"});
                Assert.assertEquals((String)"Send only activity should have no receive conditions", (long)0L, (long)dataPackage.getReceiveConditionList().size());
                continue;
            }
            this.checkDataPackage(dataPackage, false, new String[]{"Plain incoming message", "SOAP Message data", "Literal XML data"});
            List receiveConds = dataPackage.getReceiveConditionList();
            Assert.assertEquals((String)"Receive only activity should only have 1 condition", (long)1L, (long)receiveConds.size());
            XMLReceiveCondition receiveCond = (XMLReceiveCondition)receiveConds.get(0);
            HashMap<String, String> condState = new HashMap<String, String>();
            String expectedExpression = "wpb:WastePaperBasketUsage/wpb:WasteThrower/text()";
            String expectedValue = "'Phil'";
            condState.put("Expression", "wpb:WastePaperBasketUsage/wpb:WasteThrower/text()");
            condState.put("Value", "'Phil'");
            this.assertState((XMLArtefact)receiveCond, sPassed, passedState);
            this.assertState((XMLArtefact)receiveCond, null, condState);
            XMLReceiveCondition.Condition cond = receiveCond.getCondition();
            Assert.assertNotNull((Object)cond);
            Assert.assertEquals((Object)"wpb:WastePaperBasketUsage/wpb:WasteThrower/text()", (Object)cond.getExpression());
            Assert.assertEquals((Object)"'Phil'", (Object)cond.getExpectedValue());
            Assert.assertEquals(null, (Object)cond.getActualValue());
        }
    }

    private void checkDataPackage(XMLData dataPackage, boolean bIsSend, String[] expectedXmlDataNames) {
        HashMap<String, String> directionState = new HashMap<String, String>();
        directionState.put("Style/Encoding", "document/literal");
        directionState.put("Direction", "INPUT");
        HashMap<String, String> sendState = new HashMap<String, String>();
        sendState.put("Target URL", "http://localhost:7777/ws/WastePaperBasket");
        sendState.put("HTTP Action", "initiate");
        this.assertState((XMLArtefact)dataPackage, null, directionState);
        if (bIsSend) {
            this.assertState((XMLArtefact)dataPackage, null, sendState);
        }
        List xmlDataList = dataPackage.getXmlDataList();
        Assert.assertEquals((String)"Data packages should have 3 <xmlData> elements", (long)3L, (long)xmlDataList.size());
        for (int iData = 0; iData < xmlDataList.size(); ++iData) {
            XMLData.XmlData xmlData = (XMLData.XmlData)xmlDataList.get(iData);
            Assert.assertEquals((Object)expectedXmlDataNames[iData], (Object)xmlData.getName());
            Element firstElement = this.getFirstChildElement(xmlData.getDomNode());
            String expectedName = bIsSend && iData == 0 || !bIsSend && iData == 2 ? "literalData" : "SOAP-ENV:Envelope";
            Assert.assertEquals((Object)expectedName, (Object)firstElement.getNodeName());
        }
    }

    private Element getFirstChildElement(Node domNode) {
        for (Node nChild = domNode.getFirstChild(); nChild != null; nChild = nChild.getNextSibling()) {
            if (!(nChild instanceof Element)) continue;
            return (Element)nChild;
        }
        return null;
    }

    private void assertState(XMLArtefact artefact, String expectedResult, Map<String, String> expectedStateData) {
        if (expectedResult != null) {
            Assert.assertEquals((Object)expectedResult, (Object)artefact.getResult());
        }
        for (XMLInfo info : artefact.getStateList()) {
            String key = info.getName();
            if (expectedStateData.get(key) == null) continue;
            Assert.assertEquals((Object)expectedStateData.get(key), (Object)info.getStringValue());
            expectedStateData.remove(key);
        }
        if (expectedStateData.size() != 0) {
            Assert.fail((String)"Not all expected state values were found");
        }
    }

    private XMLTestResultDocument getResults(TestTestRunner runner) throws Exception {
        runner.testRun();
        StringOutputStream os = new StringOutputStream();
        XMLResultProducer.writeXML((OutputStream)os, (TestSuite)runner.getTestSuite());
        return XMLTestResultDocument.Factory.parse((String)os.getString());
    }

    private void assertValid(XMLTestResultDocument res) {
        ArrayList errors = new ArrayList();
        XmlOptions options = new XmlOptions();
        options.setErrorListener(errors);
        if (!res.validate(options)) {
            StringWriter sW = new StringWriter();
            for (Object o : errors) {
                sW.append(o + "\n");
            }
            Assert.fail((String)("Results should pass XML Schema validation: " + sW.toString() + "\nXML source was:\n\n" + res.toString()));
        }
    }
}

