/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.framework.control.deploy.activebpel;

import java.io.File;
import java.util.Collection;
import net.bpelunit.framework.control.deploy.activebpel.ActiveBPELDeployer;
import net.bpelunit.framework.exception.ConfigurationException;
import net.bpelunit.framework.exception.DeploymentException;
import net.bpelunit.framework.exception.SpecificationException;
import net.bpelunit.test.util.TestTestRunner;
import org.apache.commons.io.FileUtils;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public class ActiveBPELEndToEndTest {
    private static final String TEST_SUITE_DIR = "src/test/resources/engines";
    private static final String TEST_SUITE_FNAME = "tacService-activebpel.bpts";
    private static final String TEST_SUITE_ENDLESS_FNAME = "tacService-activebpel-endless.bpts";
    private static final String TEST_SUITE_INVALID = "tacService-activebpel-invalid.bpts";

    @Test
    public void allTestCasesPass() throws ConfigurationException, DeploymentException, SpecificationException {
        this.checkAssumptions();
        TestTestRunner runner = new TestTestRunner(TEST_SUITE_DIR, TEST_SUITE_FNAME);
        runner.testRun();
        Assert.assertEquals((String)"All test cases should pass", (long)4L, (long)runner.getPassed());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void allTestCasesPassSameDir() throws Exception {
        this.checkAssumptions();
        File testSuiteDir = new File(TEST_SUITE_DIR);
        File cwd = new File(".");
        Collection testFiles = FileUtils.listFiles((File)testSuiteDir, null, (boolean)false);
        try {
            FileUtils.copyDirectory((File)testSuiteDir, (File)cwd);
            TestTestRunner runner = new TestTestRunner(new File(TEST_SUITE_FNAME));
            runner.testRun();
            Assert.assertEquals((String)"All test cases should pass", (long)4L, (long)runner.getPassed());
        }
        finally {
            for (File f : testFiles) {
                new File(f.getName()).delete();
            }
        }
    }

    @Test
    public void endlessLoopIsTerminated() throws ConfigurationException, DeploymentException, SpecificationException {
        this.checkAssumptions();
        TestTestRunner runner = new TestTestRunner(TEST_SUITE_DIR, TEST_SUITE_ENDLESS_FNAME);
        runner.testRun();
        Assert.assertEquals((String)"Only the case with empty input passed", (long)1L, (long)runner.getPassed());
        Assert.assertTrue((String)"Some processes were terminated", (ActiveBPELDeployer._terminatedProcessCount >= 1 ? 1 : 0) != 0);
    }

    @Test
    public void invalidProcessesAreRejected() throws Exception {
        this.checkAssumptions();
        try {
            TestTestRunner runner = new TestTestRunner(TEST_SUITE_DIR, TEST_SUITE_INVALID);
            runner.testRun();
            Assert.fail((String)"A DeploymentException was expected.");
        }
        catch (DeploymentException deploymentException) {
            // empty catch block
        }
    }

    @Test
    public void templateDelaysWork() throws Exception {
        this.checkAssumptions();
        TestTestRunner runner = new TestTestRunner("src/test/resources/engines/activebpel/delay", "EchoFirst.bpts");
        runner.testRun();
        Assert.assertEquals((String)"All tests should have passed", (long)2L, (long)runner.getPassed());
        Assert.assertEquals((String)"No tests should have failed or had errors", (long)0L, (long)runner.getProblems());
    }

    private void checkAssumptions() {
        Assume.assumeNotNull((Object[])new Object[]{System.getenv("CATALINA_HOME")});
        Assume.assumeTrue((boolean)new File(System.getenv("CATALINA_HOME"), "bpr").canRead());
    }
}

