/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.framework.control.datasource.csv;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.bpelunit.framework.control.ext.IDataSource;
import net.bpelunit.framework.exception.DataSourceException;

@IDataSource.DataSource(name="CSV Data Source", shortName="csv", contentTypes={"text/cvs", "text/plain"})
public class CSVDataSource
implements IDataSource {
    private static final String DEFAULT_SEPARATOR = "\t";
    private List<String> headers = null;
    private List<String> lines = null;
    private String[] currentRecord = null;
    private String separator = "\t";
    private int currentLineNumber = -1;

    public String[] getFieldNames() {
        return this.headers.toArray(new String[this.headers.size()]);
    }

    public String getValueFor(String fieldName) {
        int index = this.headers.indexOf(fieldName);
        return this.currentRecord[index];
    }

    public void setRow(int index) throws DataSourceException {
        if (index >= this.lines.size()) {
            throw new DataSourceException(String.format("Index %d out of bounds [0, %d]", index, this.lines.size() - 1));
        }
        this.currentLineNumber = index;
        String line = this.lines.get(this.currentLineNumber);
        this.currentRecord = this.parseLine(line);
    }

    private String[] parseLine(String currentLine) {
        return currentLine.split(this.separator);
    }

    public void loadFromStream(InputStream data) throws DataSourceException {
        this.setSource(new InputStreamReader(data));
    }

    private void setSource(Reader reader) throws DataSourceException {
        try {
            this.lines = new ArrayList<String>();
            BufferedReader in = new BufferedReader(reader);
            this.readColumnHeadersIfNecessary(in);
            while (in.ready()) {
                String line = in.readLine();
                if (line.trim().equals("")) continue;
                this.lines.add(line);
            }
        }
        catch (IOException e) {
            throw new DataSourceException("Invalid data source", (Throwable)e);
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException e) {}
        }
    }

    private void readColumnHeadersIfNecessary(BufferedReader reader) throws IOException, DataSourceException {
        if (this.headersAreAlreadySet()) {
            return;
        }
        if (!reader.ready()) {
            throw new DataSourceException("CSV File contains no header row");
        }
        String headerLine = reader.readLine();
        this.headers = Arrays.asList(this.parseLine(headerLine));
    }

    private boolean headersAreAlreadySet() {
        return this.headers != null;
    }

    public void close() {
        this.lines = null;
    }

    @IDataSource.ConfigurationOption(defaultValue="\t", description="The separator used to divide two values within a row.")
    public void setSeparator(String separator) {
        this.checkIfMayAlterConfiguration();
        this.separator = separator;
    }

    private void checkIfMayAlterConfiguration() {
        if (this.lines != null) {
            throw new IllegalStateException("Data Source is already open - must not set new parse options!");
        }
    }

    @IDataSource.ConfigurationOption(defaultValue="", description="The column names, separated by commas, which shall be used for naming the data columns of the CSV file. Use this option, if the CSV file itself does not have the headers in its first row.")
    public void setHeaders(String headerNames) {
        this.checkIfMayAlterConfiguration();
        if (headerNames != null && !headerNames.equals("")) {
            String[] headerArray = headerNames.split(",");
            this.trim(headerArray);
            this.headers = Arrays.asList(headerArray);
        }
    }

    private void trim(String[] array) {
        for (int i = 0; i < array.length; ++i) {
            array[i] = array[i].trim();
        }
    }

    public int getNumberOfRows() {
        return this.lines.size();
    }
}

