/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.test.end2end;

import net.bpelunit.framework.exception.ConfigurationException;
import net.bpelunit.framework.exception.DeploymentException;
import net.bpelunit.framework.exception.SpecificationException;
import net.bpelunit.test.util.TestTestRunner;
import org.junit.Assert;
import org.junit.Test;

public class End2EndTester {
    private static final String BASEPATH = "src/test/resources/end2end/";

    public static TestTestRunner getSendOnlyReceiveOnlyRunner() throws ConfigurationException, SpecificationException {
        return new TestTestRunner("src/test/resources/end2end/01_SendReceiveOnly/", "WastePaperBasketTestSuite.bpts");
    }

    public static TestTestRunner getSendReceiveSyncRunner() throws ConfigurationException, SpecificationException {
        return new TestTestRunner("src/test/resources/end2end/02_SendReceiveSync/", "CreditRatingServiceTestSuite.bpts");
    }

    public static TestTestRunner getSendReceiveAsyncRunner() throws ConfigurationException, SpecificationException {
        return new TestTestRunner("src/test/resources/end2end/03_SendReceiveAsync/", "LoanServiceTestSuite.bpts");
    }

    @Test
    public void testSendOnlyReceiveOnlyWastePaper() throws ConfigurationException, DeploymentException, SpecificationException {
        TestTestRunner runner = End2EndTester.getSendOnlyReceiveOnlyRunner();
        runner.testRun();
        Assert.assertEquals((long)1L, (long)runner.getPassed());
        Assert.assertEquals((long)0L, (long)runner.getProblems());
    }

    @Test
    public void testSendReceiveSynchronous() throws ConfigurationException, DeploymentException, SpecificationException {
        TestTestRunner runner = End2EndTester.getSendReceiveSyncRunner();
        runner.testRun();
        Assert.assertEquals((long)2L, (long)runner.getPassed());
        Assert.assertEquals((long)0L, (long)runner.getProblems());
    }

    @Test
    public void testSendReceiveAsynchronous() throws ConfigurationException, DeploymentException, SpecificationException {
        TestTestRunner runner = End2EndTester.getSendReceiveAsyncRunner();
        runner.testRun();
        Assert.assertEquals((long)3L, (long)runner.getPassed());
        Assert.assertEquals((long)0L, (long)runner.getProblems());
    }

    @Test
    public void testInvalidBPTS() throws ConfigurationException {
        try {
            new TestTestRunner("src/test/resources/end2end/04_Invalid/", "InvalidTestSuite.bpts");
            Assert.fail((String)"An exception should have been thrown");
        }
        catch (SpecificationException ex) {
            Assert.assertTrue((String)"Validation errors should be included in the SpecificationException", (boolean)ex.getLocalizedMessage().contains("sendOnlyInvalid"));
        }
    }
}

