/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.framework.control.datasource;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import net.bpelunit.framework.control.datasource.DataSourceConfigurationOption;
import net.bpelunit.framework.control.datasource.DataSourceHelper;
import net.bpelunit.framework.control.ext.IDataSource;
import net.bpelunit.framework.exception.DataSourceException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DataSourceHelperTest {
    private MyDataSource dataSource;

    @Before
    public void setUp() {
        this.dataSource = new MyDataSource();
    }

    @Test
    public void testIsValidParameter() throws Exception {
        Assert.assertTrue((boolean)DataSourceHelper.isValidConfigurationOption((IDataSource)this.dataSource, (String)"A"));
        Assert.assertTrue((boolean)DataSourceHelper.isValidConfigurationOption((IDataSource)this.dataSource, (String)"a"));
        Assert.assertTrue((boolean)DataSourceHelper.isValidConfigurationOption((IDataSource)this.dataSource, (String)"B"));
        Assert.assertTrue((boolean)DataSourceHelper.isValidConfigurationOption((IDataSource)this.dataSource, (String)"b"));
        Assert.assertFalse((boolean)DataSourceHelper.isValidConfigurationOption((IDataSource)this.dataSource, (String)"C"));
        Assert.assertFalse((boolean)DataSourceHelper.isValidConfigurationOption((IDataSource)this.dataSource, (String)"AB"));
    }

    @Test
    public void testGetConfigurationOptions() throws Exception {
        List options = DataSourceHelper.getConfigurationOptionsFor((IDataSource)this.dataSource);
        Assert.assertEquals((long)2L, (long)options.size());
        DataSourceConfigurationOption a = (DataSourceConfigurationOption)options.get(0);
        Assert.assertEquals((Object)"A", (Object)a.name);
        Assert.assertEquals((Object)"a", (Object)a.defaultValue);
        Assert.assertEquals((Object)"A description", (Object)a.description);
        DataSourceConfigurationOption b = (DataSourceConfigurationOption)options.get(1);
        Assert.assertEquals((Object)"B", (Object)b.name);
        Assert.assertEquals((Object)"b", (Object)b.defaultValue);
        Assert.assertEquals((Object)"Another description", (Object)b.description);
    }

    @Test
    public void testSetConfigurationOption() throws Exception {
        DataSourceHelper.setConfigurationOption((IDataSource)this.dataSource, (String)"A", (String)"aa");
        Assert.assertEquals((Object)"aa", (Object)this.dataSource.a);
        DataSourceHelper.setConfigurationOption((IDataSource)this.dataSource, (String)"B", (String)"bb");
        Assert.assertEquals((Object)"bb", (Object)this.dataSource.b);
    }

    @Test
    public void testGetInputStreamFromInlineData() throws Exception {
        String data = "ABC";
        InputStream is = DataSourceHelper.getInputStreamFromInlineData((String)data);
        BufferedReader r = new BufferedReader(new InputStreamReader(is));
        String actual = r.readLine();
        Assert.assertEquals((Object)data, (Object)actual);
    }

    @Test
    public void testValidateDataSourceAnnotationWithMissingAnnotation() throws Exception {
        List messages = DataSourceHelper.validateDataSourceAnnotation(DataSourceWithoutAnnotation.class);
        Assert.assertEquals((long)1L, (long)messages.size());
    }

    @Test
    public void testValidateDataSourceAnnotationWithMissingNames() throws Exception {
        List messages = DataSourceHelper.validateDataSourceAnnotation(DataSourceAnnotationWithMissingNames.class);
        Assert.assertEquals((long)2L, (long)messages.size());
    }

    @Test
    public void testValidateDataSourceAnnotationWithEmptyContentType() throws Exception {
        List messages = DataSourceHelper.validateDataSourceAnnotation(DataSourceAnnotationWithEmptyContentType.class);
        Assert.assertEquals((long)1L, (long)messages.size());
    }

    @Test
    public void testValidateMethodAnnotationsWithNoDescriptionWrongNameWrongParameterList() throws Exception {
        List messages = DataSourceHelper.validateMethodAnnotations(MethodAnnotationsWithNoDescriptionWrongNameWrongParameterList.class);
        Assert.assertEquals((long)4L, (long)messages.size());
    }

    @Test
    public void testGetName() {
        MyDataSource ds = new MyDataSource();
        Assert.assertEquals((Object)"Test", (Object)DataSourceHelper.getName((IDataSource)ds));
        Assert.assertEquals((Object)"test", (Object)DataSourceHelper.getShortName((IDataSource)ds));
    }

    @IDataSource.DataSource(name="Test", shortName="test", contentTypes={""})
    public static final class MyDataSource
    extends AbstractDataSource {
        String b;
        String a;

        @IDataSource.ConfigurationOption(defaultValue="a", description="A description")
        public void setA(String a) {
            this.a = a;
        }

        @IDataSource.ConfigurationOption(defaultValue="b", description="Another description")
        public void setB(String b) {
            this.b = b;
        }
    }

    @IDataSource.DataSource(name="Name", shortName="N", contentTypes={"", "A"})
    private static final class DataSourceAnnotationWithEmptyContentType
    extends AbstractDataSource {
        private DataSourceAnnotationWithEmptyContentType() {
        }
    }

    @IDataSource.DataSource(name="", shortName="", contentTypes={})
    private static final class DataSourceAnnotationWithMissingNames
    extends AbstractDataSource {
        private DataSourceAnnotationWithMissingNames() {
        }
    }

    @IDataSource.DataSource(contentTypes={}, name="Name", shortName="N")
    private static final class MethodAnnotationsWithNoDescriptionWrongNameWrongParameterList
    extends AbstractDataSource {
        private MethodAnnotationsWithNoDescriptionWrongNameWrongParameterList() {
        }

        @IDataSource.ConfigurationOption(defaultValue="", description="")
        public boolean myConfigurationOption() {
            return false;
        }
    }

    private static final class DataSourceWithoutAnnotation
    extends AbstractDataSource {
        private DataSourceWithoutAnnotation() {
        }
    }

    private static class AbstractDataSource
    implements IDataSource {
        private AbstractDataSource() {
        }

        public void close() {
        }

        public String[] getFieldNames() {
            return null;
        }

        public int getNumberOfRows() {
            return 0;
        }

        public Object getValueFor(String fieldName) {
            return null;
        }

        public void loadFromStream(InputStream is) throws DataSourceException {
        }

        public void setRow(int rowIndex) throws DataSourceException {
        }
    }
}

