/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.framework.control.datasource;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import net.bpelunit.framework.control.datasource.DataSourceUtil;
import net.bpelunit.framework.exception.DataSourceException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mortbay.http.HttpContext;
import org.mortbay.http.HttpHandler;
import org.mortbay.http.HttpListener;
import org.mortbay.http.HttpServer;
import org.mortbay.http.SocketListener;
import org.mortbay.http.handler.ResourceHandler;

public class DataSourceContentReferencesTest {
    private static final String FILE_SOURCE_DIR = "src/test/resources/templates/";
    private static final String FILE_SOURCE_BASENAME = "tacService-data.vm";
    private static final String EXPECTED_FILE_CONTENTS = "#set($lines = [[], ['A'], ['A','B'], ['A','B','C']])";
    private static final String FILE_SOURCE_PATH = "src/test/resources/templates/" + File.separator + "tacService-data.vm";
    private static String FILE_SOURCE_ABSPATH;
    private HttpServer fHttpServer;
    private static final int HTTP_PORT = 7945;
    private static final String HTTP_SOURCE_URL = "http://127.0.0.1:7945/tacService-data.vm";

    @Before
    public void setUp() throws Exception {
        FILE_SOURCE_ABSPATH = new File(FILE_SOURCE_PATH).getCanonicalPath();
        this.fHttpServer = new HttpServer();
        SocketListener sockListener = new SocketListener();
        sockListener.setPort(7945);
        this.fHttpServer.addListener((HttpListener)sockListener);
        HttpContext context = new HttpContext();
        context.setContextPath("/");
        context.setResourceBase(FILE_SOURCE_DIR);
        context.addHandler((HttpHandler)new ResourceHandler());
        this.fHttpServer.addContext(context);
        this.fHttpServer.start();
    }

    @After
    public void tearDown() throws Exception {
        this.fHttpServer.stop();
    }

    @Test
    public void bothMissingIsReported() {
        try {
            DataSourceUtil.getStreamForDataSource(null, null, null);
            Assert.fail((String)"A DataSourceException was expected");
        }
        catch (DataSourceException dataSourceException) {
            // empty catch block
        }
    }

    @Test
    public void bothSpecifiedIsReported() {
        try {
            DataSourceUtil.getStreamForDataSource((String)"foo", (String)"bar", null);
            Assert.fail((String)"A DataSourceException was expected");
        }
        catch (DataSourceException dataSourceException) {
            // empty catch block
        }
    }

    @Test
    public void inlineContents() throws Exception {
        String contents = "test";
        InputStream is = DataSourceUtil.getStreamForDataSource((String)"test", null, null);
        BufferedReader rIs = new BufferedReader(new InputStreamReader(is));
        rIs.readLine().equals("test");
    }

    @Test
    public void relativeFilePath() throws Exception {
        this.canReadContentsFrom(FILE_SOURCE_PATH);
    }

    @Test
    public void absoluteFilePath() throws Exception {
        this.canReadContentsFrom(FILE_SOURCE_ABSPATH);
    }

    @Test
    public void fileURL() throws Exception {
        this.canReadContentsFrom(new File(FILE_SOURCE_ABSPATH).toURI().toURL().toExternalForm());
    }

    @Test
    public void httpURL() throws Exception {
        this.canReadContentsFrom(HTTP_SOURCE_URL);
    }

    private void canReadContentsFrom(String path) throws DataSourceException, IOException {
        InputStream is = DataSourceUtil.getStreamForDataSource(null, (String)path, (File)new File("."));
        BufferedReader rIs = new BufferedReader(new InputStreamReader(is));
        rIs.readLine().equals(EXPECTED_FILE_CONTENTS);
    }
}

