/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.framework.ui.command;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.bpelunit.framework.BPELUnitRunner;
import net.bpelunit.framework.base.BPELUnitBaseRunner;
import net.bpelunit.framework.control.result.ITestResultListener;
import net.bpelunit.framework.control.result.XMLResultProducer;
import net.bpelunit.framework.control.util.BPELUnitConstants;
import net.bpelunit.framework.control.util.BPELUnitUtil;
import net.bpelunit.framework.coverage.ICoverageMeasurementTool;
import net.bpelunit.framework.coverage.result.XMLCoverageResultProducer;
import net.bpelunit.framework.exception.ConfigurationException;
import net.bpelunit.framework.exception.DeploymentException;
import net.bpelunit.framework.exception.SpecificationException;
import net.bpelunit.framework.exception.TestCaseNotFoundException;
import net.bpelunit.framework.model.test.PartnerTrack;
import net.bpelunit.framework.model.test.TestCase;
import net.bpelunit.framework.model.test.TestSuite;
import net.bpelunit.framework.model.test.data.XMLData;
import net.bpelunit.framework.model.test.report.ITestArtefact;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Appender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.varia.NullAppender;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BPELUnitCommandLineRunner
extends BPELUnitBaseRunner
implements ITestResultListener {
    private static final int MAX_LINE_LENGTH = 800;
    private static boolean coverageDetailed = false;
    private boolean fVerbose;
    private String fXmlFileName;
    private String fLogFileName;
    private String fCovFileName;

    public BPELUnitCommandLineRunner(boolean verbose, String xmlFileName, String logFileName, String covFileName) {
        this.fVerbose = verbose;
        this.fXmlFileName = xmlFileName;
        this.fLogFileName = logFileName;
        this.fCovFileName = covFileName;
    }

    public static void main(String[] args) {
        File testSuiteFile;
        System.out.println("BPELUnit Command Line Runner");
        System.out.println("---------------------------------------------");
        int index = 0;
        boolean verbose = false;
        String logFileName = null;
        String xmlFileName = null;
        String coverageFileName = null;
        coverageDetailed = false;
        if (args.length == 0) {
            BPELUnitCommandLineRunner.abort();
        }
        if ("-v".equals(args[0])) {
            ++index;
            verbose = true;
        }
        if (args.length < index + 1) {
            BPELUnitCommandLineRunner.abort();
        }
        if (args[index].startsWith("-x")) {
            xmlFileName = BPELUnitCommandLineRunner.findFileName(args[index], "xml");
            ++index;
        }
        if (args.length < index + 1) {
            BPELUnitCommandLineRunner.abort();
        }
        if (args[index].startsWith("-l")) {
            logFileName = BPELUnitCommandLineRunner.findFileName(args[index], "log");
            ++index;
        }
        if (args[index].startsWith("-c")) {
            coverageFileName = BPELUnitCommandLineRunner.findFileName(args[index], "xml");
            ++index;
        } else if (args[index].startsWith("-d")) {
            coverageFileName = BPELUnitCommandLineRunner.findFileName(args[index], "xml");
            coverageDetailed = true;
            ++index;
        }
        if (args.length < index + 1) {
            BPELUnitCommandLineRunner.abort();
        }
        if (!(testSuiteFile = new File(args[index])).exists()) {
            BPELUnitCommandLineRunner.abort("Cannot find test suite file with path " + testSuiteFile);
        }
        ArrayList<String> testCaseNames = new ArrayList<String>();
        for (int i = index + 1; i < args.length; ++i) {
            testCaseNames.add(args[i]);
        }
        new BPELUnitCommandLineRunner(verbose, xmlFileName, logFileName, coverageFileName).run(testSuiteFile, testCaseNames);
    }

    private static void abort(String string) {
        System.out.println(string);
        System.exit(1);
    }

    private static void abort() {
        System.out.println("Usage: bpelunit [-v] [-x=filename] [-l=filename] [-c=filename]|[-d=filename] testsuite.bpts [testcase1] [testcase2]");
        System.out.println("\t\t-v adds detailed output");
        System.out.println("\t\t-x=filename send XML output into the given file");
        System.out.println("\t\t-l=filename send logging messages into the given file");
        System.out.println("\t\t-c=filename send test coverage into the given file");
        System.out.println("\t\t-d=filename send detailed test coverage into the given file");
        System.exit(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run(File testSuiteFile, List<String> testCaseNames) {
        try {
            HashMap<String, String> options;
            if (this.fCovFileName != null) {
                options = new HashMap<String, String>();
                options.put("MEASURE_COVERAGE", "true");
            } else {
                options = BPELUnitConstants.NULL_OPTIONS;
            }
            this.initialize(options);
            System.out.println("Loading Test Suite...");
            TestSuite suite = this.loadTestSuite(testSuiteFile);
            for (String string : testCaseNames) {
                if (suite.hasTestCase(string)) continue;
                BPELUnitCommandLineRunner.abort("Suite does not have test case with name " + string);
            }
            System.out.println("Test Suite sucessfully loaded.");
            System.out.println("Deploying Services...");
            try {
                suite.setUp();
            }
            catch (DeploymentException e) {
                System.out.println("A deployment error occurred when deploying services for this test suite:");
                System.out.println("  " + e.getMessage());
                try {
                    suite.shutDown();
                }
                catch (DeploymentException e1) {
                    // empty catch block
                }
                System.exit(1);
            }
            System.out.println("Services successfully deployed.");
            System.out.println("Running Test Cases...");
            suite.addResultListener((ITestResultListener)this);
            if (testCaseNames.size() > 0) {
                try {
                    suite.setFilter(testCaseNames);
                }
                catch (TestCaseNotFoundException e1) {
                    // empty catch block
                }
            }
            suite.run();
            suite.removeResultListener((ITestResultListener)this);
            System.out.println("Done running test cases.");
            if (this.fXmlFileName != null) {
                try {
                    XMLResultProducer.writeXML((OutputStream)new FileOutputStream(this.fXmlFileName), (TestSuite)suite);
                }
                catch (Exception e) {
                    System.out.println("Sorry - could not write XML output to " + this.fXmlFileName + ": " + e.getMessage());
                }
            }
            System.out.println("Undeploying services...");
            try {
                suite.shutDown();
            }
            catch (DeploymentException e) {
                System.out.println("An undeployment error occurred when undeploying services for this test suite:");
                System.out.println("  " + e.getMessage());
                System.exit(1);
            }
            if (this.fCovFileName != null) {
                try {
                    ICoverageMeasurementTool tool = BPELUnitRunner.getCoverageMeasurmentTool();
                    if (tool != null) {
                        XMLCoverageResultProducer.writeResult((OutputStream)new FileOutputStream(this.fCovFileName), (List)tool.getStatistics(), (String)tool.getErrorStatus(), (boolean)coverageDetailed);
                    }
                }
                catch (IOException e) {
                    System.out.println("Sorry - could not write XML coverage output to " + this.fCovFileName + ": " + e.getMessage());
                    e.printStackTrace();
                }
            }
            System.out.println("Services undeployed.");
            System.out.println("Shutting down. Have a nice day!");
        }
        catch (ConfigurationException e) {
            System.out.println("A configuration error was encountered when initializing BPELUnit:");
            System.out.println(" " + e.getMessage());
            System.exit(1);
        }
        catch (SpecificationException e) {
            System.out.println("An error was encountered when reading the test suite specification:");
            System.out.println(" " + e.getMessage());
            System.exit(1);
        }
        finally {
            BPELUnitRunner.setCoverageMeasurmentTool(null);
        }
    }

    public void testCaseEnded(TestCase test) {
        String status = "ended";
        String error = null;
        if (test.getStatus().isError()) {
            status = "had an error";
            error = test.getStatus().getMessage();
        }
        if (test.getStatus().isFailure()) {
            status = "failed";
            error = test.getStatus().getMessage();
        }
        if (test.getStatus().isAborted()) {
            status = "was aborted";
        }
        if (test.getStatus().isPassed()) {
            status = "passed";
        }
        System.out.println("Test Case " + status + ": " + test.getName() + "." + (error != null ? error : ""));
    }

    public void testCaseStarted(TestCase test) {
        if (this.fVerbose) {
            System.out.println("Test Case started: " + test.getName() + ".\n");
        }
    }

    public void progress(ITestArtefact test) {
        if (this.fVerbose && test instanceof PartnerTrack) {
            System.out.println(BPELUnitCommandLineRunner.createReadableOutput(test, false));
        }
    }

    private static String createReadableOutput(ITestArtefact artefact, boolean recursive) {
        return BPELUnitCommandLineRunner.createReadableOutputInternal(artefact, recursive, "");
    }

    private static String createReadableOutputInternal(ITestArtefact artefact, boolean recursive, String inline) {
        StringBuffer output = new StringBuffer();
        output.append(inline + "<Artefact \"" + artefact.getName() + "\">\n");
        String internalInline = inline + "  ";
        output.append(internalInline + "Status: " + artefact.getStatus().toString() + "\n");
        if (recursive) {
            for (ITestArtefact child : artefact.getChildren()) {
                if (artefact instanceof XMLData) {
                    XMLData sd = (XMLData)artefact;
                    output.append(internalInline + sd.getName() + " : " + StringUtils.abbreviate((String)BPELUnitUtil.removeSpaceLineBreaks((String)sd.getXmlData()), (int)800) + "\n");
                    continue;
                }
                output.append(BPELUnitCommandLineRunner.createReadableOutputInternal(child, recursive, internalInline));
            }
        }
        output.append(inline + "</Artefact \"" + artefact.getName() + "\">\n");
        return output.toString();
    }

    public void configureLogging() throws ConfigurationException {
        Logger.getRootLogger().removeAllAppenders();
        if (this.fLogFileName != null) {
            try {
                Logger.getRootLogger().addAppender((Appender)new FileAppender((Layout)new PatternLayout(), this.fLogFileName));
            }
            catch (IOException e) {
                System.out.println("Error trying to write to log file. Disabling logging...");
            }
            Logger.getRootLogger().setLevel(Level.INFO);
        } else {
            Logger.getRootLogger().addAppender((Appender)new NullAppender());
        }
    }

    private static String findFileName(String string, String type) {
        String logFileName = null;
        int i = string.indexOf(61);
        if (i != -1) {
            logFileName = string.substring(i + 1);
            try {
                new File(logFileName).createNewFile();
            }
            catch (IOException e) {
                BPELUnitCommandLineRunner.abort("Problem creating " + type + " file: " + e.getMessage());
            }
        } else {
            BPELUnitCommandLineRunner.abort(type + " file not specified!");
        }
        return logFileName;
    }
}

