/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.framework.model.test.data;

import java.util.List;
import javax.wsdl.Binding;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.BindingOutput;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.extensions.ElementExtensible;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.wsdl.extensions.soap.SOAPBinding;
import javax.wsdl.extensions.soap.SOAPBody;
import javax.wsdl.extensions.soap.SOAPOperation;
import javax.xml.namespace.QName;
import net.bpelunit.framework.exception.SpecificationException;
import net.bpelunit.framework.model.test.data.SOAPOperationDirectionIdentifier;

public class SOAPOperationCallIdentifier {
    private Definition fDefinition;
    private Service fService;
    private Port fPort;
    private Binding fBinding;
    private BindingOperation fOperation;
    private SOAPOperationDirectionIdentifier fDirection;

    public SOAPOperationCallIdentifier(Definition fWSDLDefinition, QName service, String port, String operationName, SOAPOperationDirectionIdentifier direction) throws SpecificationException {
        this.fDefinition = fWSDLDefinition;
        this.fService = fWSDLDefinition.getService(service);
        if (this.fService == null) {
            throw new SpecificationException("Specified service \"" + service + "\" was not found in partner WSDL " + fWSDLDefinition.getQName());
        }
        this.fPort = this.fService.getPort(port);
        if (this.fPort == null) {
            throw new SpecificationException("Specified port \"" + port + "\" was not found in service " + service + " in partner WSDL " + fWSDLDefinition.getQName());
        }
        this.fBinding = this.fPort.getBinding();
        if (this.fBinding == null) {
            throw new SpecificationException("Could not find a binding for service \"" + service + "\" and port \"" + port + "\" in partner WSDL " + fWSDLDefinition.getQName());
        }
        this.fOperation = this.fBinding.getBindingOperation(operationName, null, null);
        if (this.fOperation == null) {
            throw new SpecificationException("Specified operation \"" + operationName + "\" was not found in binding \"" + this.fBinding.getQName() + "\" in partner WSDL " + "\"" + fWSDLDefinition.getQName() + "\"");
        }
        this.fDirection = direction;
    }

    public String getTargetNamespace() {
        return this.fDefinition.getTargetNamespace();
    }

    public String getName() {
        return this.fOperation.getName();
    }

    public SOAPOperationDirectionIdentifier getDirection() {
        return this.fDirection;
    }

    public boolean isFault() {
        return this.fDirection == SOAPOperationDirectionIdentifier.FAULT;
    }

    public Service getService() {
        return this.fService;
    }

    public Port getPort() {
        return this.fPort;
    }

    public Binding getBinding() {
        return this.fBinding;
    }

    public BindingOperation getBindingOperation() {
        return this.fOperation;
    }

    public String getEncodingStyle() throws SpecificationException {
        String encoding;
        SOAPBinding sBinding = null;
        List extensibilityElements = this.fBinding.getExtensibilityElements();
        for (Object supposedSOAPBinding : extensibilityElements) {
            if (!(supposedSOAPBinding instanceof SOAPBinding)) continue;
            sBinding = (SOAPBinding)supposedSOAPBinding;
        }
        if (sBinding == null) {
            throw new SpecificationException("Could not find SOAP Binding element in binding " + this.fBinding);
        }
        String style = sBinding.getStyle();
        if (this.isFault()) {
            style = "document";
        }
        if (style == null) {
            style = this.getSOAPOperation().getStyle();
        }
        if (style == null) {
            style = "document";
        }
        if ((encoding = this.getEncoding(this.fOperation)) == null) {
            encoding = "literal";
        }
        return style + "/" + encoding;
    }

    public String getSOAPHTTPAction() {
        return this.getSOAPOperation().getSoapActionURI();
    }

    public String getTargetURL() throws SpecificationException {
        List extensibilityElements = this.fPort.getExtensibilityElements();
        for (Object supposedSOAPAddress : extensibilityElements) {
            if (!(supposedSOAPAddress instanceof SOAPAddress)) continue;
            SOAPAddress adr = (SOAPAddress)supposedSOAPAddress;
            return adr.getLocationURI();
        }
        throw new SpecificationException("I could not find a target URL for operation " + this);
    }

    public String getBodyNamespace() {
        SOAPBody soapBody = SOAPOperationDirectionIdentifier.INPUT.equals((Object)this.getDirection()) ? this.getSoapBody((ElementExtensible)this.fOperation.getBindingInput()) : this.getSoapBody((ElementExtensible)this.fOperation.getBindingOutput());
        if (soapBody != null && soapBody.getNamespaceURI() != null) {
            return soapBody.getNamespaceURI();
        }
        return this.getTargetNamespace();
    }

    private SOAPOperation getSOAPOperation() {
        List extensibilityElements2 = this.fOperation.getExtensibilityElements();
        for (Object supposedSOAPOperation : extensibilityElements2) {
            if (!(supposedSOAPOperation instanceof SOAPOperation)) continue;
            return (SOAPOperation)supposedSOAPOperation;
        }
        return null;
    }

    private String getEncoding(BindingOperation wsdlOperation) {
        String use = null;
        BindingInput bindingInput = wsdlOperation.getBindingInput();
        if (bindingInput != null && (use = this.getUse((ElementExtensible)bindingInput)) != null) {
            return use;
        }
        BindingOutput bindingOutput = wsdlOperation.getBindingOutput();
        if (bindingOutput != null && (use = this.getUse((ElementExtensible)bindingOutput)) != null) {
            return use;
        }
        return null;
    }

    private String getUse(ElementExtensible bindingInput) {
        SOAPBody body = this.getSoapBody(bindingInput);
        if (body != null) {
            return body.getUse();
        }
        return null;
    }

    private SOAPBody getSoapBody(ElementExtensible bindingInput) {
        List extensibilityElements = bindingInput.getExtensibilityElements();
        for (Object supposedSOAPBody : extensibilityElements) {
            if (!(supposedSOAPBody instanceof SOAPBody)) continue;
            return (SOAPBody)supposedSOAPBody;
        }
        return null;
    }

    public String toString() {
        return "SOAP Operation " + this.fDefinition.getTargetNamespace() + " -> " + this.fPort.getName() + " -> " + this.fOperation.getName();
    }
}

